/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.transport.ConnectOptions;
import com.refinitiv.eta.transport.TransportFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenEventCallback;

public class ReactorConnectInfo {
    private static final int DEFAULT_SERVICE_DISCOVERY_RETRY_COUNT = 3;
    private boolean _enableSessionManagement = false;
    private String _location = "us-east-1";
    private ReactorAuthTokenEventCallback _reactorAuthTokenEventCallback = null;
    ConnectOptions _connectOptions = null;
    int DEFAULT_TIMEOUT;
    int _initTimeout = this.DEFAULT_TIMEOUT = 60;
    int _serviceDiscoveryRetryCount = 3;

    ReactorConnectInfo() {
        this._connectOptions = TransportFactory.createConnectOptions();
    }

    public ConnectOptions connectOptions() {
        return this._connectOptions;
    }

    public int initTimeout(int timeout) {
        if (timeout < 1) {
            return -4;
        }
        this._initTimeout = timeout;
        return 0;
    }

    public int initTimeout() {
        return this._initTimeout;
    }

    public void clear() {
        this._connectOptions.clear();
        this._enableSessionManagement = false;
        this._location = "us-east-1";
        this._reactorAuthTokenEventCallback = null;
        this._initTimeout = this.DEFAULT_TIMEOUT;
        this._serviceDiscoveryRetryCount = 3;
    }

    public int copy(ReactorConnectInfo destInfo) {
        if (destInfo == null) {
            return -1;
        }
        this._connectOptions.copy(destInfo._connectOptions);
        destInfo._enableSessionManagement = this._enableSessionManagement;
        destInfo._location = this._location;
        destInfo._reactorAuthTokenEventCallback = this._reactorAuthTokenEventCallback;
        destInfo._initTimeout = this._initTimeout;
        destInfo._serviceDiscoveryRetryCount = this._serviceDiscoveryRetryCount;
        return 0;
    }

    public int reactorAuthTokenEventCallback(ReactorAuthTokenEventCallback callback) {
        if (callback == null) {
            return -5;
        }
        this._reactorAuthTokenEventCallback = callback;
        return 0;
    }

    public ReactorAuthTokenEventCallback reactorAuthTokenEventCallback() {
        return this._reactorAuthTokenEventCallback;
    }

    public void enableSessionManagement(boolean enableSessionManagement) {
        this._enableSessionManagement = enableSessionManagement;
    }

    public boolean enableSessionManagement() {
        return this._enableSessionManagement;
    }

    public void location(String location) {
        this._location = location;
    }

    public String location() {
        return this._location;
    }

    public void serviceDiscoveryRetryCount(int count) {
        this._serviceDiscoveryRetryCount = count;
    }

    public int serviceDiscoveryRetryCount() {
        return this._serviceDiscoveryRetryCount;
    }
}

