/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryClose;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryRequest;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryRequest;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRTT;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRequest;
import com.refinitiv.eta.valueadd.reactor.ConsumerWatchlistOptions;
import com.refinitiv.eta.valueadd.reactor.RDMDictionaryMsgCallback;
import com.refinitiv.eta.valueadd.reactor.RDMDirectoryMsgCallback;
import com.refinitiv.eta.valueadd.reactor.RDMLoginMsgCallback;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenEventCallback;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredential;
import com.refinitiv.eta.valueadd.reactor.ReactorRole;

public class ConsumerRole
extends ReactorRole {
    LoginRequest _loginRequest = null;
    LoginRTT loginRTT = null;
    DirectoryRequest _directoryRequest = null;
    DictionaryRequest _fieldDictionaryRequest = null;
    DictionaryClose _fieldDictionaryClose = null;
    DictionaryRequest _enumDictionaryRequest = null;
    DictionaryClose _enumDictionaryClose = null;
    ReactorAuthTokenEventCallback _reactorAuthTokenEventCallback = null;
    RDMLoginMsgCallback _loginMsgCallback = null;
    RDMDirectoryMsgCallback _directoryMsgCallback = null;
    RDMDictionaryMsgCallback _dictionaryMsgCallback = null;
    ConsumerWatchlistOptions _consumerWatchlistOptions = null;
    int _dictionaryDownloadMode = 0;
    Buffer _fieldDictionaryName = CodecFactory.createBuffer();
    Buffer _enumTypeDictionaryName = CodecFactory.createBuffer();
    boolean _receivedFieldDictionaryResp = false;
    boolean _receivedEnumDictionaryResp = false;
    boolean rttEnabled = false;
    Buffer _clientId = CodecFactory.createBuffer();
    ReactorOAuthCredential _reactorOAuthCredential = null;
    static final int LOGIN_STREAM_ID = 1;
    static final int DIRECTORY_STREAM_ID = 2;
    static final int FIELD_DICTIONARY_STREAM_ID = 3;
    static final int ENUM_DICTIONARY_STREAM_ID = 4;
    static final long FILTER_TO_REQUEST = 7L;

    public ConsumerRole() {
        this._type = 1;
        this._fieldDictionaryName.data("RWFFld");
        this._enumTypeDictionaryName.data("RWFEnum");
        this._consumerWatchlistOptions = new ConsumerWatchlistOptions();
    }

    public void rdmLoginRequest(LoginRequest loginRequest) {
        this.copyLoginRequest(loginRequest);
    }

    public LoginRequest rdmLoginRequest() {
        return this._loginRequest;
    }

    public void initDefaultRDMLoginRequest() {
        int streamId;
        String userName = "";
        if (this._loginRequest == null) {
            streamId = 1;
            this._loginRequest = (LoginRequest)LoginMsgFactory.createMsg();
        } else {
            streamId = this._loginRequest.streamId() == 0 ? 1 : this._loginRequest.streamId();
            userName = this._loginRequest.userName().toString();
            this._loginRequest.clear();
        }
        this._loginRequest.rdmMsgType(LoginMsgType.REQUEST);
        this._loginRequest.initDefaultRequest(streamId);
        this._loginRequest.applyHasAttrib();
        if (!userName.equals("")) {
            this._loginRequest.userName().data(userName);
        }
        this._loginRequest.applyHasRole();
        this._loginRequest.role(0L);
    }

    public void initDefaultLoginRTT() {
        int streamId;
        if (this.loginRTT == null) {
            streamId = 1;
            this.loginRTT = (LoginRTT)LoginMsgFactory.createMsg();
        } else {
            streamId = this.loginRTT.streamId() == 0 ? 1 : this.loginRTT.streamId();
            this.loginRTT.clear();
        }
        this.loginRTT.rdmMsgType(LoginMsgType.RTT);
        this.loginRTT.initRTT(streamId);
    }

    public void rdmDirectoryRequest(DirectoryRequest directoryRequest) {
        this.copyDirectoryRequest(directoryRequest);
    }

    public DirectoryRequest rdmDirectoryRequest() {
        return this._directoryRequest;
    }

    public void initDefaultRDMDirectoryRequest() {
        int streamId;
        if (this._directoryRequest == null) {
            streamId = 2;
            this._directoryRequest = (DirectoryRequest)DirectoryMsgFactory.createMsg();
        } else {
            streamId = this._directoryRequest.streamId() == 0 ? 2 : this._directoryRequest.streamId();
            this._directoryRequest.clear();
        }
        this._directoryRequest.rdmMsgType(DirectoryMsgType.REQUEST);
        this._directoryRequest.streamId(streamId);
        this._directoryRequest.filter(7L);
        this._directoryRequest.applyStreaming();
    }

    public void reactorOAuthCredential(ReactorOAuthCredential reactorOAuthCredential) {
        this.copyReactorOAuthCredential(reactorOAuthCredential);
    }

    public ReactorOAuthCredential reactorOAuthCredential() {
        return this._reactorOAuthCredential;
    }

    Buffer fieldDictionaryName() {
        return this._fieldDictionaryName;
    }

    void rdmFieldDictionaryRequest(DictionaryRequest fieldDictionaryRequest) {
        this._fieldDictionaryRequest = fieldDictionaryRequest;
    }

    DictionaryRequest rdmFieldDictionaryRequest() {
        return this._fieldDictionaryRequest;
    }

    void initDefaultRDMFieldDictionaryRequest() {
        int streamId;
        if (this._fieldDictionaryRequest == null) {
            streamId = 3;
            this._fieldDictionaryRequest = (DictionaryRequest)DictionaryMsgFactory.createMsg();
        } else {
            streamId = this._fieldDictionaryRequest.streamId() == 0 ? 3 : this._fieldDictionaryRequest.streamId();
            this._fieldDictionaryRequest.clear();
        }
        while (streamId == this._loginRequest.streamId() || streamId == this._directoryRequest.streamId()) {
            ++streamId;
        }
        this._fieldDictionaryRequest.rdmMsgType(DictionaryMsgType.REQUEST);
        this._fieldDictionaryRequest.streamId(streamId);
        this._fieldDictionaryRequest.applyStreaming();
        this._fieldDictionaryRequest.verbosity(7);
        this._fieldDictionaryRequest.dictionaryName(this._fieldDictionaryName);
    }

    DictionaryClose rdmFieldDictionaryClose() {
        if (this._fieldDictionaryRequest == null) {
            return null;
        }
        if (this._fieldDictionaryClose == null) {
            this._fieldDictionaryClose = (DictionaryClose)DictionaryMsgFactory.createMsg();
            this._fieldDictionaryClose.rdmMsgType(DictionaryMsgType.CLOSE);
        }
        this._fieldDictionaryClose.streamId(this._fieldDictionaryRequest.streamId());
        return this._fieldDictionaryClose;
    }

    Buffer enumTypeDictionaryName() {
        return this._enumTypeDictionaryName;
    }

    void rdmEnumDictionaryRequest(DictionaryRequest enumDictionaryRequest) {
        this._enumDictionaryRequest = enumDictionaryRequest;
    }

    DictionaryRequest rdmEnumDictionaryRequest() {
        return this._enumDictionaryRequest;
    }

    void initDefaultRDMEnumDictionaryRequest() {
        int streamId;
        if (this._enumDictionaryRequest == null) {
            streamId = 4;
            this._enumDictionaryRequest = (DictionaryRequest)DictionaryMsgFactory.createMsg();
        } else {
            streamId = this._enumDictionaryRequest.streamId() == 0 ? 4 : this._enumDictionaryRequest.streamId();
            this._enumDictionaryRequest.clear();
        }
        while (streamId == this._loginRequest.streamId() || streamId == this._directoryRequest.streamId() || streamId == this._fieldDictionaryRequest.streamId()) {
            ++streamId;
        }
        this._enumDictionaryRequest.rdmMsgType(DictionaryMsgType.REQUEST);
        this._enumDictionaryRequest.streamId(streamId);
        this._enumDictionaryRequest.applyStreaming();
        this._enumDictionaryRequest.verbosity(7);
        this._enumDictionaryRequest.dictionaryName(this._enumTypeDictionaryName);
    }

    DictionaryClose rdmEnumDictionaryClose() {
        if (this._enumDictionaryRequest == null) {
            return null;
        }
        if (this._enumDictionaryClose == null) {
            this._enumDictionaryClose = (DictionaryClose)DictionaryMsgFactory.createMsg();
            this._enumDictionaryClose.rdmMsgType(DictionaryMsgType.CLOSE);
        }
        this._enumDictionaryClose.streamId(this._enumDictionaryRequest.streamId());
        return this._enumDictionaryClose;
    }

    @Deprecated
    public int clientId(Buffer clientId) {
        return this._clientId.data(clientId.data(), clientId.position(), clientId.length());
    }

    @Deprecated
    public Buffer clientId() {
        return this._clientId;
    }

    public void dictionaryDownloadMode(int mode) {
        assert (mode == 0 || mode == 1);
        this._dictionaryDownloadMode = mode;
    }

    public int dictionaryDownloadMode() {
        return this._dictionaryDownloadMode;
    }

    void receivedFieldDictionaryResp(boolean dictionaryReceived) {
        this._receivedFieldDictionaryResp = dictionaryReceived;
    }

    boolean receivedFieldDictionaryResp() {
        return this._receivedFieldDictionaryResp;
    }

    void receivedEnumDictionaryResp(boolean dictionaryReceived) {
        this._receivedEnumDictionaryResp = dictionaryReceived;
    }

    boolean receivedEnumDictionaryResp() {
        return this._receivedEnumDictionaryResp;
    }

    void rttEnabled(boolean rttEnabled) {
        this.rttEnabled = rttEnabled;
    }

    boolean rttEnabled() {
        return this.rttEnabled;
    }

    public void loginMsgCallback(RDMLoginMsgCallback callback) {
        this._loginMsgCallback = callback;
    }

    public RDMLoginMsgCallback loginMsgCallback() {
        return this._loginMsgCallback;
    }

    public void directoryMsgCallback(RDMDirectoryMsgCallback callback) {
        this._directoryMsgCallback = callback;
    }

    public RDMDirectoryMsgCallback directoryMsgCallback() {
        return this._directoryMsgCallback;
    }

    public void dictionaryMsgCallback(RDMDictionaryMsgCallback callback) {
        this._dictionaryMsgCallback = callback;
    }

    public RDMDictionaryMsgCallback dictionaryMsgCallback() {
        return this._dictionaryMsgCallback;
    }

    public ConsumerWatchlistOptions watchlistOptions() {
        return this._consumerWatchlistOptions;
    }

    void copy(ConsumerRole role) {
        super.copy(role);
        this._loginMsgCallback = role.loginMsgCallback();
        this._directoryMsgCallback = role.directoryMsgCallback();
        this._dictionaryMsgCallback = role.dictionaryMsgCallback();
        this._dictionaryDownloadMode = role.dictionaryDownloadMode();
        this._consumerWatchlistOptions.copy(role.watchlistOptions());
        if (role.clientId() != null) {
            this._clientId.data(role.clientId().toString());
        }
        this.copyLoginRequest(role.rdmLoginRequest());
        this.copyDirectoryRequest(role.rdmDirectoryRequest());
        this.copyReactorOAuthCredential(role.reactorOAuthCredential());
    }

    void copyLoginRequest(LoginRequest loginRequest) {
        if (loginRequest != null) {
            if (this._loginRequest == null) {
                this._loginRequest = (LoginRequest)LoginMsgFactory.createMsg();
                this._loginRequest.rdmMsgType(LoginMsgType.REQUEST);
            }
            loginRequest.copy(this._loginRequest);
            this.rttEnabled(loginRequest.checkHasAttrib() && loginRequest.attrib().checkHasSupportRoundTripLatencyMonitoring());
        }
    }

    void copyDirectoryRequest(DirectoryRequest directoryRequest) {
        if (directoryRequest != null) {
            if (this._directoryRequest == null) {
                this._directoryRequest = (DirectoryRequest)DirectoryMsgFactory.createMsg();
                this._directoryRequest.rdmMsgType(DirectoryMsgType.REQUEST);
            }
            directoryRequest.copy(this._directoryRequest);
        }
    }

    void copyReactorOAuthCredential(ReactorOAuthCredential reactorOAuthCredential) {
        if (reactorOAuthCredential != null) {
            if (this._reactorOAuthCredential == null) {
                this._reactorOAuthCredential = ReactorFactory.createReactorOAuthCredential();
            }
            reactorOAuthCredential.copy(this._reactorOAuthCredential);
        }
    }
}

