/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.login;

import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginSupportFeatures;

class LoginSupportFeaturesImpl
implements LoginSupportFeatures {
    private int flags;
    private long supportBatchRequests;
    private long supportBatchReissues;
    private long supportBatchCloses;
    private long supportOMMPost;
    private long supportOptimizedPauseResume;
    private long supportStandby;
    private long supportViewRequests;
    private long supportProviderDictionaryDownload;
    private long supportEnhancedSymbolList;
    private long supportStandbyMode;
    private StringBuilder stringBuf = new StringBuilder();
    private static final String eol = System.getProperty("line.separator");
    private static final String tab = "\t";

    LoginSupportFeaturesImpl() {
    }

    @Override
    public void clear() {
        this.flags = 0;
        this.supportBatchRequests = 0L;
        this.supportBatchReissues = 0L;
        this.supportBatchCloses = 0L;
        this.supportOMMPost = 0L;
        this.supportStandby = 0L;
        this.supportViewRequests = 0L;
        this.supportOptimizedPauseResume = 0L;
        this.supportProviderDictionaryDownload = 0L;
        this.supportEnhancedSymbolList = 0L;
        this.supportStandbyMode = 0L;
    }

    @Override
    public int copy(LoginSupportFeatures destLoginSupportFeatures) {
        assert (destLoginSupportFeatures != null) : "destLoginSupportFeatures must be non-null";
        if (this.checkHasSupportBatchRequests()) {
            destLoginSupportFeatures.applyHasSupportBatchRequests();
            destLoginSupportFeatures.supportBatchRequests(this.supportBatchRequests());
        }
        if (this.checkHasSupportBatchReissues()) {
            destLoginSupportFeatures.applyHasSupportBatchReissues();
            destLoginSupportFeatures.supportBatchReissues(this.supportBatchReissues());
        }
        if (this.checkHasSupportBatchCloses()) {
            destLoginSupportFeatures.applyHasSupportBatchCloses();
            destLoginSupportFeatures.supportBatchCloses(this.supportBatchCloses());
        }
        if (this.checkHasSupportViewRequests()) {
            destLoginSupportFeatures.applyHasSupportViewRequests();
            destLoginSupportFeatures.supportViewRequests(this.supportViewRequests());
        }
        if (this.checkHasSupportOptimizedPauseResume()) {
            destLoginSupportFeatures.applyHasSupportOptimizedPauseResume();
            destLoginSupportFeatures.supportOptimizedPauseResume(this.supportOptimizedPauseResume());
        }
        if (this.checkHasSupportPost()) {
            destLoginSupportFeatures.applyHasSupportPost();
            destLoginSupportFeatures.supportOMMPost(this.supportOMMPost());
        }
        if (this.checkHasSupportStandby()) {
            destLoginSupportFeatures.applyHasSupportStandby();
            destLoginSupportFeatures.supportStandby(this.supportStandby());
        }
        if (this.checkHasSupportProviderDictionaryDownload()) {
            destLoginSupportFeatures.applyHasSupportProviderDictionaryDownload();
            destLoginSupportFeatures.supportProviderDictionaryDownload(this.supportProviderDictionaryDownload());
        }
        if (this.checkHasSupportStandbyMode()) {
            destLoginSupportFeatures.applyHasSupportStandbyMode();
            destLoginSupportFeatures.supportStandbyMode(this.supportStandbyMode());
        }
        return 0;
    }

    @Override
    public void flags(int flags) {
        this.flags = flags;
    }

    @Override
    public int flags() {
        return this.flags;
    }

    @Override
    public void supportOptimizedPauseResume(long supportOptimizedPauseResume) {
        assert (this.checkHasSupportOptimizedPauseResume());
        this.supportOptimizedPauseResume = supportOptimizedPauseResume;
    }

    @Override
    public long supportOptimizedPauseResume() {
        return this.supportOptimizedPauseResume;
    }

    @Override
    public boolean checkHasSupportOptimizedPauseResume() {
        return (this.flags() & 4) != 0;
    }

    @Override
    public void applyHasSupportOptimizedPauseResume() {
        this.flags |= 4;
    }

    @Override
    public long supportOMMPost() {
        return this.supportOMMPost;
    }

    @Override
    public void supportOMMPost(long supportOMMPost) {
        assert (this.checkHasSupportPost());
        this.supportOMMPost = supportOMMPost;
    }

    @Override
    public boolean checkHasSupportPost() {
        return (this.flags() & 2) != 0;
    }

    @Override
    public void applyHasSupportPost() {
        this.flags |= 2;
    }

    @Override
    public long supportViewRequests() {
        return this.supportViewRequests;
    }

    @Override
    public void supportViewRequests(long supportViewRequests) {
        assert (this.checkHasSupportViewRequests());
        this.supportViewRequests = supportViewRequests;
    }

    @Override
    public boolean checkHasSupportViewRequests() {
        return (this.flags() & 0x10) != 0;
    }

    @Override
    public void applyHasSupportViewRequests() {
        this.flags |= 0x10;
    }

    @Override
    public long supportBatchRequests() {
        return this.supportBatchRequests;
    }

    @Override
    public void supportBatchRequests(long supportBatchRequests) {
        assert (this.checkHasSupportBatchRequests());
        this.supportBatchRequests = supportBatchRequests;
    }

    @Override
    public boolean checkHasSupportBatchRequests() {
        return (this.flags() & 1) != 0;
    }

    @Override
    public void applyHasSupportBatchRequests() {
        this.flags |= 1;
    }

    @Override
    public long supportBatchReissues() {
        return this.supportBatchReissues;
    }

    @Override
    public void supportBatchReissues(long supportBatchReissues) {
        assert (this.checkHasSupportBatchReissues());
        this.supportBatchReissues = supportBatchReissues;
    }

    @Override
    public boolean checkHasSupportBatchReissues() {
        return (this.flags() & 0x20) != 0;
    }

    @Override
    public void applyHasSupportBatchReissues() {
        this.flags |= 0x20;
    }

    @Override
    public long supportBatchCloses() {
        return this.supportBatchCloses;
    }

    @Override
    public void supportBatchCloses(long supportBatchCloses) {
        assert (this.checkHasSupportBatchCloses());
        this.supportBatchCloses = supportBatchCloses;
    }

    @Override
    public boolean checkHasSupportBatchCloses() {
        return (this.flags() & 0x40) != 0;
    }

    @Override
    public void applyHasSupportBatchCloses() {
        this.flags |= 0x40;
    }

    @Override
    public long supportStandby() {
        return this.supportStandby;
    }

    @Override
    public void supportStandby(long supportStandby) {
        assert (this.checkHasSupportStandby());
        this.supportStandby = supportStandby;
    }

    @Override
    public boolean checkHasSupportStandby() {
        return (this.flags() & 8) != 0;
    }

    @Override
    public void applyHasSupportStandby() {
        this.flags |= 8;
    }

    @Override
    public boolean checkHasSupportStandbyMode() {
        return (this.flags() & 0x200) != 0;
    }

    @Override
    public void supportStandbyMode(long supportStandbyMode) {
        assert (this.checkHasSupportStandbyMode());
        this.supportStandbyMode = supportStandbyMode;
    }

    @Override
    public void applyHasSupportStandbyMode() {
        this.flags |= 0x200;
    }

    @Override
    public long supportStandbyMode() {
        return this.supportStandbyMode;
    }

    @Override
    public long supportProviderDictionaryDownload() {
        return this.supportProviderDictionaryDownload;
    }

    @Override
    public void supportProviderDictionaryDownload(long supportProviderDictionaryDownload) {
        assert (this.checkHasSupportProviderDictionaryDownload());
        this.supportProviderDictionaryDownload = supportProviderDictionaryDownload;
    }

    @Override
    public boolean checkHasSupportProviderDictionaryDownload() {
        return (this.flags() & 0x80) != 0;
    }

    @Override
    public void applyHasSupportProviderDictionaryDownload() {
        this.flags |= 0x80;
    }

    @Override
    public long supportEnhancedSymbolList() {
        return this.supportEnhancedSymbolList;
    }

    @Override
    public void supportEnhancedSymbolList(long supportEnhancedSymbolList) {
        assert (this.checkHasSupportEnhancedSymbolList());
        this.supportEnhancedSymbolList = supportEnhancedSymbolList;
    }

    @Override
    public boolean checkHasSupportEnhancedSymbolList() {
        return (this.flags() & 0x100) != 0;
    }

    @Override
    public void applyHasSupportEnhancedSymbolList() {
        this.flags |= 0x100;
    }

    public String toString() {
        this.stringBuf.setLength(0);
        if (this.checkHasSupportBatchRequests()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("supportBatchRequests: ");
            this.stringBuf.append(this.supportBatchRequests());
            this.stringBuf.append(eol);
        }
        if (this.checkHasSupportBatchReissues()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("supportBatchReissues: ");
            this.stringBuf.append(this.supportBatchReissues());
            this.stringBuf.append(eol);
        }
        if (this.checkHasSupportBatchCloses()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("supportBatchCloses: ");
            this.stringBuf.append(this.supportBatchCloses());
            this.stringBuf.append(eol);
        }
        if (this.checkHasSupportPost()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("supportOMMPost: ");
            this.stringBuf.append(this.supportOMMPost());
            this.stringBuf.append(eol);
        }
        if (this.checkHasSupportOptimizedPauseResume()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("supportOptimizedPauseResume: ");
            this.stringBuf.append(this.supportOptimizedPauseResume());
            this.stringBuf.append(eol);
        }
        if (this.checkHasSupportStandby()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("supportStandby: ");
            this.stringBuf.append(this.supportStandby());
            this.stringBuf.append(eol);
        }
        if (this.checkHasSupportViewRequests()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("supportViewRequests: ");
            this.stringBuf.append(this.supportViewRequests());
            this.stringBuf.append(eol);
        }
        if (this.checkHasSupportProviderDictionaryDownload()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("supportProviderDictionaryDownload: ");
            this.stringBuf.append(this.supportProviderDictionaryDownload());
            this.stringBuf.append(eol);
        }
        if (this.checkHasSupportEnhancedSymbolList()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("supportEnhancedSymbolList: ");
            this.stringBuf.append(this.supportEnhancedSymbolList());
            this.stringBuf.append(eol);
        }
        if (this.checkHasSupportStandbyMode()) {
            this.stringBuf.append(tab);
            this.stringBuf.append("supportStandbyMode: ");
            this.stringBuf.append(this.supportStandbyMode());
            this.stringBuf.append(eol);
        }
        return this.stringBuf.toString();
    }
}

