/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.login;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.codec.StatusMsg;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.rdm.ElementNames;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBaseImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginStatus;
import java.nio.ByteBuffer;

class LoginStatusImpl
extends MsgBaseImpl {
    private State state;
    private Buffer userName;
    private int userNameType;
    private long authenticationErrorCode;
    private Buffer authenticationErrorText;
    private static final String blankStringConst = new String(new byte[]{0});
    private int flags;
    private ElementList elementList = CodecFactory.createElementList();
    private ElementEntry element = CodecFactory.createElementEntry();
    private UInt tmpUInt = CodecFactory.createUInt();
    private static final String eol = System.getProperty("line.separator");
    private static final String tab = "\t";
    private StatusMsg statusMsg = (StatusMsg)CodecFactory.createMsg();

    public int copy(LoginStatus destStatusMsg) {
        ByteBuffer byteBuffer;
        assert (destStatusMsg != null) : "destStatusMsg must be non-null";
        destStatusMsg.streamId(this.streamId());
        if (this.checkHasUserName()) {
            destStatusMsg.applyHasUserName();
            byteBuffer = ByteBuffer.allocate(this.userName.length());
            this.userName.copy(byteBuffer);
            destStatusMsg.userName().data(byteBuffer);
        }
        if (this.checkHasUserNameType()) {
            destStatusMsg.applyHasUserNameType();
            destStatusMsg.userNameType(this.userNameType);
        }
        if (this.checkHasState()) {
            destStatusMsg.state().streamState(this.state.streamState());
            destStatusMsg.state().dataState(this.state.dataState());
            destStatusMsg.state().code(this.state.code());
            if (this.state.text().length() > 0) {
                byteBuffer = ByteBuffer.allocate(this.state.text().length());
                this.state.text().copy(byteBuffer);
                destStatusMsg.state().text().data(byteBuffer);
            }
            destStatusMsg.applyHasState();
        }
        if (this.checkClearCache()) {
            destStatusMsg.applyClearCache();
        }
        if (this.checkHasAuthenticationErrorCode()) {
            destStatusMsg.applyHasAuthenticationErrorCode();
            destStatusMsg.authenticationErrorCode(this.authenticationErrorCode);
        }
        if (this.checkHasAuthenticationErrorText()) {
            byteBuffer = ByteBuffer.allocate(this.authenticationErrorText.length());
            this.authenticationErrorText.copy(byteBuffer);
            destStatusMsg.applyHasAuthenticationErrorText();
            destStatusMsg.authenticationErrorText().data(byteBuffer);
        }
        return 0;
    }

    LoginStatusImpl() {
        this.state = CodecFactory.createState();
        this.userName = CodecFactory.createBuffer();
        this.authenticationErrorText = CodecFactory.createBuffer();
        this.streamId(1);
    }

    public void flags(int flags) {
        this.flags = flags;
    }

    public int flags() {
        return this.flags;
    }

    @Override
    public void clear() {
        super.clear();
        this.userName.clear();
        this.userNameType = 1;
        this.flags = 0;
        this.state.clear();
        this.state.streamState(1);
        this.state.dataState(1);
        this.state.code(0);
        this.streamId(1);
        this.authenticationErrorCode = 0L;
        this.authenticationErrorText.clear();
    }

    @Override
    public int encode(EncodeIterator encodeIter) {
        this.statusMsg.clear();
        this.statusMsg.streamId(this.streamId());
        this.statusMsg.containerType(128);
        this.statusMsg.msgClass(3);
        this.statusMsg.domainType(1);
        if (this.checkHasUserName()) {
            this.statusMsg.applyHasMsgKey();
            this.statusMsg.msgKey().applyHasName();
            this.statusMsg.msgKey().name(this.userName());
            if (this.checkHasUserNameType()) {
                this.statusMsg.msgKey().applyHasNameType();
                this.statusMsg.msgKey().nameType(this.userNameType());
                if (this.userNameType == 5) {
                    this.statusMsg.msgKey().applyHasName();
                    this.statusMsg.msgKey().name().data(blankStringConst);
                }
            }
        }
        if (this.checkClearCache()) {
            this.statusMsg.applyClearCache();
        }
        if (this.checkHasState()) {
            this.statusMsg.applyHasState();
            this.statusMsg.state().dataState(this.state().dataState());
            this.statusMsg.state().streamState(this.state().streamState());
            this.statusMsg.state().code(this.state().code());
            this.statusMsg.state().text(this.state().text());
        }
        if (this.checkHasAuthenticationErrorCode() || this.checkHasAuthenticationErrorText()) {
            this.statusMsg.applyHasMsgKey();
            this.statusMsg.msgKey().applyHasAttrib();
            this.statusMsg.msgKey().attribContainerType(133);
            int ret = this.statusMsg.encodeInit(encodeIter, 0);
            if (ret != 11) {
                return ret;
            }
            ret = this.encodeAttrib(encodeIter);
            if (ret != 0) {
                return ret;
            }
            ret = this.statusMsg.encodeKeyAttribComplete(encodeIter, true);
            if (ret < 0) {
                return ret;
            }
            ret = this.statusMsg.encodeComplete(encodeIter, true);
            if (ret < 0) {
                return ret;
            }
        } else {
            int ret = this.statusMsg.encode(encodeIter);
            if (ret < 0) {
                return ret;
            }
            return 0;
        }
        return 0;
    }

    private int encodeAttrib(EncodeIterator encodeIter) {
        this.element.clear();
        this.elementList.clear();
        this.elementList.applyHasStandardData();
        int ret = this.elementList.encodeInit(encodeIter, null, 0);
        if (ret != 0) {
            return ret;
        }
        if (this.checkHasAuthenticationErrorCode()) {
            this.element.dataType(4);
            this.element.name(ElementNames.AUTHN_ERROR_CODE);
            this.tmpUInt.value(this.authenticationErrorCode());
            ret = this.element.encode(encodeIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasAuthenticationErrorText() && this.authenticationErrorText().length() != 0) {
            this.element.dataType(17);
            this.element.name(ElementNames.AUTHN_ERROR_TEXT);
            ret = this.element.encode(encodeIter, this.authenticationErrorText());
            if (ret != 0) {
                return ret;
            }
        }
        return this.elementList.encodeComplete(encodeIter, true);
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        MsgKey msgKey;
        this.clear();
        if (msg.msgClass() != 3) {
            return -1;
        }
        StatusMsg statusMsg = (StatusMsg)msg;
        this.streamId(msg.streamId());
        if (statusMsg.checkHasState()) {
            this.state().streamState(statusMsg.state().streamState());
            this.state().dataState(statusMsg.state().dataState());
            this.state().code(statusMsg.state().code());
            if (statusMsg.state().text().length() > 0) {
                Buffer text = statusMsg.state().text();
                this.state.text().data(text.data(), text.position(), text.length());
            }
            this.applyHasState();
        }
        if (statusMsg.checkClearCache()) {
            this.applyClearCache();
        }
        if ((msgKey = msg.msgKey()) != null) {
            if (msgKey.checkHasName()) {
                this.applyHasUserName();
                Buffer name = msgKey.name();
                this.userName().data(name.data(), name.position(), name.length());
                if (msgKey.checkHasNameType()) {
                    this.applyHasUserNameType();
                    this.userNameType(msgKey.nameType());
                }
            }
            if (msgKey.checkHasAttrib()) {
                int ret = msg.decodeKeyAttrib(dIter, msgKey);
                if (ret != 0) {
                    return ret;
                }
                return this.decodeAttrib(dIter);
            }
        }
        return 0;
    }

    private int decodeAttrib(DecodeIterator dIter) {
        this.elementList.clear();
        int ret = this.elementList.decode(dIter, null);
        if (ret != 0) {
            return ret;
        }
        this.element.clear();
        while ((ret = this.element.decode(dIter)) != 14) {
            if (ret != 0) {
                return ret;
            }
            if (this.element.name().equals(ElementNames.AUTHN_ERROR_CODE)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasAuthenticationErrorCode();
                this.authenticationErrorCode(this.tmpUInt.toLong());
                continue;
            }
            if (!this.element.name().equals(ElementNames.AUTHN_ERROR_TEXT)) continue;
            if (this.element.dataType() != 17 && this.element.dataType() != 16) {
                return -1;
            }
            Buffer authenticationErrorText = this.element.encodedData();
            this.applyHasAuthenticationErrorText();
            this.authenticationErrorText().data(authenticationErrorText.data(), authenticationErrorText.position(), authenticationErrorText.length());
        }
        return 0;
    }

    public boolean checkHasUserName() {
        return (this.flags() & 2) != 0;
    }

    public void applyHasUserName() {
        this.flags |= 2;
    }

    public Buffer userName() {
        return this.userName;
    }

    public void userName(Buffer userName) {
        assert (userName != null) : "userName can not be null";
        this.userName().data(userName.data(), userName.position(), userName.length());
    }

    public int userNameType() {
        return this.userNameType;
    }

    public void userNameType(int nameType) {
        this.userNameType = nameType;
    }

    public boolean checkHasUserNameType() {
        return (this.flags() & 4) != 0;
    }

    public void applyHasUserNameType() {
        this.flags |= 4;
    }

    public State state() {
        return this.state;
    }

    public void state(State state) {
        this.state().streamState(state.streamState());
        this.state().dataState(state.dataState());
        this.state().code(state.code());
        this.state().text(state.text());
    }

    public boolean checkHasState() {
        return (this.flags() & 1) != 0;
    }

    public void applyHasState() {
        this.flags |= 1;
    }

    public void applyClearCache() {
        this.flags |= 8;
    }

    public boolean checkClearCache() {
        return (this.flags & 8) != 0;
    }

    public void authenticationErrorCode(long authenticationErrorCode) {
        assert (this.checkHasAuthenticationErrorCode());
        this.authenticationErrorCode = authenticationErrorCode;
    }

    public long authenticationErrorCode() {
        return this.authenticationErrorCode;
    }

    public boolean checkHasAuthenticationErrorCode() {
        return (this.flags() & 0x10) != 0;
    }

    public void applyHasAuthenticationErrorCode() {
        this.flags |= 0x10;
    }

    public void authenticationErrorText(Buffer authenticationErrorText) {
        assert (this.checkHasAuthenticationErrorText());
        authenticationErrorText.data(authenticationErrorText.data(), authenticationErrorText.position(), authenticationErrorText.length());
    }

    public Buffer authenticationErrorText() {
        return this.authenticationErrorText;
    }

    public boolean checkHasAuthenticationErrorText() {
        return (this.flags() & 0x20) != 0;
    }

    public void applyHasAuthenticationErrorText() {
        this.flags |= 0x20;
    }

    @Override
    public String toString() {
        StringBuilder stringBuf = super.buildStringBuffer();
        stringBuf.insert(0, "LoginStatus: \n");
        if (this.checkHasUserNameType()) {
            stringBuf.append(tab);
            stringBuf.append("nameType: ");
            stringBuf.append(this.userNameType());
            stringBuf.append(eol);
        }
        if (this.checkHasUserName()) {
            stringBuf.append(tab);
            stringBuf.append("name: ");
            stringBuf.append(this.userName());
            stringBuf.append(eol);
        }
        if (this.checkHasState()) {
            stringBuf.append(tab);
            stringBuf.append("state: ");
            stringBuf.append(this.state());
            stringBuf.append(eol);
        }
        if (this.checkHasAuthenticationErrorCode()) {
            stringBuf.append(tab);
            stringBuf.append("authenticationErrorCode: ");
            stringBuf.append(this.authenticationErrorCode());
            stringBuf.append(eol);
        }
        if (this.checkHasAuthenticationErrorText()) {
            stringBuf.append(tab);
            stringBuf.append("authenticationErrorText: ");
            stringBuf.append(this.authenticationErrorText());
            stringBuf.append(eol);
        }
        return stringBuf.toString();
    }

    @Override
    public int domainType() {
        return 1;
    }
}

