/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.login;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.rdm.ElementNames;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBaseImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginAttrib;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginAttribImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRequest;
import java.nio.ByteBuffer;

class LoginRequestImpl
extends MsgBaseImpl {
    private Buffer userName;
    private int userNameType;
    private int flags;
    private LoginAttrib attrib;
    private long downloadConnectionConfig;
    private Buffer instanceId;
    private Buffer password;
    private long role;
    private Buffer authenticationToken;
    private Buffer authenticationExtended;
    private static final String blankStringConst = new String(new byte[]{0});
    private static String defaultUsername;
    private ElementEntry elementEntry = CodecFactory.createElementEntry();
    private ElementList elementList = CodecFactory.createElementList();
    private UInt tmpUInt = CodecFactory.createUInt();
    private RequestMsg requestMsg = (RequestMsg)CodecFactory.createMsg();
    private static final String eol;
    private static final String tab = "\t";

    public void flags(int flags) {
        this.flags = flags;
    }

    public int flags() {
        return this.flags;
    }

    public int copy(LoginRequest destRequestMsg) {
        assert (destRequestMsg != null) : "destRequestMsg must be non-null";
        destRequestMsg.streamId(this.streamId());
        destRequestMsg.flags(this.flags());
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.userName.length());
        this.userName.copy(byteBuffer);
        destRequestMsg.userName().data(byteBuffer);
        if (this.checkHasUserNameType()) {
            destRequestMsg.applyHasUserNameType();
            destRequestMsg.userNameType(this.userNameType);
        }
        if (this.checkHasAttrib()) {
            destRequestMsg.applyHasAttrib();
            this.attrib().copy(destRequestMsg.attrib());
        }
        if (this.checkHasDownloadConnectionConfig()) {
            destRequestMsg.applyHasDownloadConnectionConfig();
            destRequestMsg.downloadConnectionConfig(this.downloadConnectionConfig);
        }
        if (this.checkHasInstanceId()) {
            byteBuffer = ByteBuffer.allocate(this.instanceId.length());
            this.instanceId.copy(byteBuffer);
            destRequestMsg.applyHasInstanceId();
            destRequestMsg.instanceId().data(byteBuffer);
        }
        if (this.checkHasPassword()) {
            byteBuffer = ByteBuffer.allocate(this.password.length());
            this.password.copy(byteBuffer);
            destRequestMsg.applyHasPassword();
            destRequestMsg.password().data(byteBuffer);
        }
        if (this.checkHasRole()) {
            destRequestMsg.applyHasRole();
            destRequestMsg.role(this.role);
        }
        if (this.checkHasAuthenticationExtended()) {
            byteBuffer = ByteBuffer.allocate(this.authenticationExtended.length());
            this.authenticationExtended.copy(byteBuffer);
            destRequestMsg.applyHasAuthenticationExtended();
            destRequestMsg.authenticationExtended().data(byteBuffer);
        }
        return 0;
    }

    LoginRequestImpl() {
        this.password = CodecFactory.createBuffer();
        this.instanceId = CodecFactory.createBuffer();
        this.authenticationToken = CodecFactory.createBuffer();
        this.authenticationExtended = CodecFactory.createBuffer();
        this.attrib = new LoginAttribImpl();
        try {
            defaultUsername = System.getProperty("user.name");
        }
        catch (Exception e) {
            defaultUsername = "eta";
        }
        this.userName = CodecFactory.createBuffer();
        this.initDefaultRequest(1);
    }

    public void initDefaultRequest(int streamId) {
        this.clear();
        this.streamId(streamId);
        this.userName().data(defaultUsername);
        this.applyHasUserNameType();
        this.userNameType(1);
        this.applyHasAttrib();
        ((LoginAttribImpl)this.attrib).initDefaultAttrib();
    }

    @Override
    public void clear() {
        super.clear();
        this.userName.clear();
        this.userNameType = 1;
        this.flags = 0;
        this.password.clear();
        this.instanceId.clear();
        this.role = 0L;
        this.downloadConnectionConfig = 0L;
        this.attrib.clear();
        this.authenticationToken.clear();
        this.authenticationExtended.clear();
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        this.clear();
        if (msg.msgClass() != 1) {
            return -1;
        }
        RequestMsg requestMsg = (RequestMsg)msg;
        if ((requestMsg.flags() & 4) == 0) {
            return -1;
        }
        if ((requestMsg.flags() & 0x20) != 0) {
            this.applyNoRefresh();
        }
        if ((requestMsg.flags() & 0x200) != 0) {
            this.applyPause();
        }
        this.streamId(msg.streamId());
        MsgKey msgKey = msg.msgKey();
        if (msgKey == null || !msgKey.checkHasName() || msgKey.checkHasAttrib() && msgKey.attribContainerType() != 133) {
            return -1;
        }
        Buffer userName = msgKey.name();
        this.userName().data(userName.data(), userName.position(), userName.length());
        if (msgKey.checkHasNameType()) {
            this.applyHasUserNameType();
            this.userNameType(msgKey.nameType());
        }
        if (msgKey.checkHasAttrib()) {
            int ret = msg.decodeKeyAttrib(dIter, msgKey);
            if (ret != 0) {
                return ret;
            }
            return this.decodeAttrib(dIter);
        }
        return 0;
    }

    private int decodeAttrib(DecodeIterator dIter) {
        this.elementList.clear();
        int ret = this.elementList.decode(dIter, null);
        if (ret != 0) {
            return ret;
        }
        this.elementEntry.clear();
        while ((ret = this.elementEntry.decode(dIter)) != 14) {
            if (ret != 0) {
                return ret;
            }
            if (this.elementEntry.name().equals(ElementNames.ALLOW_SUSPECT_DATA)) {
                if (this.elementEntry.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasAttrib();
                this.attrib.applyHasAllowSuspectData();
                this.attrib.allowSuspectData(this.tmpUInt.toLong());
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.APPID)) {
                if (this.elementEntry.dataType() != 17) {
                    return -1;
                }
                this.applyHasAttrib();
                Buffer applicationId = this.elementEntry.encodedData();
                this.attrib.applyHasApplicationId();
                this.attrib.applicationId().data(applicationId.data(), applicationId.position(), applicationId.length());
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.APPNAME)) {
                if (this.elementEntry.dataType() != 17) {
                    return -1;
                }
                this.applyHasAttrib();
                Buffer applicationName = this.elementEntry.encodedData();
                this.attrib.applyHasApplicationName();
                this.attrib.applicationName().data(applicationName.data(), applicationName.position(), applicationName.length());
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.POSITION)) {
                if (this.elementEntry.dataType() != 17) {
                    return -1;
                }
                this.applyHasAttrib();
                Buffer position = this.elementEntry.encodedData();
                this.attrib.applyHasPosition();
                this.attrib.position().data(position.data(), position.position(), position.length());
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.PASSWORD)) {
                if (this.elementEntry.dataType() != 17) {
                    return -1;
                }
                Buffer password = this.elementEntry.encodedData();
                this.applyHasAttrib();
                this.applyHasPassword();
                this.password().data(password.data(), password.position(), password.length());
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.AUTHN_TOKEN)) {
                if (this.elementEntry.dataType() != 17 && this.elementEntry.dataType() != 16) {
                    return -1;
                }
                Buffer authenticationToken = this.elementEntry.encodedData();
                this.userName().data(authenticationToken.data(), authenticationToken.position(), authenticationToken.length());
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.AUTHN_EXTENDED)) {
                if (this.elementEntry.dataType() != 17 && this.elementEntry.dataType() != 16) {
                    return -1;
                }
                Buffer authenticationExtended = this.elementEntry.encodedData();
                this.applyHasAuthenticationExtended();
                this.authenticationExtended().data(authenticationExtended.data(), authenticationExtended.position(), authenticationExtended.length());
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.INST_ID)) {
                if (this.elementEntry.dataType() != 17) {
                    return -1;
                }
                Buffer instanceId = this.elementEntry.encodedData();
                this.applyHasInstanceId();
                this.instanceId().data(instanceId.data(), instanceId.position(), instanceId.length());
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.DOWNLOAD_CON_CONFIG)) {
                if (this.elementEntry.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasDownloadConnectionConfig();
                this.downloadConnectionConfig(this.tmpUInt.toLong());
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.PROV_PERM_EXP)) {
                if (this.elementEntry.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasAttrib();
                this.attrib.applyHasProvidePermissionExpressions();
                this.attrib.providePermissionExpressions(this.tmpUInt.toLong());
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.PROV_PERM_PROF)) {
                if (this.elementEntry.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasAttrib();
                this.attrib.applyHasProvidePermissionProfile();
                this.attrib.providePermissionProfile(this.tmpUInt.toLong());
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.SINGLE_OPEN)) {
                if (this.elementEntry.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasAttrib();
                this.attrib.applyHasSingleOpen();
                this.attrib.singleOpen(this.tmpUInt.toLong());
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.ROLE)) {
                if (this.elementEntry.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasRole();
                this.role(this.tmpUInt.toLong());
                continue;
            }
            if (this.elementEntry.name().equals(ElementNames.SUPPORT_PROVIDER_DICTIONARY_DOWNLOAD)) {
                if (this.elementEntry.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasAttrib();
                this.attrib.applyHasProviderSupportDictionaryDownload();
                this.attrib.supportProviderDictionaryDownload(this.tmpUInt.toLong());
                continue;
            }
            if (!this.elementEntry.name().equals(ElementNames.ROUND_TRIP_LATENCY)) continue;
            if (this.elementEntry.dataType() != 4) {
                return -1;
            }
            ret = this.tmpUInt.decode(dIter);
            if (ret != 0) {
                return ret;
            }
            this.applyHasAttrib();
            this.attrib.applyHasSupportRoundTripLatencyMonitoring();
            this.attrib.supportRTTMonitoring(this.tmpUInt.toLong());
        }
        return 0;
    }

    @Override
    public int encode(EncodeIterator encodeIter) {
        this.requestMsg.clear();
        this.requestMsg.msgClass(1);
        this.requestMsg.streamId(this.streamId());
        this.requestMsg.domainType(1);
        this.requestMsg.containerType(128);
        this.requestMsg.applyStreaming();
        if (this.checkNoRefresh()) {
            this.requestMsg.applyNoRefresh();
        }
        if (this.checkPause()) {
            this.requestMsg.applyPause();
        }
        this.requestMsg.msgKey().applyHasName();
        this.requestMsg.msgKey().name(this.userName());
        if (this.checkHasUserNameType()) {
            this.requestMsg.msgKey().applyHasNameType();
            this.requestMsg.msgKey().nameType(this.userNameType());
            if (this.userNameType == 5) {
                this.requestMsg.msgKey().name().data(blankStringConst);
            }
        }
        this.requestMsg.msgKey().applyHasAttrib();
        this.requestMsg.msgKey().attribContainerType(133);
        int ret = this.requestMsg.encodeInit(encodeIter, 0);
        if (ret != 11) {
            return ret;
        }
        ret = this.encodeAttrib(encodeIter);
        if (ret != 0) {
            return ret;
        }
        ret = this.requestMsg.encodeKeyAttribComplete(encodeIter, true);
        if (ret < 0) {
            return ret;
        }
        ret = this.requestMsg.encodeComplete(encodeIter, true);
        if (ret < 0) {
            return ret;
        }
        return 0;
    }

    private int encodeAttrib(EncodeIterator encodeIter) {
        this.elementEntry.clear();
        this.elementList.clear();
        this.elementList.applyHasStandardData();
        int ret = this.elementList.encodeInit(encodeIter, null, 0);
        if (ret != 0) {
            return ret;
        }
        if (this.checkHasAttrib() && this.attrib.checkHasApplicationId() && this.attrib.applicationId().length() != 0) {
            this.elementEntry.dataType(17);
            this.elementEntry.name(ElementNames.APPID);
            ret = this.elementEntry.encode(encodeIter, this.attrib.applicationId());
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasAttrib() && this.attrib.checkHasApplicationName() && this.attrib.applicationName().length() != 0) {
            this.elementEntry.dataType(17);
            this.elementEntry.name(ElementNames.APPNAME);
            ret = this.elementEntry.encode(encodeIter, this.attrib.applicationName());
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasAttrib() && this.attrib.checkHasPosition() && this.attrib.position().length() != 0) {
            this.elementEntry.dataType(17);
            this.elementEntry.name(ElementNames.POSITION);
            ret = this.elementEntry.encode(encodeIter, this.attrib.position());
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasPassword() && this.password().length() != 0) {
            this.elementEntry.dataType(17);
            this.elementEntry.name(ElementNames.PASSWORD);
            ret = this.elementEntry.encode(encodeIter, this.password());
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasAttrib() && this.attrib.checkHasProvidePermissionProfile()) {
            this.elementEntry.dataType(4);
            this.elementEntry.name(ElementNames.PROV_PERM_PROF);
            this.tmpUInt.value(this.attrib.providePermissionProfile());
            ret = this.elementEntry.encode(encodeIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasAttrib() && this.attrib.checkHasProvidePermissionExpressions()) {
            this.elementEntry.dataType(4);
            this.elementEntry.name(ElementNames.PROV_PERM_EXP);
            this.tmpUInt.value(this.attrib.providePermissionExpressions());
            ret = this.elementEntry.encode(encodeIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasAttrib() && this.attrib.checkHasSingleOpen()) {
            this.elementEntry.dataType(4);
            this.elementEntry.name(ElementNames.SINGLE_OPEN);
            this.tmpUInt.value(this.attrib.singleOpen());
            ret = this.elementEntry.encode(encodeIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasAttrib() && this.attrib.checkHasAllowSuspectData()) {
            this.elementEntry.dataType(4);
            this.elementEntry.name(ElementNames.ALLOW_SUSPECT_DATA);
            this.tmpUInt.value(this.attrib.allowSuspectData());
            ret = this.elementEntry.encode(encodeIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasAttrib() && this.attrib.checkHasProviderSupportDictionaryDownload()) {
            this.elementEntry.dataType(4);
            this.elementEntry.name(ElementNames.SUPPORT_PROVIDER_DICTIONARY_DOWNLOAD);
            this.tmpUInt.value(this.attrib.supportProviderDictionaryDownload());
            ret = this.elementEntry.encode(encodeIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasUserNameType() && this.userNameType == 5 && this.userName().length() != 0) {
            this.elementEntry.dataType(17);
            this.elementEntry.name(ElementNames.AUTHN_TOKEN);
            ret = this.elementEntry.encode(encodeIter, this.userName());
            if (ret != 0) {
                return ret;
            }
            if (this.checkHasAuthenticationExtended() && this.authenticationExtended().length() != 0) {
                this.elementEntry.dataType(16);
                this.elementEntry.name(ElementNames.AUTHN_EXTENDED);
                ret = this.elementEntry.encode(encodeIter, this.authenticationExtended());
                if (ret != 0) {
                    return ret;
                }
            }
        }
        if (this.checkHasInstanceId() && this.instanceId().length() != 0) {
            this.elementEntry.dataType(17);
            this.elementEntry.name(ElementNames.INST_ID);
            ret = this.elementEntry.encode(encodeIter, this.instanceId());
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasRole()) {
            this.elementEntry.dataType(4);
            this.elementEntry.name(ElementNames.ROLE);
            this.tmpUInt.value(this.role());
            ret = this.elementEntry.encode(encodeIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasDownloadConnectionConfig()) {
            this.elementEntry.dataType(4);
            this.elementEntry.name(ElementNames.DOWNLOAD_CON_CONFIG);
            this.tmpUInt.value(this.downloadConnectionConfig());
            ret = this.elementEntry.encode(encodeIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasAttrib() && this.attrib.checkHasSupportRoundTripLatencyMonitoring()) {
            this.elementEntry.dataType(4);
            this.elementEntry.name(ElementNames.ROUND_TRIP_LATENCY);
            this.tmpUInt.value(this.attrib.supportRTTMonitoring());
            ret = this.elementEntry.encode(encodeIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
        }
        if ((ret = this.elementList.encodeComplete(encodeIter, true)) != 0) {
            return ret;
        }
        return 0;
    }

    public void applyPause() {
        this.flags |= 0x80;
    }

    public boolean checkPause() {
        return (this.flags & 0x80) != 0;
    }

    public void applyNoRefresh() {
        this.flags |= 0x40;
    }

    public boolean checkNoRefresh() {
        return (this.flags & 0x40) != 0;
    }

    public Buffer userName() {
        return this.userName;
    }

    public void userName(Buffer userName) {
        assert (userName != null) : "userName can not be null";
        this.userName().data(userName.data(), userName.position(), userName.length());
    }

    public int userNameType() {
        return this.userNameType;
    }

    public void userNameType(int userNameType) {
        this.userNameType = userNameType;
    }

    public boolean checkHasUserNameType() {
        return (this.flags & 0x20) != 0;
    }

    public void applyHasUserNameType() {
        this.flags |= 0x20;
    }

    @Override
    public String toString() {
        StringBuilder stringBuf = super.buildStringBuffer();
        stringBuf.insert(0, "LoginRequest: \n");
        stringBuf.append(tab);
        stringBuf.append("userName: ");
        stringBuf.append(this.userName().toString());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append("streaming: ");
        stringBuf.append("true");
        stringBuf.append(eol);
        if (this.checkHasUserNameType()) {
            stringBuf.append(tab);
            stringBuf.append("nameType: ");
            stringBuf.append(this.userNameType());
            stringBuf.append(eol);
        }
        if (this.checkPause()) {
            stringBuf.append(tab);
            stringBuf.append("pauseAll:");
            stringBuf.append("true");
            stringBuf.append(eol);
        }
        if (this.checkNoRefresh()) {
            stringBuf.append(tab);
            stringBuf.append("noRefresh:");
            stringBuf.append("true");
            stringBuf.append(eol);
        }
        if (this.checkHasAttrib()) {
            stringBuf.append(this.attrib().toString());
        }
        if (this.checkHasDownloadConnectionConfig()) {
            stringBuf.append(tab);
            stringBuf.append("downloadConnectionConfig: ");
            stringBuf.append(this.downloadConnectionConfig());
            stringBuf.append(eol);
        }
        if (this.checkHasInstanceId()) {
            stringBuf.append(tab);
            stringBuf.append("instanceId: ");
            stringBuf.append(this.instanceId());
            stringBuf.append(eol);
        }
        if (this.checkHasRole()) {
            stringBuf.append(tab);
            stringBuf.append("role: ");
            stringBuf.append(this.role());
            stringBuf.append(eol);
        }
        if (this.checkHasAuthenticationExtended()) {
            stringBuf.append(tab);
            stringBuf.append("authenticationExtended: ");
            stringBuf.append(this.authenticationExtended());
            stringBuf.append(eol);
        }
        return stringBuf.toString();
    }

    public long downloadConnectionConfig() {
        return this.downloadConnectionConfig;
    }

    public void downloadConnectionConfig(long downloadConnectionConfig) {
        assert (this.checkHasDownloadConnectionConfig());
        this.downloadConnectionConfig = downloadConnectionConfig;
    }

    public void applyHasDownloadConnectionConfig() {
        this.flags |= 2;
    }

    public boolean checkHasDownloadConnectionConfig() {
        return (this.flags & 2) != 0;
    }

    public Buffer instanceId() {
        return this.instanceId;
    }

    public void instanceId(Buffer instanceId) {
        assert (this.checkHasInstanceId()) : "instanceId flag should be set first";
        assert (instanceId != null) : "instanceId can not be null";
        this.instanceId().data(instanceId.data(), instanceId.position(), instanceId.length());
    }

    public void applyHasInstanceId() {
        this.flags |= 4;
    }

    public boolean checkHasInstanceId() {
        return (this.flags & 4) != 0;
    }

    public Buffer password() {
        return this.password;
    }

    public void applyHasPassword() {
        this.flags |= 8;
    }

    public boolean checkHasPassword() {
        return (this.flags & 8) != 0;
    }

    public long role() {
        return this.role;
    }

    public void role(long role) {
        assert (this.checkHasRole());
        this.role = role;
    }

    public void applyHasRole() {
        this.flags |= 0x10;
    }

    public boolean checkHasRole() {
        return (this.flags & 0x10) != 0;
    }

    public boolean checkHasAttrib() {
        return (this.flags & 1) != 0;
    }

    public void applyHasAttrib() {
        this.flags |= 1;
    }

    public LoginAttrib attrib() {
        return this.attrib;
    }

    public void attrib(LoginAttrib attrib) {
        assert (attrib != null) : "attrib can not be null";
        assert (this.checkHasAttrib());
        LoginAttribImpl loginAttribImpl = (LoginAttribImpl)attrib;
        loginAttribImpl.copyReferences(loginAttribImpl);
    }

    public Buffer authenticationExtended() {
        return this.authenticationExtended;
    }

    public void authenticationExtended(Buffer authenticationExtended) {
        assert (authenticationExtended != null) : "authenticationExtended can not be null";
        assert (this.checkHasAuthenticationExtended()) : "authenticationExtended flag should be set first";
        this.authenticationExtended().data(authenticationExtended.data(), authenticationExtended.position(), authenticationExtended.length());
    }

    public boolean checkHasAuthenticationExtended() {
        return (this.flags & 0x200) != 0;
    }

    public void applyHasAuthenticationExtended() {
        this.flags |= 0x200;
    }

    @Override
    public int domainType() {
        return 1;
    }

    static {
        eol = System.getProperty("line.separator");
    }
}

