/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.login;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.RefreshMsg;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.rdm.ElementNames;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBaseImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginAttrib;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginAttribImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginConnectionConfig;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginConnectionConfigImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRefresh;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginSupportFeatures;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginSupportFeaturesImpl;
import java.nio.ByteBuffer;

class LoginRefreshImpl
extends MsgBaseImpl {
    private int flags;
    private long sequenceNumber;
    private State state;
    private Buffer userName;
    private int userNameType;
    private LoginAttrib attrib;
    private LoginSupportFeatures features;
    private LoginConnectionConfig connectionConfig;
    private long authenticationTTReissue;
    private Buffer authenticationExtendedResp;
    private long authenticationErrorCode;
    private Buffer authenticationErrorText;
    private static final String blankStringConst = new String(new byte[]{0});
    private ElementList elementList = CodecFactory.createElementList();
    private ElementEntry element = CodecFactory.createElementEntry();
    private UInt tmpUInt = CodecFactory.createUInt();
    private static final String eol = System.getProperty("line.separator");
    private static final String tab = "\t";
    private RefreshMsg refreshMsg = (RefreshMsg)CodecFactory.createMsg();

    LoginRefreshImpl() {
        this.state = CodecFactory.createState();
        this.userName = CodecFactory.createBuffer();
        this.attrib = new LoginAttribImpl();
        this.features = new LoginSupportFeaturesImpl();
        this.connectionConfig = new LoginConnectionConfigImpl();
        this.authenticationExtendedResp = CodecFactory.createBuffer();
        this.authenticationErrorText = CodecFactory.createBuffer();
    }

    @Override
    public void clear() {
        super.clear();
        this.state.clear();
        this.state.streamState(1);
        this.state.dataState(1);
        this.state.code(0);
        this.flags = 0;
        this.userNameType = 1;
        this.userName.clear();
        this.sequenceNumber = 0L;
        this.authenticationTTReissue = 0L;
        this.authenticationErrorCode = 0L;
        this.authenticationExtendedResp.clear();
        this.authenticationErrorText.clear();
        this.clearAttrib();
        this.connectionConfig.clear();
    }

    private void clearAttrib() {
        this.attrib.clear();
        this.features.clear();
    }

    public int copy(LoginRefresh destRefreshMsg) {
        ByteBuffer byteBuffer;
        assert (destRefreshMsg != null) : "destRefreshMsg must be non-null";
        destRefreshMsg.streamId(this.streamId());
        if (this.checkHasUserName()) {
            destRefreshMsg.applyHasUserName();
            byteBuffer = ByteBuffer.allocate(this.userName.length());
            this.userName.copy(byteBuffer);
            destRefreshMsg.applyHasUserName();
            destRefreshMsg.userName().data(byteBuffer);
        }
        if (this.checkHasUserNameType()) {
            destRefreshMsg.applyHasUserNameType();
            destRefreshMsg.userNameType(this.userNameType);
        }
        if (this.checkHasSequenceNumber()) {
            destRefreshMsg.applyHasSequenceNumber();
            destRefreshMsg.sequenceNumber(this.sequenceNumber);
        }
        if (this.checkHasAuthenticationTTReissue()) {
            destRefreshMsg.applyHasAuthenticationTTReissue();
            destRefreshMsg.authenticationTTReissue(this.authenticationTTReissue);
        }
        if (this.checkHasAuthenticationExtendedResp()) {
            byteBuffer = ByteBuffer.allocate(this.authenticationExtendedResp.length());
            this.authenticationExtendedResp.copy(byteBuffer);
            destRefreshMsg.applyHasAuthenticationExtendedResp();
            destRefreshMsg.authenticationExtendedResp().data(byteBuffer);
        }
        if (this.checkHasAuthenticationErrorCode()) {
            destRefreshMsg.applyHasAuthenticationErrorCode();
            destRefreshMsg.authenticationErrorCode(this.authenticationErrorCode);
        }
        if (this.checkHasAuthenticationErrorText()) {
            byteBuffer = ByteBuffer.allocate(this.authenticationErrorText.length());
            this.authenticationErrorText.copy(byteBuffer);
            destRefreshMsg.applyHasAuthenticationErrorText();
            destRefreshMsg.authenticationErrorText().data(byteBuffer);
        }
        if (this.checkClearCache()) {
            destRefreshMsg.applyClearCache();
        }
        if (this.checkSolicited()) {
            destRefreshMsg.applySolicited();
        }
        destRefreshMsg.state().streamState(this.state.streamState());
        destRefreshMsg.state().dataState(this.state.dataState());
        destRefreshMsg.state().code(this.state.code());
        byteBuffer = ByteBuffer.allocate(this.state.text().length());
        this.state.text().copy(byteBuffer);
        destRefreshMsg.state().text().data(byteBuffer);
        if (this.checkHasConnectionConfig()) {
            destRefreshMsg.applyHasConnectionConfig();
            this.connectionConfig().copy(destRefreshMsg.connectionConfig());
        }
        if (this.checkHasAttrib()) {
            destRefreshMsg.applyHasAttrib();
            this.attrib().copy(destRefreshMsg.attrib());
        }
        if (this.checkHasFeatures()) {
            destRefreshMsg.applyHasFeatures();
            LoginSupportFeatures thisfeatures = this.features();
            LoginSupportFeatures destfeatures = destRefreshMsg.features();
            if (thisfeatures.checkHasSupportBatchRequests()) {
                destfeatures.applyHasSupportBatchRequests();
                destfeatures.supportBatchRequests(thisfeatures.supportBatchRequests());
            }
            if (thisfeatures.checkHasSupportBatchReissues()) {
                destfeatures.applyHasSupportBatchReissues();
                destfeatures.supportBatchReissues(thisfeatures.supportBatchReissues());
            }
            if (thisfeatures.checkHasSupportBatchCloses()) {
                destfeatures.applyHasSupportBatchCloses();
                destfeatures.supportBatchCloses(thisfeatures.supportBatchCloses());
            }
            if (thisfeatures.checkHasSupportViewRequests()) {
                destfeatures.applyHasSupportViewRequests();
                destfeatures.supportViewRequests(thisfeatures.supportViewRequests());
            }
            if (thisfeatures.checkHasSupportOptimizedPauseResume()) {
                destfeatures.applyHasSupportOptimizedPauseResume();
                destfeatures.supportOptimizedPauseResume(thisfeatures.supportOptimizedPauseResume());
            }
            if (thisfeatures.checkHasSupportPost()) {
                destfeatures.applyHasSupportPost();
                destfeatures.supportOMMPost(thisfeatures.supportOMMPost());
            }
            if (thisfeatures.checkHasSupportStandby()) {
                destfeatures.applyHasSupportStandby();
                destfeatures.supportStandby(thisfeatures.supportStandby());
            }
            if (thisfeatures.checkHasSupportStandbyMode()) {
                destfeatures.applyHasSupportStandbyMode();
                destfeatures.supportStandbyMode(thisfeatures.supportStandbyMode());
            }
            if (thisfeatures.checkHasSupportProviderDictionaryDownload()) {
                destfeatures.applyHasSupportProviderDictionaryDownload();
                destfeatures.supportProviderDictionaryDownload(thisfeatures.supportProviderDictionaryDownload());
            }
        }
        return 0;
    }

    public void flags(int flags) {
        this.flags = flags;
    }

    public int flags() {
        return this.flags;
    }

    @Override
    public int encode(EncodeIterator encodeIter) {
        int ret;
        this.refreshMsg.clear();
        this.refreshMsg.msgClass(2);
        this.refreshMsg.streamId(this.streamId());
        this.refreshMsg.domainType(1);
        this.refreshMsg.containerType(128);
        this.refreshMsg.applyHasMsgKey();
        this.refreshMsg.applyRefreshComplete();
        this.refreshMsg.state().dataState(this.state().dataState());
        this.refreshMsg.state().streamState(this.state().streamState());
        this.refreshMsg.state().code(this.state().code());
        this.refreshMsg.state().text(this.state().text());
        if (this.checkClearCache()) {
            this.refreshMsg.applyClearCache();
        }
        if (this.checkSolicited()) {
            this.refreshMsg.applySolicited();
        }
        if (this.checkHasSequenceNumber()) {
            this.refreshMsg.applyHasSeqNum();
            this.refreshMsg.seqNum(this.sequenceNumber());
        }
        if (this.checkHasUserName()) {
            this.refreshMsg.msgKey().applyHasName();
            this.refreshMsg.msgKey().name(this.userName());
            this.refreshMsg.msgKey().nameType(this.userNameType());
        }
        if (this.checkHasUserNameType()) {
            if (this.userNameType == 5) {
                this.refreshMsg.msgKey().applyHasName();
                this.refreshMsg.msgKey().name().data(blankStringConst);
            }
            this.refreshMsg.msgKey().applyHasNameType();
            this.refreshMsg.msgKey().nameType(this.userNameType());
        }
        this.refreshMsg.msgKey().applyHasAttrib();
        this.refreshMsg.msgKey().attribContainerType(133);
        if (this.checkHasConnectionConfig()) {
            this.refreshMsg.containerType(133);
        }
        if ((ret = this.refreshMsg.encodeInit(encodeIter, 0)) != 11) {
            return ret;
        }
        ret = this.encodeAttrib(encodeIter);
        if (ret != 0) {
            return ret;
        }
        ret = this.refreshMsg.encodeKeyAttribComplete(encodeIter, true);
        if (ret < 0) {
            return ret;
        }
        if (this.checkHasConnectionConfig() && (ret = ((LoginConnectionConfigImpl)this.connectionConfig).encode(encodeIter)) != 0) {
            return ret;
        }
        ret = this.refreshMsg.encodeComplete(encodeIter, true);
        if (ret < 0) {
            return ret;
        }
        return 0;
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        int ret;
        MsgKey msgKey;
        this.clear();
        if (msg.msgClass() != 2) {
            return -1;
        }
        this.streamId(msg.streamId());
        RefreshMsg refreshMsg = (RefreshMsg)msg;
        if (refreshMsg.checkSolicited()) {
            this.applySolicited();
        }
        if (refreshMsg.checkClearCache()) {
            this.applyClearCache();
        }
        this.state().streamState(refreshMsg.state().streamState());
        this.state().dataState(refreshMsg.state().dataState());
        this.state().code(refreshMsg.state().code());
        if (refreshMsg.state().text().length() > 0) {
            Buffer text = refreshMsg.state().text();
            this.state.text().data(text.data(), text.position(), text.length());
        }
        if (refreshMsg.checkHasSeqNum()) {
            this.applyHasSequenceNumber();
            this.sequenceNumber(refreshMsg.seqNum());
        }
        if ((msgKey = msg.msgKey()) == null || msgKey.checkHasAttrib() && msgKey.attribContainerType() != 133) {
            return -1;
        }
        if (msgKey.checkHasName() && msgKey.name() != null) {
            this.applyHasUserName();
            Buffer name = msgKey.name();
            this.userName().data(name.data(), name.position(), name.length());
        }
        if (msgKey.checkHasNameType()) {
            this.applyHasUserNameType();
            this.userNameType(msgKey.nameType());
        }
        if (msg.containerType() == 133 && (ret = this.decodePayload(dIter, (Msg)refreshMsg)) != 0) {
            return ret;
        }
        if (msgKey.checkHasAttrib()) {
            ret = msg.decodeKeyAttrib(dIter, msgKey);
            if (ret != 0) {
                return ret;
            }
            return this.decodeAttrib(dIter);
        }
        return 0;
    }

    private int decodePayload(DecodeIterator dIter, Msg msg) {
        assert (msg.containerType() == 133) : "element list expected in login refresh payload";
        int ret = this.elementList.decode(dIter, null);
        if (ret != 0) {
            return ret;
        }
        while ((ret = this.element.decode(dIter)) != 14) {
            if (ret != 0) {
                return ret;
            }
            if (!this.element.name().equals(ElementNames.CONNECTION_CONFIG)) continue;
            this.applyHasConnectionConfig();
            if (this.element.dataType() != 136) {
                return -1;
            }
            ret = ((LoginConnectionConfigImpl)this.connectionConfig).decode(dIter);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    private int decodeAttrib(DecodeIterator dIter) {
        this.elementList.clear();
        int ret = this.elementList.decode(dIter, null);
        if (ret != 0) {
            return ret;
        }
        this.element.clear();
        while ((ret = this.element.decode(dIter)) != 14) {
            if (ret != 0) {
                return ret;
            }
            if (this.element.name().equals(ElementNames.ALLOW_SUSPECT_DATA)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasAttrib();
                this.attrib.applyHasAllowSuspectData();
                this.attrib.allowSuspectData(this.tmpUInt.toLong());
                continue;
            }
            if (this.element.name().equals(ElementNames.APPID)) {
                if (this.element.dataType() != 17) {
                    return -1;
                }
                this.applyHasAttrib();
                Buffer applicationId = this.element.encodedData();
                this.attrib.applyHasApplicationId();
                this.attrib.applicationId().data(applicationId.data(), applicationId.position(), applicationId.length());
                continue;
            }
            if (this.element.name().equals(ElementNames.APPNAME)) {
                if (this.element.dataType() != 17) {
                    return -1;
                }
                this.applyHasAttrib();
                Buffer applicationName = this.element.encodedData();
                this.attrib.applyHasApplicationName();
                this.attrib.applicationName().data(applicationName.data(), applicationName.position(), applicationName.length());
                continue;
            }
            if (this.element.name().equals(ElementNames.POSITION)) {
                if (this.element.dataType() != 17) {
                    return -1;
                }
                this.applyHasAttrib();
                Buffer position = this.element.encodedData();
                this.attrib.applyHasPosition();
                this.attrib.position().data(position.data(), position.position(), position.length());
                continue;
            }
            if (this.element.name().equals(ElementNames.PROV_PERM_EXP)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasAttrib();
                this.attrib.applyHasProvidePermissionExpressions();
                this.attrib.providePermissionExpressions(this.tmpUInt.toLong());
                continue;
            }
            if (this.element.name().equals(ElementNames.PROV_PERM_PROF)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasAttrib();
                this.attrib.applyHasProvidePermissionProfile();
                this.attrib.providePermissionProfile(this.tmpUInt.toLong());
                continue;
            }
            if (this.element.name().equals(ElementNames.SINGLE_OPEN)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasAttrib();
                this.attrib.applyHasSingleOpen();
                this.attrib.singleOpen(this.tmpUInt.toLong());
                continue;
            }
            if (this.element.name().equals(ElementNames.SUPPORT_POST)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasFeatures();
                this.features.applyHasSupportPost();
                this.features.supportOMMPost(this.tmpUInt.toLong());
                continue;
            }
            if (this.element.name().equals(ElementNames.SUPPORT_STANDBY)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasFeatures();
                this.features.applyHasSupportStandby();
                this.features.supportStandby(this.tmpUInt.toLong());
                continue;
            }
            if (this.element.name().equals(ElementNames.SUPPORT_STANDBY_MODE)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasFeatures();
                this.features.applyHasSupportStandbyMode();
                this.features.supportStandbyMode(this.tmpUInt.toLong());
                continue;
            }
            if (this.element.name().equals(ElementNames.SUPPORT_BATCH)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasFeatures();
                if ((this.tmpUInt.toLong() & 1L) > 0L) {
                    this.features.applyHasSupportBatchRequests();
                    this.features.supportBatchRequests(1L);
                }
                if ((this.tmpUInt.toLong() & 2L) > 0L) {
                    this.features.applyHasSupportBatchReissues();
                    this.features.supportBatchReissues(1L);
                }
                if ((this.tmpUInt.toLong() & 4L) <= 0L) continue;
                this.features.applyHasSupportBatchCloses();
                this.features.supportBatchCloses(1L);
                continue;
            }
            if (this.element.name().equals(ElementNames.SUPPORT_VIEW)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasFeatures();
                this.features.applyHasSupportViewRequests();
                this.features.supportViewRequests(this.tmpUInt.toLong());
                continue;
            }
            if (this.element.name().equals(ElementNames.SUPPORT_OPR)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasFeatures();
                this.features.applyHasSupportOptimizedPauseResume();
                this.features.supportOptimizedPauseResume(this.tmpUInt.toLong());
                continue;
            }
            if (this.element.name().equals(ElementNames.SUPPORT_PROVIDER_DICTIONARY_DOWNLOAD)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasFeatures();
                this.features.applyHasSupportProviderDictionaryDownload();
                this.features.supportProviderDictionaryDownload(this.tmpUInt.toLong());
                continue;
            }
            if (this.element.name().equals(ElementNames.AUTHN_TT_REISSUE)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasAuthenticationTTReissue();
                this.authenticationTTReissue(this.tmpUInt.toLong());
                continue;
            }
            if (this.element.name().equals(ElementNames.AUTHN_EXTENDED_RESP)) {
                if (this.element.dataType() != 17 && this.element.dataType() != 16) {
                    return -1;
                }
                Buffer authenticationExtendedResp = this.element.encodedData();
                this.applyHasAuthenticationExtendedResp();
                this.authenticationExtendedResp().data(authenticationExtendedResp.data(), authenticationExtendedResp.position(), authenticationExtendedResp.length());
                continue;
            }
            if (this.element.name().equals(ElementNames.AUTHN_ERROR_CODE)) {
                if (this.element.dataType() != 4) {
                    return -1;
                }
                ret = this.tmpUInt.decode(dIter);
                if (ret != 0) {
                    return ret;
                }
                this.applyHasAuthenticationErrorCode();
                this.authenticationErrorCode(this.tmpUInt.toLong());
                continue;
            }
            if (this.element.name().equals(ElementNames.AUTHN_ERROR_TEXT)) {
                if (this.element.dataType() != 17 && this.element.dataType() != 16) {
                    return -1;
                }
                Buffer authenticationErrorText = this.element.encodedData();
                this.applyHasAuthenticationErrorText();
                this.authenticationErrorText().data(authenticationErrorText.data(), authenticationErrorText.position(), authenticationErrorText.length());
                continue;
            }
            if (!this.element.name().equals(ElementNames.ROUND_TRIP_LATENCY)) continue;
            if (this.element.dataType() != 4) {
                return -1;
            }
            ret = this.tmpUInt.decode(dIter);
            if (ret != 0) {
                return ret;
            }
            this.applyHasAttrib();
            this.attrib.applyHasSupportRoundTripLatencyMonitoring();
            this.attrib.supportRTTMonitoring(this.tmpUInt.toLong());
        }
        return 0;
    }

    public void applySolicited() {
        this.flags |= 0x80;
    }

    public boolean checkSolicited() {
        return (this.flags & 0x80) != 0;
    }

    public void applyClearCache() {
        this.flags |= 1;
    }

    public boolean checkClearCache() {
        return (this.flags & 1) != 0;
    }

    public Buffer userName() {
        return this.userName;
    }

    public void userName(Buffer userName) {
        assert (userName != null) : "userName can not be null";
        this.userName().data(userName.data(), userName.position(), userName.length());
    }

    public boolean checkHasUserName() {
        return (this.flags() & 0x20) != 0;
    }

    public void applyHasUserName() {
        this.flags |= 0x20;
    }

    public int userNameType() {
        return this.userNameType;
    }

    public void userNameType(int userNameType) {
        this.userNameType = userNameType;
    }

    public boolean checkHasUserNameType() {
        return (this.flags() & 0x40) != 0;
    }

    public void applyHasUserNameType() {
        this.flags |= 0x40;
    }

    public State state() {
        return this.state;
    }

    public void state(State state) {
        this.state().streamState(state.streamState());
        this.state().dataState(state.dataState());
        this.state().code(state.code());
        this.state().text(state.text());
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    public void sequenceNumber(long sequenceNumber) {
        assert (this.checkHasSequenceNumber());
        this.sequenceNumber = sequenceNumber;
    }

    public boolean checkHasSequenceNumber() {
        return (this.flags() & 8) != 0;
    }

    public void applyHasSequenceNumber() {
        this.flags |= 8;
    }

    public void authenticationTTReissue(long authenticationTTReissue) {
        assert (this.checkHasAuthenticationTTReissue());
        this.authenticationTTReissue = authenticationTTReissue;
    }

    public long authenticationTTReissue() {
        return this.authenticationTTReissue;
    }

    public boolean checkHasAuthenticationTTReissue() {
        return (this.flags() & 0x200) != 0;
    }

    public void applyHasAuthenticationTTReissue() {
        this.flags |= 0x200;
    }

    public void authenticationExtendedResp(Buffer authenticationExtendedResp) {
        assert (this.checkHasAuthenticationExtendedResp());
        authenticationExtendedResp.data(authenticationExtendedResp.data(), authenticationExtendedResp.position(), authenticationExtendedResp.length());
    }

    public Buffer authenticationExtendedResp() {
        return this.authenticationExtendedResp;
    }

    public boolean checkHasAuthenticationExtendedResp() {
        return (this.flags() & 0x400) != 0;
    }

    public void applyHasAuthenticationExtendedResp() {
        this.flags |= 0x400;
    }

    public void authenticationErrorCode(long authenticationErrorCode) {
        assert (this.checkHasAuthenticationErrorCode());
        this.authenticationErrorCode = authenticationErrorCode;
    }

    public long authenticationErrorCode() {
        return this.authenticationErrorCode;
    }

    public boolean checkHasAuthenticationErrorCode() {
        return (this.flags() & 0x800) != 0;
    }

    public void applyHasAuthenticationErrorCode() {
        this.flags |= 0x800;
    }

    public void authenticationErrorText(Buffer authenticationErrorText) {
        assert (this.checkHasAuthenticationErrorText());
        authenticationErrorText.data(authenticationErrorText.data(), authenticationErrorText.position(), authenticationErrorText.length());
    }

    public Buffer authenticationErrorText() {
        return this.authenticationErrorText;
    }

    public boolean checkHasAuthenticationErrorText() {
        return (this.flags() & 0x1000) != 0;
    }

    public void applyHasAuthenticationErrorText() {
        this.flags |= 0x1000;
    }

    public LoginAttrib attrib() {
        return this.attrib;
    }

    public void attrib(LoginAttrib attrib) {
        assert (attrib != null) : "attrib can not be null";
        assert (this.checkHasAttrib());
        LoginAttribImpl loginAttribImpl = (LoginAttribImpl)attrib;
        loginAttribImpl.copyReferences(loginAttribImpl);
    }

    public boolean checkHasAttrib() {
        return (this.flags() & 4) != 0;
    }

    public void applyHasAttrib() {
        this.flags |= 4;
    }

    public LoginSupportFeatures features() {
        return this.features;
    }

    public void features(LoginSupportFeatures features) {
        assert (this.checkHasFeatures());
        this.features = features;
    }

    public boolean checkHasFeatures() {
        return (this.flags() & 0x10) != 0;
    }

    public void applyHasFeatures() {
        this.flags |= 0x10;
    }

    private int encodeAttrib(EncodeIterator encodeIter) {
        this.element.clear();
        this.elementList.clear();
        this.elementList.applyHasStandardData();
        int ret = this.elementList.encodeInit(encodeIter, null, 0);
        if (ret != 0) {
            return ret;
        }
        if (this.checkHasAuthenticationTTReissue()) {
            this.element.dataType(4);
            this.element.name(ElementNames.AUTHN_TT_REISSUE);
            this.tmpUInt.value(this.authenticationTTReissue());
            ret = this.element.encode(encodeIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasAuthenticationExtendedResp() && this.authenticationExtendedResp().length() != 0) {
            this.element.dataType(17);
            this.element.name(ElementNames.AUTHN_EXTENDED_RESP);
            ret = this.element.encode(encodeIter, this.authenticationExtendedResp());
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasAuthenticationErrorCode()) {
            this.element.dataType(4);
            this.element.name(ElementNames.AUTHN_ERROR_CODE);
            this.tmpUInt.value(this.authenticationErrorCode());
            ret = this.element.encode(encodeIter, this.tmpUInt);
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasAuthenticationErrorText() && this.authenticationErrorText().length() != 0) {
            this.element.dataType(17);
            this.element.name(ElementNames.AUTHN_ERROR_TEXT);
            ret = this.element.encode(encodeIter, this.authenticationErrorText());
            if (ret != 0) {
                return ret;
            }
        }
        if (this.checkHasAttrib()) {
            if (this.attrib().checkHasApplicationId() && this.attrib().applicationId().length() != 0) {
                this.element.dataType(17);
                this.element.name(ElementNames.APPID);
                ret = this.element.encode(encodeIter, this.attrib.applicationId());
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.attrib().checkHasApplicationName() && this.attrib().applicationName().length() != 0) {
                this.element.dataType(17);
                this.element.name(ElementNames.APPNAME);
                ret = this.element.encode(encodeIter, this.attrib.applicationName());
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.attrib().checkHasPosition() && this.attrib().position().length() != 0) {
                this.element.dataType(17);
                this.element.name(ElementNames.POSITION);
                ret = this.element.encode(encodeIter, this.attrib.position());
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.attrib().checkHasProvidePermissionProfile()) {
                this.element.dataType(4);
                this.element.name(ElementNames.PROV_PERM_PROF);
                this.tmpUInt.value(this.attrib.providePermissionProfile());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.attrib().checkHasProvidePermissionExpressions()) {
                this.element.dataType(4);
                this.element.name(ElementNames.PROV_PERM_EXP);
                this.tmpUInt.value(this.attrib.providePermissionExpressions());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.attrib().checkHasSingleOpen()) {
                this.element.dataType(4);
                this.element.name(ElementNames.SINGLE_OPEN);
                this.tmpUInt.value(this.attrib.singleOpen());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.attrib().checkHasAllowSuspectData()) {
                this.element.dataType(4);
                this.element.name(ElementNames.ALLOW_SUSPECT_DATA);
                this.tmpUInt.value(this.attrib.allowSuspectData());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.attrib().checkHasSupportRoundTripLatencyMonitoring()) {
                this.element.dataType(4);
                this.element.name(ElementNames.ROUND_TRIP_LATENCY);
                this.tmpUInt.value(this.attrib.supportRTTMonitoring());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
        }
        if (this.checkHasFeatures()) {
            if (this.features().checkHasSupportPost()) {
                this.element.dataType(4);
                this.element.name(ElementNames.SUPPORT_POST);
                this.tmpUInt.value(this.features().supportOMMPost());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.features().checkHasSupportBatchRequests() || this.features().checkHasSupportBatchReissues() || this.features().checkHasSupportBatchCloses()) {
                this.element.dataType(4);
                this.element.name(ElementNames.SUPPORT_BATCH);
                int temp = 0;
                if (this.features().checkHasSupportBatchRequests()) {
                    temp |= 1;
                }
                if (this.features().checkHasSupportBatchReissues()) {
                    temp |= 2;
                }
                if (this.features().checkHasSupportBatchCloses()) {
                    temp |= 4;
                }
                this.tmpUInt.value(temp);
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.features().checkHasSupportViewRequests()) {
                this.element.dataType(4);
                this.element.name(ElementNames.SUPPORT_VIEW);
                this.tmpUInt.value(this.features().supportViewRequests());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.features().checkHasSupportStandby()) {
                this.element.dataType(4);
                this.element.name(ElementNames.SUPPORT_STANDBY);
                this.tmpUInt.value(this.features().supportStandby());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.features().checkHasSupportStandbyMode()) {
                this.element.dataType(4);
                this.element.name(ElementNames.SUPPORT_STANDBY_MODE);
                this.tmpUInt.value(this.features().supportStandbyMode());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.features().checkHasSupportOptimizedPauseResume()) {
                this.element.dataType(4);
                this.element.name(ElementNames.SUPPORT_OPR);
                this.tmpUInt.value(this.features().supportOptimizedPauseResume());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
            if (this.features().checkHasSupportProviderDictionaryDownload()) {
                this.element.dataType(4);
                this.element.name(ElementNames.SUPPORT_PROVIDER_DICTIONARY_DOWNLOAD);
                this.tmpUInt.value(this.features().supportProviderDictionaryDownload());
                ret = this.element.encode(encodeIter, this.tmpUInt);
                if (ret != 0) {
                    return ret;
                }
            }
        }
        return this.elementList.encodeComplete(encodeIter, true);
    }

    @Override
    public String toString() {
        StringBuilder stringBuf = super.buildStringBuffer();
        stringBuf.insert(0, "LoginRefresh: \n");
        stringBuf.append(tab);
        stringBuf.append("name: ");
        stringBuf.append(this.userName());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append("nameType: ");
        stringBuf.append(this.userNameType());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append(this.state());
        stringBuf.append(eol);
        if (this.checkSolicited()) {
            stringBuf.append(tab);
            stringBuf.append("isSolicited: ");
            stringBuf.append(true);
            stringBuf.append(eol);
        }
        if (this.checkHasAuthenticationTTReissue()) {
            stringBuf.append(tab);
            stringBuf.append("authenticationTTReissue: ");
            stringBuf.append(this.authenticationTTReissue());
            stringBuf.append(eol);
        }
        if (this.checkHasAuthenticationExtendedResp()) {
            stringBuf.append(tab);
            stringBuf.append("authenticationExtendedResp: ");
            stringBuf.append(this.authenticationExtendedResp());
            stringBuf.append(eol);
        }
        if (this.checkHasAuthenticationErrorCode()) {
            stringBuf.append(tab);
            stringBuf.append("authenticationErrorCode: ");
            stringBuf.append(this.authenticationErrorCode());
            stringBuf.append(eol);
        }
        if (this.checkHasAuthenticationErrorText()) {
            stringBuf.append(tab);
            stringBuf.append("authenticationErrorText: ");
            stringBuf.append(this.authenticationErrorText());
            stringBuf.append(eol);
        }
        if (this.checkHasAttrib()) {
            stringBuf.append(this.attrib.toString());
        }
        if (this.checkHasFeatures()) {
            stringBuf.append(this.features.toString());
        }
        if (this.checkHasConnectionConfig()) {
            stringBuf.append(this.connectionConfig.toString());
        }
        return stringBuf.toString();
    }

    public void connectionConfig(LoginConnectionConfig connectionConfig) {
        assert (connectionConfig != null) : "connectionConfig can not be null";
        assert (this.checkHasConnectionConfig());
        LoginConnectionConfigImpl connectionConfigImpl = (LoginConnectionConfigImpl)this.connectionConfig();
        connectionConfigImpl.copyReferences(connectionConfig);
    }

    public LoginConnectionConfig connectionConfig() {
        return this.connectionConfig;
    }

    public boolean checkHasConnectionConfig() {
        return (this.flags() & 2) != 0;
    }

    public void applyHasConnectionConfig() {
        this.flags |= 2;
    }

    @Override
    public int domainType() {
        return 1;
    }
}

