/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.common;

import com.refinitiv.eta.valueadd.common.VaNode;

public class VaQueue {
    VaNode _head = null;
    VaNode _tail = null;
    volatile int _size = 0;
    private static final boolean DEBUG = false;

    public void add(VaNode node) {
        if (node == null) {
            return;
        }
        if (this._tail == null) {
            assert (this._head == null) : "VaQueue.enqueue(): unexpectedly found _tail null but head was not null!";
            this._head = node;
        } else {
            this._tail.next(node);
        }
        this._tail = node;
        this._tail.next(null);
        ++this._size;
    }

    public VaNode poll() {
        if (this._head == null) {
            return null;
        }
        VaNode node = this._head;
        --this._size;
        if (this._head.next() == null) {
            this._head = null;
            this._tail = null;
            this._size = 0;
        } else {
            this._head = this._head.next();
        }
        return node;
    }

    public VaNode peek() {
        return this._head;
    }

    public boolean remove(VaNode node) {
        if (node == null || this._head == null) {
            return false;
        }
        if (this._head == node) {
            if (this._head.next() != null) {
                this._head = this._head.next();
            } else {
                this._head = null;
                this._tail = null;
            }
            --this._size;
            return true;
        }
        VaNode previousNode = this._head;
        for (VaNode currentNode = this._head.next(); currentNode != null; currentNode = currentNode.next()) {
            if (currentNode == node) {
                if (currentNode.next() != null) {
                    previousNode.next(currentNode.next());
                } else {
                    previousNode.next(null);
                    this._tail = previousNode;
                }
                --this._size;
                return true;
            }
            previousNode = currentNode;
        }
        return false;
    }

    public int size() {
        return this._size;
    }

    void verifyQueue() {
        int i = 0;
        assert (this._size >= 0);
        for (VaNode node = this._head; node != null; node = node.next()) {
            ++i;
            if (node.next() == null) assert (node == this._tail);
        }
        assert (i == this._size);
    }
}

