/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.dictionary;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.codec.StatusMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBaseImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryStatus;
import java.nio.ByteBuffer;

class DictionaryStatusImpl
extends MsgBaseImpl {
    private State state;
    private int flags;
    private static final String eol = System.getProperty("line.separator");
    private static final String tab = "\t";
    private StatusMsg statusMsg = (StatusMsg)CodecFactory.createMsg();

    public int copy(DictionaryStatus destStatusMsg) {
        assert (destStatusMsg != null) : "destStatusMsg must be non-null";
        destStatusMsg.streamId(this.streamId());
        if (this.checkClearCache()) {
            destStatusMsg.applyClearCache();
        }
        if (this.checkHasState()) {
            destStatusMsg.state().streamState(this.state.streamState());
            destStatusMsg.state().dataState(this.state.dataState());
            destStatusMsg.state().code(this.state.code());
            if (this.state.text().length() > 0) {
                Buffer stateText = CodecFactory.createBuffer();
                ByteBuffer byteBuffer = ByteBuffer.allocate(this.state.text().length());
                this.state.text().copy(byteBuffer);
                stateText.data(byteBuffer);
                destStatusMsg.state().text(stateText);
            }
            int flags = destStatusMsg.flags();
            destStatusMsg.flags(flags |= 1);
        }
        return 0;
    }

    DictionaryStatusImpl() {
        this.state = CodecFactory.createState();
        this.streamId(1);
    }

    public void flags(int flags) {
        this.flags = flags;
    }

    public int flags() {
        return this.flags;
    }

    public boolean checkHasState() {
        return (this.flags & 1) != 0;
    }

    public void applyHasState() {
        this.flags |= 1;
    }

    public void applyClearCache() {
        this.flags |= 2;
    }

    public boolean checkClearCache() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void clear() {
        super.clear();
        this.flags = 0;
        this.state.clear();
        this.state.streamState(1);
        this.state.dataState(1);
        this.state.code(0);
    }

    @Override
    public int encode(EncodeIterator encodeIter) {
        this.statusMsg.clear();
        this.statusMsg.streamId(this.streamId());
        this.statusMsg.containerType(128);
        this.statusMsg.msgClass(3);
        this.statusMsg.domainType(5);
        if (this.checkClearCache()) {
            this.statusMsg.applyClearCache();
        }
        if (this.checkHasState()) {
            this.statusMsg.applyHasState();
            this.statusMsg.state().dataState(this.state().dataState());
            this.statusMsg.state().streamState(this.state().streamState());
            this.statusMsg.state().code(this.state().code());
            this.statusMsg.state().text(this.state().text());
        }
        return this.statusMsg.encode(encodeIter);
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        this.clear();
        if (msg.msgClass() != 3) {
            return -1;
        }
        StatusMsg statusMsg = (StatusMsg)msg;
        this.streamId(msg.streamId());
        if (statusMsg.checkHasState()) {
            this.state.code(statusMsg.state().code());
            this.state.streamState(statusMsg.state().streamState());
            this.state.dataState(statusMsg.state().dataState());
            if (statusMsg.state().text().length() > 0) {
                Buffer buf = statusMsg.state().text();
                this.state.text().data(buf.data(), buf.position(), buf.length());
            }
            this.applyHasState();
        }
        if (statusMsg.checkClearCache()) {
            this.applyClearCache();
        }
        return 0;
    }

    public State state() {
        return this.state;
    }

    public void state(State state) {
        this.state().streamState(state.streamState());
        this.state().dataState(state.dataState());
        this.state().code(state.code());
        this.state().text(state.text());
    }

    @Override
    public String toString() {
        StringBuilder stringBuf = super.buildStringBuffer();
        stringBuf.insert(0, "DictionaryStatus: \n");
        if (this.checkHasState()) {
            stringBuf.append(tab);
            stringBuf.append("state: ");
            stringBuf.append(this.state());
            stringBuf.append(eol);
        }
        return stringBuf.toString();
    }

    @Override
    public int domainType() {
        return 5;
    }
}

