/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.GenericMsg;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.valueadd.reactor.AckRangeList;
import com.refinitiv.eta.valueadd.reactor.ClassOfService;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamMsg;
import java.nio.ByteBuffer;

class TunnelStreamMsgImpl
extends TunnelStreamMsg
implements TunnelStreamMsg.TunnelStreamRequest,
TunnelStreamMsg.TunnelStreamData,
TunnelStreamMsg.TunnelStreamAck {
    int _opCode;
    int _streamId;
    int _domainType;
    int _serviceId;
    String _name;
    ClassOfService _classOfService;
    int _seqNum;
    int _seqNum2;
    int _actionOpCode;
    Buffer _tmpBuffer;
    private int _recvWindow;
    static final boolean _traceXml = true;
    private Msg _encMsg = CodecFactory.createMsg();
    int _dataMsgFlag;
    long _totalMsgLength;
    long _fragmentNumber;
    int _messageId;
    int _containerType;
    int _streamVersion = 2;

    TunnelStreamMsgImpl() {
        this._tmpBuffer = CodecFactory.createBuffer();
    }

    @Override
    void opCode(int opCode) {
        this._opCode = opCode;
    }

    @Override
    int opCode() {
        return this._opCode;
    }

    @Override
    void streamId(int streamId) {
        this._streamId = streamId;
    }

    @Override
    int streamId() {
        return this._streamId;
    }

    @Override
    void domainType(int domainType) {
        this._domainType = domainType;
    }

    @Override
    int domainType() {
        return this._domainType;
    }

    @Override
    void serviceId(int serviceId) {
        this._serviceId = serviceId;
    }

    @Override
    int serviceId() {
        return this._serviceId;
    }

    @Override
    void name(String name) {
        this._name = name;
    }

    @Override
    String name() {
        return this._name;
    }

    @Override
    void classOfService(ClassOfService classOfService) {
        this._classOfService = classOfService;
    }

    @Override
    ClassOfService classOfService() {
        return this._classOfService;
    }

    private void clearBase() {
        this._streamId = 0;
        this._domainType = 0;
        this._serviceId = 0;
        this._name = null;
        this._classOfService = null;
    }

    @Override
    public void clearRequest() {
        this.clearBase();
        this._opCode = 4;
    }

    @Override
    public int requestBufferSize() {
        return this._name.length() + 256;
    }

    private void setupRequestMsgHeader(RequestMsg requestMsg) {
        requestMsg.clear();
        requestMsg.msgClass(1);
        requestMsg.streamId(this._streamId);
        requestMsg.domainType(this._domainType);
        requestMsg.containerType(135);
        requestMsg.applyPrivateStream();
        requestMsg.applyQualifiedStream();
        requestMsg.applyStreaming();
        requestMsg.msgKey().applyHasName();
        requestMsg.msgKey().name().data(this._name);
        requestMsg.msgKey().applyHasServiceId();
        requestMsg.msgKey().serviceId(this._serviceId);
        requestMsg.msgKey().applyHasFilter();
        requestMsg.msgKey().filter((long)this._classOfService.filterFlags());
    }

    @Override
    public int encodeRequest(EncodeIterator encIter, RequestMsg tmpRequestMsg) {
        int ret = 0;
        this.setupRequestMsgHeader(tmpRequestMsg);
        ret = tmpRequestMsg.encodeInit(encIter, 0);
        if (ret < 0) {
            return ret;
        }
        ret = this._classOfService.encode(encIter);
        if (ret < 0) {
            return ret;
        }
        ret = tmpRequestMsg.encodeComplete(encIter, true);
        if (ret < 0) {
            return ret;
        }
        return ret;
    }

    @Override
    public int encodeRequestAsMsg(EncodeIterator encIter, Buffer classOfServiceBuffer, RequestMsg requestMsg) {
        int ret = 0;
        this.setupRequestMsgHeader(requestMsg);
        encIter.clear();
        encIter.setBufferAndRWFVersion(classOfServiceBuffer, this._classOfService.common().protocolMajorVersion(), this._classOfService.common().protocolMinorVersion());
        ret = this._classOfService.encode(encIter);
        if (ret < 0) {
            return ret;
        }
        requestMsg.encodedDataBody(classOfServiceBuffer);
        return 0;
    }

    @Override
    public void clearData() {
        this.clearBase();
        this._opCode = 1;
        this._seqNum = 0;
        this._dataMsgFlag = 0;
        this._totalMsgLength = 0L;
        this._fragmentNumber = 0L;
        this._messageId = 0;
        this._containerType = 0;
    }

    @Override
    public void clearRetrans() {
        this.clearBase();
        this._opCode = 3;
        this._seqNum = 0;
    }

    @Override
    public int dataMsgBufferSize() {
        return 128;
    }

    @Override
    public int dataMsgFlag() {
        return this._dataMsgFlag;
    }

    @Override
    public void dataMsgFlag(int flag) {
        this._dataMsgFlag = flag;
    }

    @Override
    public long totalMsgLength() {
        return this._totalMsgLength;
    }

    @Override
    public void totalMsgLength(long totalMsgLength) {
        this._totalMsgLength = totalMsgLength;
    }

    @Override
    public long fragmentNumber() {
        return this._fragmentNumber;
    }

    @Override
    public void fragmentNumber(long fragmentNumber) {
        this._fragmentNumber = fragmentNumber;
    }

    @Override
    public int messageId() {
        return this._messageId;
    }

    @Override
    public void messageId(int messageId) {
        this._messageId = messageId;
    }

    @Override
    public int containerType() {
        return this._containerType;
    }

    @Override
    public void containerType(int containerType) {
        this._containerType = containerType;
    }

    @Override
    public int encodeDataInit(EncodeIterator encIter) {
        GenericMsg genericMsg = (GenericMsg)this._encMsg;
        genericMsg.clear();
        genericMsg.msgClass(7);
        genericMsg.streamId(this._streamId);
        genericMsg.domainType(this._domainType);
        genericMsg.containerType(141);
        genericMsg.applyHasExtendedHdr();
        genericMsg.applyMessageComplete();
        genericMsg.applyHasSeqNum();
        genericMsg.seqNum((long)this._seqNum);
        int ret = genericMsg.encodeInit(encIter, 0);
        if (ret != 12) {
            return ret;
        }
        ret = encIter.encodeNonRWFInit(this._tmpBuffer);
        if (ret != 0) {
            return ret;
        }
        int lengthRequired = 2 + ((this._dataMsgFlag & 1) > 0 ? 11 : 0);
        if (this._tmpBuffer.length() < lengthRequired) {
            return -21;
        }
        this._tmpBuffer.data().put((byte)this._opCode);
        if (this._classOfService != null && this._classOfService.common().streamVersion() >= 2 || this._classOfService == null && this._streamVersion >= 2) {
            this._tmpBuffer.data().put((byte)this._dataMsgFlag);
            if ((this._dataMsgFlag & 1) > 0) {
                this._tmpBuffer.data().putInt((int)this._totalMsgLength);
                this._tmpBuffer.data().putInt((int)this._fragmentNumber);
                this._tmpBuffer.data().putShort((short)this._messageId);
                this._tmpBuffer.data().put((byte)this._containerType);
            }
        }
        if ((ret = encIter.encodeNonRWFComplete(this._tmpBuffer, true)) != 0) {
            return ret;
        }
        ret = this._encMsg.encodeExtendedHeaderComplete(encIter, true);
        if (ret < 0) {
            return ret;
        }
        return 0;
    }

    @Override
    public int encodeDataComplete(EncodeIterator encIter) {
        return this._encMsg.encodeComplete(encIter, true);
    }

    int encodeDataInitOpaque(EncodeIterator encIter) {
        GenericMsg genericMsg = (GenericMsg)this._encMsg;
        genericMsg.clear();
        genericMsg.msgClass(7);
        genericMsg.streamId(this._streamId);
        genericMsg.domainType(this._domainType);
        genericMsg.containerType(130);
        genericMsg.applyHasExtendedHdr();
        genericMsg.applyMessageComplete();
        genericMsg.applyHasSeqNum();
        genericMsg.seqNum((long)this._seqNum);
        int ret = genericMsg.encodeInit(encIter, 0);
        if (ret != 12) {
            return ret;
        }
        ret = encIter.encodeNonRWFInit(this._tmpBuffer);
        if (ret != 0) {
            return ret;
        }
        int lengthRequired = 2 + ((this._dataMsgFlag & 1) > 0 ? 11 : 0);
        if (this._tmpBuffer.length() < lengthRequired) {
            return -21;
        }
        this._tmpBuffer.data().put((byte)this._opCode);
        if (this._classOfService != null && this._classOfService.common().streamVersion() >= 2 || this._classOfService == null && this._streamVersion >= 2) {
            this._tmpBuffer.data().put((byte)this._dataMsgFlag);
            if ((this._dataMsgFlag & 1) > 0) {
                this._tmpBuffer.data().putInt((int)this._totalMsgLength);
                this._tmpBuffer.data().putInt((int)this._fragmentNumber);
                this._tmpBuffer.data().putShort((short)this._messageId);
                this._tmpBuffer.data().put((byte)(this._containerType - 128));
            }
        }
        if ((ret = encIter.encodeNonRWFComplete(this._tmpBuffer, true)) != 0) {
            return ret;
        }
        ret = this._encMsg.encodeExtendedHeaderComplete(encIter, true);
        if (ret < 0) {
            return ret;
        }
        return 0;
    }

    @Override
    public void clearAck() {
        this.clearBase();
        this._opCode = 2;
        this._actionOpCode = 0;
        this._recvWindow = 0;
    }

    @Override
    public void seqNum(int seqNum) {
        this._seqNum = seqNum;
    }

    @Override
    public int seqNum() {
        return this._seqNum;
    }

    @Override
    public int recvWindow() {
        return this._recvWindow;
    }

    @Override
    public void recvWindow(int recvWindow) {
        this._recvWindow = recvWindow;
    }

    @Override
    public int ackBufferSize(AckRangeList nakRangeList) {
        return 128 + (nakRangeList != null ? nakRangeList.count() * 2 * 4 : 0);
    }

    @Override
    public int encodeAck(EncodeIterator encIter, AckRangeList ackRangeList, AckRangeList nakRangeList, int actionOpCode) {
        int i;
        GenericMsg genericMsg = (GenericMsg)this._encMsg;
        genericMsg.clear();
        genericMsg.msgClass(7);
        genericMsg.streamId(this._streamId);
        genericMsg.domainType(this._domainType);
        genericMsg.containerType(128);
        genericMsg.applyHasExtendedHdr();
        genericMsg.applyMessageComplete();
        int ret = genericMsg.encodeInit(encIter, 0);
        if (ret != 12) {
            return ret;
        }
        ret = encIter.encodeNonRWFInit(this._tmpBuffer);
        if (ret != 0) {
            return ret;
        }
        if (this._tmpBuffer.length() < 6 + (nakRangeList != null ? nakRangeList.count() * 2 * 4 : 0) + 1 + (ackRangeList != null ? ackRangeList.count() * 2 * 4 : 0) + 4) {
            return -21;
        }
        ByteBuffer byteBuffer = this._tmpBuffer.data();
        byteBuffer.put((byte)2);
        if (actionOpCode < 128) {
            byteBuffer.put((byte)actionOpCode);
        } else {
            short v1 = (short)(actionOpCode | 0x8000);
            byteBuffer.putShort(v1);
        }
        byteBuffer.putInt(this._seqNum);
        if (nakRangeList == null) {
            byteBuffer.put((byte)0);
        } else {
            int[] nakRanges = nakRangeList.rangeArray();
            byteBuffer.put((byte)nakRangeList.count());
            for (i = 0; i < nakRangeList.count() * 2; ++i) {
                byteBuffer.putInt(nakRanges[i]);
            }
        }
        if (ackRangeList == null) {
            byteBuffer.put((byte)0);
        } else {
            int[] ackRanges = ackRangeList.rangeArray();
            byteBuffer.put((byte)ackRangeList.count());
            for (i = 0; i < ackRangeList.count() * 2; ++i) {
                byteBuffer.putInt(ackRanges[i]);
            }
        }
        byteBuffer.putInt(this._recvWindow);
        ret = encIter.encodeNonRWFComplete(this._tmpBuffer, true);
        if (ret != 0) {
            return ret;
        }
        ret = this._encMsg.encodeExtendedHeaderComplete(encIter, true);
        if (ret < 0) {
            return ret;
        }
        ret = this._encMsg.encodeComplete(encIter, true);
        if (ret != 0) {
            return ret;
        }
        return 0;
    }

    @Override
    int decode(DecodeIterator decIter, GenericMsg genericMsg, AckRangeList ackRangeList, AckRangeList nakRangeList) {
        if (!genericMsg.checkHasExtendedHdr()) {
            return -26;
        }
        ByteBuffer byteBuffer = genericMsg.extendedHeader().data();
        int tmpPos = byteBuffer.position();
        int tmpLimit = byteBuffer.limit();
        byteBuffer.position(genericMsg.extendedHeader().position());
        byteBuffer.limit(byteBuffer.position() + genericMsg.extendedHeader().length());
        this._streamId = genericMsg.streamId();
        this._domainType = genericMsg.domainType();
        try {
            this._opCode = byteBuffer.get() & 0xFF;
            switch (this._opCode) {
                case 1: 
                case 3: {
                    if (this._classOfService != null && this._classOfService.common().streamVersion() >= 2 || this._classOfService == null && this._streamVersion >= 2) {
                        this._dataMsgFlag = byteBuffer.get();
                        if ((this._dataMsgFlag & 1) > 0) {
                            this._totalMsgLength = byteBuffer.getInt();
                            this._fragmentNumber = byteBuffer.getInt();
                            this._messageId = byteBuffer.getShort();
                            this._containerType = byteBuffer.get() + 128;
                        }
                    }
                    if (!genericMsg.checkHasSeqNum()) {
                        return -26;
                    }
                    this._seqNum = (int)genericMsg.seqNum();
                    break;
                }
                case 2: {
                    int i;
                    this._actionOpCode = this.readUShort15rb(byteBuffer);
                    this._seqNum = byteBuffer.getInt();
                    int count = byteBuffer.get() & 0xFF;
                    nakRangeList.count(count);
                    int[] ranges = nakRangeList.rangeArray();
                    count *= 2;
                    for (i = 0; i < count; ++i) {
                        ranges[i] = byteBuffer.getInt();
                    }
                    count = byteBuffer.get() & 0xFF;
                    ackRangeList.count(count);
                    ranges = ackRangeList.rangeArray();
                    count *= 2;
                    for (i = 0; i < count; ++i) {
                        ranges[i] = byteBuffer.getInt();
                    }
                    this._recvWindow = byteBuffer.getInt();
                    break;
                }
                default: {
                    return -26;
                }
            }
        }
        catch (Exception e) {
            return -26;
        }
        byteBuffer.limit(tmpLimit);
        byteBuffer.position(tmpPos);
        return 0;
    }

    @Override
    String xmlDumpBegin(AckRangeList ackRangeList, AckRangeList nakRangeList) {
        switch (this._opCode) {
            case 1: {
                return "<TunnelData streamId=\"" + this._streamId + "\" seqNum=\"" + this._seqNum + "\" >\n";
            }
            case 3: {
                return "<TunnelRetrans streamId=\"" + this._streamId + "\" seqNum=\"" + this._seqNum + "\" >\n";
            }
            case 2: {
                int i;
                int count;
                String str = "<TunnelAck streamId=\"" + this._streamId + "\" seqNum=\"" + this._seqNum + "\" recvWindow=\"" + this._recvWindow;
                if (ackRangeList != null && ackRangeList.count() > 0) {
                    count = ackRangeList.count() * 2;
                    str = str + "\" ackRanges=\"";
                    for (i = 0; i < count; i += 2) {
                        str = str + ackRangeList.rangeArray()[i] + "-" + ackRangeList.rangeArray()[i + 1];
                        if (i >= count - 2) continue;
                        str = str + ",";
                    }
                }
                if (nakRangeList != null && nakRangeList.count() > 0) {
                    count = nakRangeList.count() * 2;
                    str = str + "\" nakRanges=\"";
                    for (i = 0; i < count; i += 2) {
                        str = str + nakRangeList.rangeArray()[i] + "-" + nakRangeList.rangeArray()[i + 1];
                        if (i >= count - 2) continue;
                        str = str + ",";
                    }
                }
                str = str + "\" />\n";
                return str;
            }
        }
        return "<TunnelUnknown streamId=\"" + this._streamId + "\"opCode=\"" + this._opCode + "\" />\n";
    }

    @Override
    public int flag() {
        return this._actionOpCode;
    }

    @Override
    String xmlDumpEnd() {
        switch (this._opCode) {
            case 1: {
                return "</TunnelData>\n";
            }
            case 3: {
                return "</TunnelRetrans>\n";
            }
        }
        return "";
    }

    short readUShort15rb(ByteBuffer byteBuffer) throws Exception {
        int b = this.readUnsignedByte(byteBuffer);
        if ((b & 0x80) != 0) {
            return (short)(((b & 0x7F) << 8) + this.readUnsignedByte(byteBuffer));
        }
        return (short)b;
    }

    int readUnsignedByte(ByteBuffer byteBuffer) throws Exception {
        short val = byteBuffer.get();
        if (val < 0) {
            val = (short)(val & 0xFF);
        }
        return val;
    }
}

