/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.directory;

import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.FilterEntry;
import com.refinitiv.eta.codec.FilterList;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.Service;
import java.util.ArrayList;
import java.util.List;

class ServiceImpl
implements Service {
    private int serviceId;
    private Service.ServiceInfo info;
    private Service.ServiceState state;
    private List<Service.ServiceGroup> groupStateList;
    private Service.ServiceLoad load;
    private Service.ServiceData data;
    private Service.ServiceLinkInfo link;
    private Service.ServiceSeqMcastInfo seqMcast;
    private int flags;
    private int action = 2;
    private StringBuilder stringBuf = new StringBuilder();
    private static final String eol = "\n";
    private static final String tab = "\t";
    private FilterEntry filterEntry = CodecFactory.createFilterEntry();
    private FilterList filterList = CodecFactory.createFilterList();

    ServiceImpl() {
        this.info = new Service.ServiceInfo();
        this.state = new Service.ServiceState();
        this.groupStateList = new ArrayList<Service.ServiceGroup>();
        this.load = new Service.ServiceLoad();
        this.data = new Service.ServiceData();
        this.link = new Service.ServiceLinkInfo();
        this.seqMcast = new Service.ServiceSeqMcastInfo();
    }

    @Override
    public void clear() {
        this.flags = 0;
        this.action = 2;
        this.info.clear();
        this.state.clear();
        this.groupStateList.clear();
        this.load.clear();
        this.data.clear();
        this.link.clear();
        this.seqMcast.clear();
    }

    @Override
    public int action() {
        return this.action;
    }

    @Override
    public void action(int action) {
        this.action = action;
    }

    @Override
    public int flags() {
        return this.flags;
    }

    @Override
    public void flags(int flags) {
        this.flags = flags;
    }

    @Override
    public void applyHasInfo() {
        this.flags |= 1;
    }

    @Override
    public boolean checkHasInfo() {
        return (this.flags & 1) != 0;
    }

    @Override
    public void applyHasData() {
        this.flags |= 8;
    }

    @Override
    public boolean checkHasData() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void applyHasLoad() {
        this.flags |= 4;
    }

    @Override
    public boolean checkHasLoad() {
        return (this.flags & 4) != 0;
    }

    @Override
    public void applyHasLink() {
        this.flags |= 0x10;
    }

    @Override
    public boolean checkHasLink() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public void applyHasState() {
        this.flags |= 2;
    }

    @Override
    public boolean checkHasState() {
        return (this.flags & 2) != 0;
    }

    @Override
    public int encode(EncodeIterator encIter) {
        this.filterList.clear();
        this.filterList.flags(0);
        this.filterList.containerType(133);
        int ret = this.filterList.encodeInit(encIter);
        if (ret != 0) {
            return ret;
        }
        if (this.checkHasInfo() && (ret = this.serviceFilterEncode(encIter, 1)) != 0) {
            return ret;
        }
        if (this.checkHasData() && (ret = this.serviceFilterEncode(encIter, 5)) != 0) {
            return ret;
        }
        if (this.checkHasLink() && (ret = this.serviceFilterEncode(encIter, 6)) != 0) {
            return ret;
        }
        if (this.checkHasLoad() && (ret = this.serviceFilterEncode(encIter, 4)) != 0) {
            return ret;
        }
        if (this.checkHasState() && (ret = this.serviceFilterEncode(encIter, 2)) != 0) {
            return ret;
        }
        if (this.groupStateList().size() > 0 && (ret = this.serviceFilterEncode(encIter, 3)) != 0) {
            return ret;
        }
        return this.filterList.encodeComplete(encIter, true);
    }

    private int serviceFilterEncode(EncodeIterator encIter, int filterId) {
        this.filterEntry.clear();
        this.filterEntry.flags(0);
        this.filterEntry.id(filterId);
        switch (filterId) {
            case 5: {
                return this.encodeDataFilter(encIter);
            }
            case 1: {
                return this.encodeInfoFilter(encIter);
            }
            case 6: {
                return this.encodeLinkFilter(encIter);
            }
            case 4: {
                return this.encodeLoadFilter(encIter);
            }
            case 2: {
                return this.encodeStateFilter(encIter);
            }
            case 3: {
                return this.encodeGroupFilter(encIter);
            }
        }
        assert (false);
        return -1;
    }

    private int encodeInfoFilter(EncodeIterator encIter) {
        this.filterEntry.action(this.info().action());
        if (this.filterEntry.action() == 3) {
            return this.filterEntry.encode(encIter);
        }
        int ret = this.filterEntry.encodeInit(encIter, 0);
        if (ret != 0) {
            return ret;
        }
        ret = this.info().encode(encIter);
        if (ret != 0) {
            return ret;
        }
        return this.filterEntry.encodeComplete(encIter, true);
    }

    private int encodeDataFilter(EncodeIterator encIter) {
        this.filterEntry.action(this.data().action());
        if (this.filterEntry.action() == 3) {
            return this.filterEntry.encode(encIter);
        }
        int ret = this.filterEntry.encodeInit(encIter, 0);
        if (ret != 0) {
            return ret;
        }
        ret = this.data().encode(encIter);
        if (ret != 0) {
            return ret;
        }
        return this.filterEntry.encodeComplete(encIter, true);
    }

    private int encodeStateFilter(EncodeIterator encIter) {
        this.filterEntry.action(this.state().action());
        if (this.filterEntry.action() == 3) {
            return this.filterEntry.encode(encIter);
        }
        int ret = this.filterEntry.encodeInit(encIter, 0);
        if (ret != 0) {
            return ret;
        }
        ret = this.state().encode(encIter);
        if (ret != 0) {
            return ret;
        }
        return this.filterEntry.encodeComplete(encIter, true);
    }

    private int encodeLoadFilter(EncodeIterator encIter) {
        this.filterEntry.action(this.load().action());
        if (this.filterEntry.action() == 3) {
            return this.filterEntry.encode(encIter);
        }
        int ret = this.filterEntry.encodeInit(encIter, 0);
        if (ret != 0) {
            return ret;
        }
        ret = this.load().encode(encIter);
        if (ret != 0) {
            return ret;
        }
        return this.filterEntry.encodeComplete(encIter, true);
    }

    private int encodeLinkFilter(EncodeIterator encIter) {
        this.filterEntry.action(this.link().action());
        this.filterEntry.containerType(137);
        this.filterEntry.applyHasContainerType();
        if (this.filterEntry.action() == 3) {
            return this.filterEntry.encode(encIter);
        }
        int ret = this.filterEntry.encodeInit(encIter, 0);
        if (ret != 0) {
            return ret;
        }
        ret = this.link().encode(encIter);
        if (ret != 0) {
            return ret;
        }
        return this.filterEntry.encodeComplete(encIter, true);
    }

    private int encodeGroupFilter(EncodeIterator encIter) {
        int ret = 0;
        for (Service.ServiceGroup group : this.groupStateList) {
            this.filterEntry.clear();
            this.filterEntry.flags(0);
            this.filterEntry.id(3);
            this.filterEntry.action(group.action());
            if (this.filterEntry.action() == 3) {
                ret = this.filterEntry.encode(encIter);
                if (ret == 0) continue;
                return ret;
            }
            ret = this.filterEntry.encodeInit(encIter, 0);
            if (ret != 0) {
                return ret;
            }
            ret = group.encode(encIter);
            if (ret != 0) {
                return ret;
            }
            ret = this.filterEntry.encodeComplete(encIter, true);
            if (ret == 0) continue;
            return ret;
        }
        return ret;
    }

    @Override
    public int decode(DecodeIterator dIter) {
        this.clear();
        this.filterEntry.clear();
        this.filterList.clear();
        int ret = this.filterList.decode(dIter);
        if (ret != 0) {
            return ret;
        }
        while ((ret = this.filterEntry.decode(dIter)) != 14) {
            if (ret != 0) {
                return ret;
            }
            ret = this.decodeFilter(dIter);
            if (ret == 0) continue;
            return ret;
        }
        return 0;
    }

    private int decodeFilter(DecodeIterator dIter) {
        int returnCode = 0;
        switch (this.filterEntry.id()) {
            case 1: {
                Service.ServiceInfo infoFilter = this.info();
                this.applyHasInfo();
                if (this.filterEntry.action() != 3) {
                    returnCode = infoFilter.decode(dIter);
                }
                infoFilter.action(this.filterEntry.action());
                break;
            }
            case 2: {
                Service.ServiceState stateFilter = this.state();
                this.applyHasState();
                if (this.filterEntry.action() != 3) {
                    returnCode = stateFilter.decode(dIter);
                }
                stateFilter.action(this.filterEntry.action());
                break;
            }
            case 3: {
                Service.ServiceGroup groupFilter = new Service.ServiceGroup();
                this.groupStateList().add(groupFilter);
                if (this.filterEntry.action() != 3) {
                    returnCode = groupFilter.decode(dIter);
                }
                groupFilter.action(this.filterEntry.action());
                break;
            }
            case 4: {
                Service.ServiceLoad loadFilter = this.load();
                this.applyHasLoad();
                if (this.filterEntry.action() != 3) {
                    returnCode = loadFilter.decode(dIter);
                }
                loadFilter.action(this.filterEntry.action());
                break;
            }
            case 5: {
                Service.ServiceData dataFilter = this.data();
                this.applyHasData();
                if (this.filterEntry.action() != 3) {
                    returnCode = dataFilter.decode(dIter);
                }
                dataFilter.action(this.filterEntry.action());
                break;
            }
            case 6: {
                Service.ServiceLinkInfo linkFilter = this.link();
                this.applyHasLink();
                if (this.filterEntry.action() != 3) {
                    returnCode = linkFilter.decode(dIter);
                }
                linkFilter.action(this.filterEntry.action());
                break;
            }
            case 7: {
                this.applyHasLink();
                if (this.filterEntry.action() != 3) {
                    returnCode = this.seqMcast.decode(dIter);
                }
                this.seqMcast.action(this.filterEntry.action());
                break;
            }
            default: {
                return -1;
            }
        }
        return returnCode;
    }

    @Override
    public int serviceId() {
        return this.serviceId;
    }

    @Override
    public void serviceId(int serviceId) {
        this.serviceId = serviceId;
    }

    @Override
    public Service.ServiceInfo info() {
        return this.info;
    }

    @Override
    public void info(Service.ServiceInfo info) {
        this.copyServiceInfoRefFrom(info);
    }

    @Override
    public Service.ServiceState state() {
        return this.state;
    }

    @Override
    public void state(Service.ServiceState state) {
        this.copyServiceStateRefFrom(state);
    }

    @Override
    public List<Service.ServiceGroup> groupStateList() {
        return this.groupStateList;
    }

    @Override
    public void groupStateList(List<Service.ServiceGroup> groupStateList) {
        assert (groupStateList != null) : "groupStateList can not be null";
        this.groupStateList().clear();
        for (Service.ServiceGroup serviceGroup : groupStateList) {
            this.groupStateList().add(serviceGroup);
        }
    }

    @Override
    public Service.ServiceLoad load() {
        return this.load;
    }

    @Override
    public void load(Service.ServiceLoad load) {
        this.copyServiceLoadRefFrom(load);
    }

    @Override
    public Service.ServiceData data() {
        return this.data;
    }

    @Override
    public void data(Service.ServiceData data) {
        this.copyServiceDataRefFrom(data);
    }

    @Override
    public Service.ServiceLinkInfo link() {
        return this.link;
    }

    @Override
    public Service.ServiceSeqMcastInfo seqMcastInfo() {
        return this.seqMcast;
    }

    @Override
    public void link(Service.ServiceLinkInfo link) {
        this.copyServiceLinkRefFrom(link);
    }

    @Override
    public int copy(Service destService) {
        assert (destService != null) : "destService can not be null";
        int ret = 0;
        destService.clear();
        destService.action(this.action());
        destService.serviceId(this.serviceId());
        if (this.checkHasInfo()) {
            ret = this.info().copy(destService.info());
            if (ret != 0) {
                return ret;
            }
            destService.applyHasInfo();
        }
        if (this.checkHasData()) {
            ret = this.data().copy(destService.data());
            if (ret != 0) {
                return ret;
            }
            destService.applyHasData();
        }
        for (Service.ServiceGroup group : this.groupStateList()) {
            Service.ServiceGroup destGroup = new Service.ServiceGroup();
            destService.groupStateList().add(destGroup);
            ret = group.copy(destGroup);
            if (ret == 0) continue;
            return ret;
        }
        if (this.checkHasLink()) {
            ret = this.link().copy(destService.link());
            if (ret != 0) {
                return ret;
            }
            destService.applyHasLink();
        }
        if (this.checkHasLoad()) {
            ret = this.load().copy(destService.load());
            if (ret != 0) {
                return ret;
            }
            destService.applyHasLoad();
        }
        if (this.checkHasState()) {
            ret = this.state().copy(destService.state());
            if (ret != 0) {
                return ret;
            }
            destService.applyHasState();
        }
        return 0;
    }

    @Override
    public int applyUpdate(Service destService) {
        assert (destService != null) : "destService can not be null";
        int ret = 0;
        destService.action(this.action());
        destService.serviceId(this.serviceId());
        if (this.checkHasInfo()) {
            ret = this.info().update(destService.info());
            if (ret != 0) {
                return ret;
            }
            destService.applyHasInfo();
        }
        if (this.checkHasData()) {
            ret = this.data().update(destService.data());
            if (ret != 0) {
                return ret;
            }
            destService.applyHasData();
        }
        for (Service.ServiceGroup group : this.groupStateList()) {
            Service.ServiceGroup destGroup = new Service.ServiceGroup();
            destService.groupStateList().add(destGroup);
            ret = group.copy(destGroup);
            if (ret == 0) continue;
            return ret;
        }
        if (this.checkHasLink()) {
            ret = this.link().update(destService.link());
            if (ret != 0) {
                return ret;
            }
            destService.applyHasLink();
        }
        if (this.checkHasLoad()) {
            ret = this.load().update(destService.load());
            if (ret != 0) {
                return ret;
            }
            destService.applyHasLoad();
        }
        if (this.checkHasState()) {
            ret = this.state().update(destService.state());
            if (ret != 0) {
                return ret;
            }
            destService.applyHasState();
        }
        return 0;
    }

    public String toString() {
        this.stringBuf.setLength(0);
        this.stringBuf.append(tab);
        this.stringBuf.append("Service:");
        this.stringBuf.append(eol);
        this.stringBuf.append(tab);
        this.stringBuf.append(tab);
        this.stringBuf.append("serviceId: ");
        this.stringBuf.append(this.serviceId());
        this.stringBuf.append(eol);
        if (this.checkHasInfo()) {
            this.stringBuf.append(this.info());
        }
        if (this.checkHasData()) {
            this.stringBuf.append(this.data());
        }
        if (this.checkHasLink()) {
            this.stringBuf.append(this.link());
        }
        if (this.checkHasState()) {
            this.stringBuf.append(this.state());
        }
        if (this.checkHasLoad()) {
            this.stringBuf.append(this.load());
        }
        if (!this.groupStateList().isEmpty()) {
            this.stringBuf.append(this.groupStateList());
        }
        return this.stringBuf.toString();
    }

    private void copyServiceInfoRefFrom(Service.ServiceInfo srcServiceInfo) {
        assert (srcServiceInfo != null) : "srcServiceInfo can not be null";
        this.info().serviceName(srcServiceInfo.serviceName());
        this.info().action(srcServiceInfo.action());
        this.info().capabilitiesList(srcServiceInfo.capabilitiesList());
        if (srcServiceInfo.checkHasAcceptingConsumerStatus()) {
            this.info().applyHasAcceptingConsumerStatus();
            this.info().acceptingConsumerStatus(srcServiceInfo.acceptingConsumerStatus());
        }
        if (srcServiceInfo.checkHasDictionariesProvided()) {
            this.info().applyHasDictionariesProvided();
            this.info().dictionariesProvidedList(srcServiceInfo.dictionariesProvidedList());
        }
        if (srcServiceInfo.checkHasDictionariesUsed()) {
            this.info().applyHasDictionariesUsed();
            this.info().dictionariesUsedList(srcServiceInfo.dictionariesUsedList());
        }
        if (srcServiceInfo.checkHasIsSource()) {
            this.info().applyHasIsSource();
            this.info().isSource(srcServiceInfo.isSource());
        }
        if (srcServiceInfo.checkHasItemList()) {
            this.info().applyHasItemList();
            this.info().itemList(srcServiceInfo.itemList());
        }
        if (srcServiceInfo.checkHasQos()) {
            this.info().applyHasQos();
            this.info().qosList(srcServiceInfo.qosList());
        }
        if (srcServiceInfo.checkHasSupportsOutOfBandSnapshots()) {
            this.info().applyHasSupportsOutOfBandSnapshots();
            this.info().supportsOutOfBandSnapshots(srcServiceInfo.supportsOutOfBandSnapshots());
        }
        if (srcServiceInfo.checkHasSupportsQosRange()) {
            this.info().applyHasSupportsQosRange();
            this.info().supportsQosRange(srcServiceInfo.supportsQosRange());
        }
        if (srcServiceInfo.checkHasVendor()) {
            this.info().applyHasVendor();
            this.info().vendor(srcServiceInfo.vendor());
        }
    }

    private void copyServiceDataRefFrom(Service.ServiceData srcData) {
        assert (srcData != null) : "srcData can not be null";
        this.data().action(srcData.action());
        this.data().type(srcData.type());
        this.data().flags(srcData.flags());
        if (srcData.checkHasData()) {
            this.data().applyHasData();
            this.data().dataType(srcData.dataType());
            this.data().data(srcData.data());
        }
    }

    private void copyServiceLinkRefFrom(Service.ServiceLinkInfo srcLink) {
        assert (srcLink != null) : "srcLink can not be null";
        this.link().action(srcLink.action());
        this.link().linkList(srcLink.linkList());
    }

    private void copyServiceLoadRefFrom(Service.ServiceLoad srcLoad) {
        assert (srcLoad != null) : "srcLoad can not be null";
        this.load().action(srcLoad.action());
        if (srcLoad.checkHasLoadFactor()) {
            this.load().applyHasLoadFactor();
            this.load().loadFactor(srcLoad.loadFactor());
        }
        if (srcLoad.checkHasOpenLimit()) {
            this.load().applyHasOpenLimit();
            this.load().openLimit(srcLoad.openLimit());
        }
        if (srcLoad.checkHasOpenWindow()) {
            this.load().applyHasOpenWindow();
            this.load().openWindow(srcLoad.openWindow());
        }
    }

    private void copyServiceStateRefFrom(Service.ServiceState srcState) {
        assert (srcState != null) : "srcState can not be null";
        this.state().flags(srcState.flags());
        this.state().action(srcState.action());
        this.state().serviceState(srcState.serviceState());
        if (srcState.checkHasAcceptingRequests()) {
            this.state().applyHasAcceptingRequests();
            this.state().acceptingRequests(srcState.acceptingRequests());
        }
        if (srcState.checkHasStatus()) {
            this.state().applyHasStatus();
            this.state().status(srcState.status());
        }
    }
}

