/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.cache;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DataDictionary;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.FieldList;
import com.refinitiv.eta.codec.FilterList;
import com.refinitiv.eta.codec.Map;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.Series;
import com.refinitiv.eta.codec.Vector;
import com.refinitiv.eta.transport.TransportBuffer;
import com.refinitiv.eta.valueadd.cache.CacheError;
import com.refinitiv.eta.valueadd.cache.CacheErrorImpl;
import com.refinitiv.eta.valueadd.cache.CacheFactory;
import com.refinitiv.eta.valueadd.cache.CacheJNIBuffer;
import com.refinitiv.eta.valueadd.cache.PayloadCache;
import com.refinitiv.eta.valueadd.cache.PayloadCacheImpl;
import com.refinitiv.eta.valueadd.cache.PayloadCursor;
import com.refinitiv.eta.valueadd.cache.PayloadCursorImpl;
import com.refinitiv.eta.valueadd.cache.PayloadEntry;
import com.refinitiv.eta.valueadd.common.VaNode;
import java.io.PrintWriter;
import java.nio.ByteBuffer;

class PayloadEntryImpl
extends VaNode
implements PayloadEntry {
    private boolean _isEntryDestroyed = true;
    private PayloadCacheImpl _cacheInstance = null;
    private long _etaCacheEntryRef = 0L;
    private short _dataType = 0;
    private int _majorVer = 0;
    private int _minorVer = 0;
    private static int TRACE_BUF_SIZE = 6144;
    private FieldList _fieldList = null;
    private ElementList _elementList = null;
    private Map _map = null;
    private Series _series = null;
    private Vector _vector = null;
    private FilterList _filterList = null;
    private DecodeIterator _traceDIter = null;
    private Buffer _traceBuffer = null;
    private PayloadCursorImpl _traceCursor = null;

    public PayloadEntryImpl(PayloadCache cacheInstance, long etaCacheEntryRef) {
        this._cacheInstance = (PayloadCacheImpl)cacheInstance;
        this._etaCacheEntryRef = etaCacheEntryRef;
        this._isEntryDestroyed = false;
    }

    public static PayloadEntry create(PayloadCache cacheInstance, CacheError error) {
        long etaCacheEntryRef = ((PayloadCacheImpl)cacheInstance).createCacheEntry(error);
        if (etaCacheEntryRef != 0L) {
            PayloadEntryImpl entry = new PayloadEntryImpl(cacheInstance, etaCacheEntryRef);
            ((PayloadCacheImpl)cacheInstance).addCacheEntry(entry);
            return entry;
        }
        return null;
    }

    @Override
    public void destroy() {
        if (this._isEntryDestroyed) {
            return;
        }
        this.etaDestroyEntry(this._etaCacheEntryRef);
        this._cacheInstance.removeCacheEntry(this);
        this._isEntryDestroyed = true;
    }

    @Override
    public void clear() {
        if (this._isEntryDestroyed) {
            return;
        }
        this._dataType = 0;
        this.etaClearEntry(this._etaCacheEntryRef);
    }

    @Override
    public short dataType() {
        if (this._isEntryDestroyed) {
            return 0;
        }
        return this._dataType;
    }

    @Override
    public int apply(DecodeIterator dIter, Msg msg, CacheError error) {
        if (error == null) {
            throw new UnsupportedOperationException("PayloadEntryImpl.apply: error cannot be null, data not apply.");
        }
        if (this._isEntryDestroyed) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -29, "PayloadCacheEntryImpl.apply error: the cache instance has been destroyed.");
        }
        if (dIter == null || msg == null) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -22, "PayloadCacheEntryImpl.apply error: dIter or msg cannot be null, data not apply.");
        }
        int dataLen = msg.encodedMsgBuffer().length();
        CacheJNIBuffer applyBuffer = this._cacheInstance.acquireCacheApplyJNIBuffer(dataLen, error);
        if (applyBuffer == null) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -1, "PayloadCacheEntryImpl.apply error: unable to create jni buffer, data not apply.");
        }
        Buffer encodedBuf = msg.encodedMsgBuffer();
        encodedBuf.copy(applyBuffer._data);
        this._majorVer = dIter.majorVersion();
        this._minorVer = dIter.minorVersion();
        int ret = this.etaApply(this._etaCacheEntryRef, applyBuffer._etaBufferCPtr, dataLen, this._majorVer, this._minorVer, error);
        if (ret < 0 && ret == error.errorId()) {
            this._cacheInstance.releaseCacheApplyJNIBuffer(applyBuffer);
            return ret;
        }
        this._dataType = (short)msg.containerType();
        this._cacheInstance.releaseCacheApplyJNIBuffer(applyBuffer);
        return ret;
    }

    @Override
    public int retrieve(EncodeIterator eIter, PayloadCursor cursor, CacheError error) {
        if (error == null) {
            throw new UnsupportedOperationException("PayloadEntryImpl.retrieve: error cannot be null, unable receive data.");
        }
        if (this._isEntryDestroyed) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -29, "PayloadCacheEntryImpl.retrieve error: the cache instance has been destroyed.");
        }
        if (eIter == null) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -22, "PayloadCacheEntryImpl.retrieve error: eIter cannot be null, unable receive data.");
        }
        int fragmentSize = 0;
        ByteBuffer readByteBuffer = null;
        Buffer readBuffer = null;
        TransportBuffer readTransportBuffer = null;
        readTransportBuffer = eIter.transportBuffer();
        if (readTransportBuffer != null) {
            readByteBuffer = readTransportBuffer.data();
            fragmentSize = readByteBuffer.remaining();
        } else {
            readBuffer = eIter.buffer();
            if (readBuffer != null) {
                readByteBuffer = readBuffer.data();
                fragmentSize = readByteBuffer.remaining();
            }
        }
        if (fragmentSize == 0) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -29, "PayloadCacheEntryImpl.retrieve error: invalid buffer tied with eIter, unable receive data.");
        }
        CacheJNIBuffer retrieveBuffer = this._cacheInstance.acquireCacheRetrieveJNIBuffer(fragmentSize, error);
        if (retrieveBuffer == null) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -1, "PayloadCacheEntryImpl.retrieve error: unable to create jni buffer, unable receive data.");
        }
        PayloadCursorImpl cursorUsed = (PayloadCursorImpl)cursor;
        if (cursorUsed != null && cursorUsed.isDestroyed()) {
            return PayloadCacheImpl.populateErrorInfo((CacheErrorImpl)error, -22, "PayloadCacheEntryImpl.retrieve error: invalid cursor, unable receive data.");
        }
        int ret = this.etaRetrieve(this._etaCacheEntryRef, retrieveBuffer._etaBufferCPtr, fragmentSize, eIter.majorVersion(), eIter.minorVersion(), cursorUsed, cursorUsed != null ? cursorUsed.getETACursorRef() : 0L, error);
        if (ret < 0) {
            this._cacheInstance.releaseCacheRetrieveJNIBuffer(retrieveBuffer);
            return ret;
        }
        retrieveBuffer._data.position(0);
        retrieveBuffer._data.limit(ret);
        readByteBuffer.put(retrieveBuffer._data);
        this._cacheInstance.releaseCacheRetrieveJNIBuffer(retrieveBuffer);
        return 0;
    }

    @Override
    public int trace(int traceFormat, PrintWriter fileWriter, DataDictionary dictionary) {
        CacheJNIBuffer retrieveBuffer;
        if (this._isEntryDestroyed || fileWriter == null || dictionary == null || this._dataType == 128) {
            return -1;
        }
        if (this._traceCursor == null) {
            this._traceCursor = (PayloadCursorImpl)CacheFactory.createPayloadCursor();
            if (this._traceCursor == null) {
                return -1;
            }
        } else {
            this._traceCursor.clear();
        }
        if ((retrieveBuffer = this._cacheInstance.acquireCacheRetrieveJNIBuffer(TRACE_BUF_SIZE, null)) == null) {
            return -1;
        }
        int ret = -1;
        if (this._traceDIter == null) {
            this._traceDIter = CodecFactory.createDecodeIterator();
            this._traceBuffer = CodecFactory.createBuffer();
        }
        if (traceFormat == 1) {
            while (!this._traceCursor.isComplete()) {
                retrieveBuffer.clear();
                ret = this.etaRetrieve(this._etaCacheEntryRef, retrieveBuffer._etaBufferCPtr, TRACE_BUF_SIZE, this._majorVer, this._minorVer, this._traceCursor, this._traceCursor.getETACursorRef(), null);
                if (ret < 0) {
                    this._cacheInstance.releaseCacheRetrieveJNIBuffer(retrieveBuffer);
                    return ret;
                }
                retrieveBuffer._data.position(0);
                retrieveBuffer._data.limit(ret);
                this._traceBuffer.data(retrieveBuffer._data);
                this._traceDIter.clear();
                this._traceDIter.setBufferAndRWFVersion(this._traceBuffer, this._majorVer, this._minorVer);
                switch (this._dataType) {
                    case 132: {
                        if (this._fieldList == null) {
                            this._fieldList = CodecFactory.createFieldList();
                        } else {
                            this._fieldList.clear();
                        }
                        fileWriter.printf(this._fieldList.decodeToXml(this._traceDIter, dictionary), new Object[0]);
                        break;
                    }
                    case 133: {
                        if (this._elementList == null) {
                            this._elementList = CodecFactory.createElementList();
                        } else {
                            this._elementList.clear();
                        }
                        fileWriter.printf(this._elementList.decodeToXml(this._traceDIter, dictionary), new Object[0]);
                        break;
                    }
                    case 137: {
                        if (this._map == null) {
                            this._map = CodecFactory.createMap();
                        } else {
                            this._map.clear();
                        }
                        fileWriter.printf(this._map.decodeToXml(this._traceDIter, dictionary), new Object[0]);
                        break;
                    }
                    case 136: {
                        if (this._vector == null) {
                            this._vector = CodecFactory.createVector();
                        } else {
                            this._vector.clear();
                        }
                        fileWriter.printf(this._vector.decodeToXml(this._traceDIter, dictionary), new Object[0]);
                        break;
                    }
                    case 138: {
                        if (this._series == null) {
                            this._series = CodecFactory.createSeries();
                        } else {
                            this._series.clear();
                        }
                        fileWriter.printf(this._series.decodeToXml(this._traceDIter, dictionary), new Object[0]);
                        break;
                    }
                    case 135: {
                        if (this._filterList == null) {
                            this._filterList = CodecFactory.createFilterList();
                        } else {
                            this._filterList.clear();
                        }
                        fileWriter.printf(this._filterList.decodeToXml(this._traceDIter, dictionary), new Object[0]);
                        break;
                    }
                    default: {
                        System.out.println("PayloadEntryImpl.trace error: unsupported data type.");
                        ret = -1;
                    }
                }
                fileWriter.flush();
            }
        } else {
            System.out.println("PayloadEntryImpl.trace error: unsupported trace format.");
            ret = -1;
        }
        this._cacheInstance.releaseCacheRetrieveJNIBuffer(retrieveBuffer);
        return ret >= 0 ? 0 : -1;
    }

    public void applyDestroy() {
        this._isEntryDestroyed = true;
    }

    public native void etaClearEntry(long var1);

    public native void etaDestroyEntry(long var1);

    public native int etaApply(long var1, long var3, int var5, int var6, int var7, CacheError var8);

    public native int etaRetrieve(long var1, long var3, int var5, int var6, int var7, PayloadCursorImpl var8, long var9, CacheError var11);

    class TraceFormat {
        static final int TRACE_CONTAINER = -1;
        static final int TRACE_XML = 1;

        TraceFormat() {
        }
    }
}

