/*
 * Decompiled with CFR 0.152.
 */
package com.redmadrobot.inputmask.model.state;

import com.redmadrobot.inputmask.model.Next;
import com.redmadrobot.inputmask.model.State;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/redmadrobot/inputmask/model/state/OptionalValueState;", "Lcom/redmadrobot/inputmask/model/State;", "child", "type", "Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType;", "(Lcom/redmadrobot/inputmask/model/State;Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType;)V", "getType", "()Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType;", "accept", "Lcom/redmadrobot/inputmask/model/Next;", "character", "", "accepts", "", "toString", "", "StateType", "input-mask-android_release"})
public final class OptionalValueState
extends State {
    @NotNull
    private final StateType type;

    private final boolean accepts(char character) {
        boolean bl;
        StateType stateType = this.type;
        if (stateType instanceof StateType.Numeric) {
            char c = character;
            bl = Character.isDigit(c);
        } else if (stateType instanceof StateType.Literal) {
            char c = character;
            bl = Character.isLetter(c);
        } else if (stateType instanceof StateType.AlphaNumeric) {
            char c = character;
            bl = Character.isLetterOrDigit(c);
        } else if (stateType instanceof StateType.Custom) {
            bl = StringsKt.contains$default((CharSequence)((StateType.Custom)this.type).getCharacterSet(), (char)character, (boolean)false, (int)2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    @Nullable
    public Next accept(char character) {
        return this.accepts(character) ? new Next(this.nextState(), Character.valueOf(character), true, Character.valueOf(character)) : new Next(this.nextState(), null, false, null);
    }

    @Override
    @NotNull
    public String toString() {
        String string;
        StateType stateType = this.type;
        if (stateType instanceof StateType.Literal) {
            string = "[a] -> " + (this.getChild() == null ? "null" : this.getChild().toString());
        } else if (stateType instanceof StateType.Numeric) {
            string = "[9] -> " + (this.getChild() == null ? "null" : this.getChild().toString());
        } else if (stateType instanceof StateType.AlphaNumeric) {
            string = "[-] -> " + (this.getChild() == null ? "null" : this.getChild().toString());
        } else if (stateType instanceof StateType.Custom) {
            string = "[" + ((StateType.Custom)this.type).getCharacter() + "] -> " + (this.getChild() == null ? "null" : this.getChild().toString());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final StateType getType() {
        return this.type;
    }

    public OptionalValueState(@NotNull State child, @NotNull StateType type) {
        Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        super(child);
        this.type = type;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType;", "", "()V", "AlphaNumeric", "Custom", "Literal", "Numeric", "Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType$Numeric;", "Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType$Literal;", "Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType$AlphaNumeric;", "Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType$Custom;", "input-mask-android_release"})
    public static abstract class StateType {
        private StateType() {
        }

        public /* synthetic */ StateType(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType$Numeric;", "Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType;", "()V", "input-mask-android_release"})
        public static final class Numeric
        extends StateType {
            public Numeric() {
                super(null);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType$Literal;", "Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType;", "()V", "input-mask-android_release"})
        public static final class Literal
        extends StateType {
            public Literal() {
                super(null);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType$AlphaNumeric;", "Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType;", "()V", "input-mask-android_release"})
        public static final class AlphaNumeric
        extends StateType {
            public AlphaNumeric() {
                super(null);
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType$Custom;", "Lcom/redmadrobot/inputmask/model/state/OptionalValueState$StateType;", "character", "", "characterSet", "", "(CLjava/lang/String;)V", "getCharacter", "()C", "getCharacterSet", "()Ljava/lang/String;", "input-mask-android_release"})
        public static final class Custom
        extends StateType {
            private final char character;
            @NotNull
            private final String characterSet;

            public final char getCharacter() {
                return this.character;
            }

            @NotNull
            public final String getCharacterSet() {
                return this.characterSet;
            }

            public Custom(char character, @NotNull String characterSet) {
                Intrinsics.checkParameterIsNotNull((Object)characterSet, (String)"characterSet");
                super(null);
                this.character = character;
                this.characterSet = characterSet;
            }
        }
    }
}

