/*
 * Decompiled with CFR 0.152.
 */
package redgatesqlci;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import redgatesqlci.Utils;

public class PublishBuilder
extends Builder {
    private final String packageid;
    private final String nugetFeedUrl;
    private final String nugetFeedApiKey;
    private final String packageVersion;

    public String getPackageid() {
        return this.packageid;
    }

    public String getNugetFeedUrl() {
        return this.nugetFeedUrl;
    }

    public String getNugetFeedApiKey() {
        return this.nugetFeedApiKey;
    }

    public String getPackageVersion() {
        return this.packageVersion;
    }

    @DataBoundConstructor
    public PublishBuilder(String packageid, String nugetFeedUrl, String nugetFeedApiKey, String packageVersion) {
        this.packageid = packageid;
        this.nugetFeedUrl = nugetFeedUrl;
        this.nugetFeedApiKey = nugetFeedApiKey;
        this.packageVersion = packageVersion;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        ArrayList<String> params = new ArrayList<String>();
        String buildNumber = "1.0." + Integer.toString(build.getNumber());
        if (this.getPackageVersion() != null && !this.getPackageVersion().isEmpty()) {
            buildNumber = this.getPackageVersion();
        }
        String packageFileName = Utils.constructPackageFileName(this.getPackageid(), buildNumber);
        params.add("PUBLISH");
        params.add("/package=" + packageFileName);
        params.add("/nugetFeedUrl=" + this.getNugetFeedUrl());
        if (!this.getNugetFeedApiKey().isEmpty()) {
            params.add("/nugetFeedApiKey=" + this.getNugetFeedApiKey());
        }
        return Utils.runSQLCIWithParams(build, launcher, listener, params);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckPackageid(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Enter a package ID");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckNugetFeedUrl(@QueryParameter String nugetFeedUrl) throws IOException, ServletException {
            if (nugetFeedUrl.length() == 0) {
                return FormValidation.error((String)"Enter a NuGet package feed URL");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Redgate SQL CI: Publish a database package";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

