/*
 * Decompiled with CFR 0.152.
 */
package redgatesqlci;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jenkins.security.MasterToSlaveCallable;

public class Utils {
    public static boolean runSQLCIWithParams(AbstractBuild build, Launcher launcher, BuildListener listener, Collection<String> params) {
        String[] possibleSqlCiLocations;
        VirtualChannel channel = launcher.getChannel();
        String sqlCiLocation = "";
        String allLocations = "";
        for (String possibleLocation : possibleSqlCiLocations = new String[]{Utils.getEnvironmentVariable("DLMAS_HOME", channel) + "sqlCI\\sqlci.exe", Utils.getEnvironmentVariable("ProgramFiles", channel) + "\\Red Gate\\DLM Automation Suite 1\\sqlCI\\sqlci.exe", Utils.getEnvironmentVariable("ProgramFiles", channel) + "\\Red Gate\\SQL Automation Pack 1\\sqlCI\\sqlci.exe", Utils.getEnvironmentVariable("ProgramFiles", channel) + "\\Red Gate\\sqlCI\\sqlci.exe", Utils.getEnvironmentVariable("ProgramFiles(X86)", channel) + "\\Red Gate\\DLM Automation Suite 1\\sqlCI\\sqlci.exe", Utils.getEnvironmentVariable("ProgramFiles(X86)", channel) + "\\Red Gate\\SQL Automation Pack 1\\sqlCI\\sqlci.exe", Utils.getEnvironmentVariable("ProgramFiles(X86)", channel) + "\\Red Gate\\sqlCI\\sqlci.exe"}) {
            if (Utils.ciExists(possibleLocation, channel)) {
                sqlCiLocation = possibleLocation;
                break;
            }
            allLocations = allLocations.concat(possibleLocation + "  ");
        }
        if (sqlCiLocation == "") {
            listener.error("SQL CI executable cannot be found. Checked " + allLocations + ". Please install Redgate DLM Automation on this agent.");
            return false;
        }
        ArrayList<String> procParams = new ArrayList<String>();
        procParams.add(sqlCiLocation);
        String longString = sqlCiLocation;
        for (String param : params) {
            String fixedParam = param.trim();
            if (fixedParam.contains("\"")) {
                fixedParam = fixedParam.replace("\"", "\\\\\\\"");
            }
            if (fixedParam.contains(" ")) {
                int equalsPlace = fixedParam.indexOf("=");
                fixedParam = fixedParam.substring(0, equalsPlace + 1) + "\\\"" + fixedParam.substring(equalsPlace + 1, fixedParam.length()) + "\\\"";
            }
            procParams.add(param);
            longString = longString + " " + fixedParam;
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.putAll(build.getBuildVariables());
        Proc proc = null;
        Launcher.ProcStarter procStarter = new Launcher.ProcStarter(launcher);
        EnvVars envVars = new EnvVars();
        try {
            envVars = build.getEnvironment((TaskListener)listener);
            vars.putAll((Map<String, String>)envVars);
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        vars.put("REDGATE_FUR_ENVIRONMENT", "Jenkins Plugin");
        procStarter.envs(vars);
        procStarter.cmdAsSingleString(longString).stdout((OutputStream)listener.getLogger()).stderr((OutputStream)listener.getLogger()).pwd(build.getWorkspace());
        try {
            proc = launcher.launch(procStarter);
            int exitCode = proc.join();
            return exitCode == 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            listener.getLogger().println("IOException");
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            listener.getLogger().println("InterruptedException");
            return false;
        }
    }

    public static String constructPackageFileName(String packageName, String buildNumber) {
        return packageName + "." + buildNumber + ".nupkg";
    }

    private static String getEnvironmentVariable(final String variableName, VirtualChannel channel) {
        try {
            return (String)channel.call((Callable)new MasterToSlaveCallable<String, RuntimeException>(){

                public String call() {
                    return System.getenv(variableName);
                }
            });
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean ciExists(final String possibleLocation, VirtualChannel channel) {
        try {
            return (Boolean)channel.call((Callable)new MasterToSlaveCallable<Boolean, RuntimeException>(){

                public Boolean call() {
                    return new File(possibleLocation).isFile();
                }
            });
        }
        catch (Exception e) {
            return false;
        }
    }
}

