/*
 * Decompiled with CFR 0.152.
 */
package com.reddit.indicatorfastscroll;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.DimenRes;
import androidx.annotation.StyleRes;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.TypedArrayKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u0005*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\b\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\t\u001a\u00020\u0001H\u0000\u001a$\u0010\n\u001a\u00020\u000b*\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u00012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0000\u00a8\u0006\u0010"}, d2={"getColorFromAttr", "", "Landroid/content/Context;", "attrId", "getColorStateListFromAttr", "Landroid/content/res/ColorStateList;", "getDimenPixelSize", "dimen", "getResId", "attr", "throwIfMissingAttrs", "", "Landroid/view/View;", "styleRes", "block", "Lkotlin/Function0;", "indicator-fast-scroll_release"})
public final class ResourcesUtilKt {
    public static final int getColorFromAttr(@NotNull Context $this$getColorFromAttr, @AttrRes int attrId) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getColorFromAttr, (String)"$this$getColorFromAttr");
        return ContextCompat.getColor((Context)$this$getColorFromAttr, (int)ResourcesUtilKt.getResId($this$getColorFromAttr, attrId));
    }

    @NotNull
    public static final ColorStateList getColorStateListFromAttr(@NotNull Context $this$getColorStateListFromAttr, @AttrRes int attrId) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getColorStateListFromAttr, (String)"$this$getColorStateListFromAttr");
        ColorStateList colorStateList = ContextCompat.getColorStateList((Context)$this$getColorStateListFromAttr, (int)ResourcesUtilKt.getResId($this$getColorStateListFromAttr, attrId));
        if (colorStateList == null) {
            Intrinsics.throwNpe();
        }
        return colorStateList;
    }

    public static final int getResId(@NotNull Context $this$getResId, @AttrRes int attr2) {
        int n;
        TypedArray $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$getResId, (String)"$this$getResId");
        TypedArray typedArray = $this$getResId.getTheme().obtainStyledAttributes(new int[]{attr2});
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"theme.obtainStyledAttributes(intArrayOf(attr))");
        TypedArray it = $receiver$iv = typedArray;
        boolean bl = false;
        int it$iv = n = TypedArrayKt.getResourceIdOrThrow((TypedArray)it, (int)0);
        $receiver$iv.recycle();
        return n;
    }

    public static final int getDimenPixelSize(@NotNull Context $this$getDimenPixelSize, @DimenRes int dimen) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getDimenPixelSize, (String)"$this$getDimenPixelSize");
        return $this$getDimenPixelSize.getResources().getDimensionPixelSize(dimen);
    }

    public static final void throwIfMissingAttrs(@NotNull View $this$throwIfMissingAttrs, @StyleRes int styleRes, @NotNull Function0<Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)$this$throwIfMissingAttrs, (String)"$this$throwIfMissingAttrs");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            block.invoke();
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new IllegalArgumentException("This " + $this$throwIfMissingAttrs.getClass().getSimpleName() + " is missing an attribute. " + "Add it to its style, or make the style inherit from " + $this$throwIfMissingAttrs.getResources().getResourceName(styleRes) + '.', e);
        }
    }
}

