/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.AccountClient;
import com.razorpay.AddonClient;
import com.razorpay.ApiUtils;
import com.razorpay.CardClient;
import com.razorpay.CustomerClient;
import com.razorpay.FundAccountClient;
import com.razorpay.IinClient;
import com.razorpay.InvoiceClient;
import com.razorpay.ItemClient;
import com.razorpay.OrderClient;
import com.razorpay.PaymentClient;
import com.razorpay.PaymentLinkClient;
import com.razorpay.PlanClient;
import com.razorpay.ProductClient;
import com.razorpay.QrCodeClient;
import com.razorpay.RazorpayException;
import com.razorpay.RefundClient;
import com.razorpay.SettlementClient;
import com.razorpay.StakeholderClient;
import com.razorpay.SubscriptionClient;
import com.razorpay.TncMap;
import com.razorpay.TokenClient;
import com.razorpay.TransferClient;
import com.razorpay.VirtualAccountClient;
import com.razorpay.WebhookClient;
import java.util.Map;
import okhttp3.Credentials;

public class RazorpayClient {
    public PaymentClient payments;
    public RefundClient refunds;
    public OrderClient orders;
    public InvoiceClient invoices;
    public CardClient cards;
    public CustomerClient customers;
    public TransferClient transfers;
    public SubscriptionClient subscriptions;
    public AddonClient addons;
    public PlanClient plans;
    public SettlementClient settlement;
    public QrCodeClient qrCode;
    public PaymentLinkClient paymentLink;
    public ItemClient items;
    public FundAccountClient fundAccount;
    public VirtualAccountClient virtualAccounts;
    public TokenClient token;
    public IinClient iin;
    public AccountClient account;
    public StakeholderClient stakeholder;
    public ProductClient product;
    public WebhookClient webhook;
    public TncMap tncMap;

    public RazorpayClient(String key, String secret) throws RazorpayException {
        this(key, secret, false);
    }

    public RazorpayClient(String key, String secret, Boolean enableLogging) throws RazorpayException {
        ApiUtils.createHttpClientInstance(enableLogging);
        String auth = Credentials.basic((String)key, (String)secret);
        this.payments = new PaymentClient(auth);
        this.refunds = new RefundClient(auth);
        this.orders = new OrderClient(auth);
        this.invoices = new InvoiceClient(auth);
        this.cards = new CardClient(auth);
        this.customers = new CustomerClient(auth);
        this.transfers = new TransferClient(auth);
        this.subscriptions = new SubscriptionClient(auth);
        this.addons = new AddonClient(auth);
        this.plans = new PlanClient(auth);
        this.settlement = new SettlementClient(auth);
        this.qrCode = new QrCodeClient(auth);
        this.paymentLink = new PaymentLinkClient(auth);
        this.items = new ItemClient(auth);
        this.fundAccount = new FundAccountClient(auth);
        this.virtualAccounts = new VirtualAccountClient(auth);
        this.token = new TokenClient(auth);
        this.iin = new IinClient(auth);
        this.account = new AccountClient(auth);
        this.stakeholder = new StakeholderClient(auth);
        this.product = new ProductClient(auth);
        this.webhook = new WebhookClient(auth);
    }

    public RazorpayClient addHeaders(Map<String, String> headers) {
        ApiUtils.addHeaders(headers);
        return this;
    }
}

