/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.ApiClient;
import com.razorpay.Invoice;
import com.razorpay.RazorpayException;
import java.util.List;
import org.json.JSONObject;

public class InvoiceClient
extends ApiClient {
    InvoiceClient(String auth) {
        super(auth);
    }

    public Invoice create(JSONObject request) throws RazorpayException {
        return (Invoice)this.post("invoices", request);
    }

    public List<Invoice> fetchAll() throws RazorpayException {
        return this.fetchAll(null);
    }

    public List<Invoice> fetchAll(JSONObject request) throws RazorpayException {
        return this.getCollection("invoices", request);
    }

    public Invoice fetch(String id) throws RazorpayException {
        return (Invoice)this.get(String.format("invoices/%s", id), null);
    }

    public Invoice cancel(String id) throws RazorpayException {
        return (Invoice)this.post(String.format("invoices/%s/cancel", id), null);
    }

    public Invoice notifyBy(String id, String medium) throws RazorpayException {
        return (Invoice)this.post(String.format("invoices/%s/notify_by/%s", id, medium), null);
    }

    public Invoice createRegistrationLink(JSONObject request) throws RazorpayException {
        return (Invoice)this.post("subscription_registration/auth_links", request);
    }

    public Invoice issue(String id) throws RazorpayException {
        return (Invoice)this.post(String.format("invoices/%s/issue", id), null);
    }

    public Invoice edit(String id, JSONObject request) throws RazorpayException {
        return (Invoice)this.patch(String.format("invoices/%s", id), request);
    }

    public List<Invoice> delete(String id) throws RazorpayException {
        return (List)this.delete(String.format("invoices/%s", id), null);
    }
}

