/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.AddonClient;
import com.razorpay.ApiUtils;
import com.razorpay.CardClient;
import com.razorpay.CustomerClient;
import com.razorpay.FundAccountClient;
import com.razorpay.InvoiceClient;
import com.razorpay.ItemClient;
import com.razorpay.OrderClient;
import com.razorpay.PaymentClient;
import com.razorpay.PaymentLinkClient;
import com.razorpay.PlanClient;
import com.razorpay.QrCodeClient;
import com.razorpay.RazorpayException;
import com.razorpay.RefundClient;
import com.razorpay.SettlementClient;
import com.razorpay.SubscriptionClient;
import com.razorpay.TransferClient;
import com.razorpay.VirtualAccountClient;
import java.util.Map;
import okhttp3.Credentials;

public class RazorpayClient {
    public PaymentClient payments;
    public RefundClient refunds;
    public OrderClient orders;
    public InvoiceClient invoices;
    public CardClient cards;
    public CustomerClient customers;
    public TransferClient transfers;
    public SubscriptionClient subscriptions;
    public AddonClient addons;
    public PlanClient plans;
    public SettlementClient settlement;
    public QrCodeClient qrCode;
    public PaymentLinkClient paymentLink;
    public ItemClient items;
    public FundAccountClient fundAccount;
    public VirtualAccountClient virtualAccounts;

    public RazorpayClient(String key, String secret) throws RazorpayException {
        this(key, secret, false);
    }

    public RazorpayClient(String key, String secret, Boolean enableLogging) throws RazorpayException {
        ApiUtils.createHttpClientInstance(enableLogging);
        String auth = Credentials.basic((String)key, (String)secret);
        this.payments = new PaymentClient(auth);
        this.refunds = new RefundClient(auth);
        this.orders = new OrderClient(auth);
        this.invoices = new InvoiceClient(auth);
        this.cards = new CardClient(auth);
        this.customers = new CustomerClient(auth);
        this.transfers = new TransferClient(auth);
        this.subscriptions = new SubscriptionClient(auth);
        this.addons = new AddonClient(auth);
        this.plans = new PlanClient(auth);
        this.settlement = new SettlementClient(auth);
        this.qrCode = new QrCodeClient(auth);
        this.paymentLink = new PaymentLinkClient(auth);
        this.items = new ItemClient(auth);
        this.fundAccount = new FundAccountClient(auth);
        this.virtualAccounts = new VirtualAccountClient(auth);
    }

    public RazorpayClient addHeaders(Map<String, String> headers) {
        ApiUtils.addHeaders(headers);
        return this;
    }
}

