/*
 * Decompiled with CFR 0.152.
 */
package com.razorpay;

import com.razorpay.ApiUtils;
import com.razorpay.CardClient;
import com.razorpay.CustomerClient;
import com.razorpay.InvoiceClient;
import com.razorpay.OrderClient;
import com.razorpay.PaymentClient;
import com.razorpay.RazorpayException;
import com.razorpay.RefundClient;
import com.razorpay.Utils;
import java.util.Map;
import okhttp3.Credentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RazorpayClient {
    public PaymentClient Payments;
    public RefundClient Refunds;
    public OrderClient Orders;
    public InvoiceClient Invoices;
    public CardClient Cards;
    public CustomerClient Customers;
    public Utils Utility;

    public RazorpayClient(String key, String secret) throws RazorpayException {
        this(key, secret, false);
    }

    public RazorpayClient(String key, String secret, Boolean enableLogging) throws RazorpayException {
        ApiUtils.createHttpClientInstance(enableLogging);
        String auth = Credentials.basic((String)key, (String)secret);
        this.Payments = new PaymentClient(auth);
        this.Refunds = new RefundClient(auth);
        this.Orders = new OrderClient(auth);
        this.Invoices = new InvoiceClient(auth);
        this.Cards = new CardClient(auth);
        this.Customers = new CustomerClient(auth);
        this.Utility = new Utils(key, secret);
    }

    public RazorpayClient addHeaders(Map<String, String> headers) {
        ApiUtils.addHeaders(headers);
        return this;
    }
}

