/*
 * Decompiled with CFR 0.152.
 */
package com.rapid7.log4j2;

import com.rapid7.net.AsyncLogger;
import com.rapid7.net.LoggerConfiguration;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;

public class LogentriesManager
extends AbstractManager {
    private static LogentriesManagerFactory FACTORY = new LogentriesManagerFactory();
    private final AsyncLogger asyncLogger;

    protected LogentriesManager(LoggerContext loggerContext, String name, LoggerConfiguration data) {
        super(loggerContext, name);
        this.asyncLogger = new AsyncLogger(data);
        LOGGER.debug("AsyncLogger created.");
    }

    static LogentriesManager getManager(String name, LoggerConfiguration data) {
        return (LogentriesManager)LogentriesManager.getManager((String)name, (ManagerFactory)FACTORY, (Object)data);
    }

    protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
        this.asyncLogger.close();
        LOGGER.debug("AsyncLogger closed.");
        return true;
    }

    public void writeLine(String line) {
        this.asyncLogger.addLineToQueue(line);
    }

    static class LogentriesManagerFactory
    implements ManagerFactory<LogentriesManager, LoggerConfiguration> {
        LogentriesManagerFactory() {
        }

        public LogentriesManager createManager(String name, LoggerConfiguration data) {
            return new LogentriesManager(new LoggerContext(name), name, data);
        }
    }
}

