/*
 * Decompiled with CFR 0.152.
 */
package com.race604.flyrefresh.internal;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.view.animation.Interpolator;

public class MountainSceneDrawable
extends Drawable {
    private static final int COLOR_BACKGROUND = Color.parseColor((String)"#7ECEC9");
    private static final int COLOR_MOUNTAIN_1 = Color.parseColor((String)"#86DAD7");
    private static final int COLOR_MOUNTAIN_2 = Color.parseColor((String)"#3C929C");
    private static final int COLOR_MOUNTAIN_3 = Color.parseColor((String)"#3E5F73");
    private static final int COLOR_TREE_1_BRANCH = Color.parseColor((String)"#1F7177");
    private static final int COLOR_TREE_1_BTRUNK = Color.parseColor((String)"#0C3E48");
    private static final int COLOR_TREE_2_BRANCH = Color.parseColor((String)"#34888F");
    private static final int COLOR_TREE_2_BTRUNK = Color.parseColor((String)"#1B6169");
    private static final int COLOR_TREE_3_BRANCH = Color.parseColor((String)"#57B1AE");
    private static final int COLOR_TREE_3_BTRUNK = Color.parseColor((String)"#62A4AD");
    private static final int WIDTH = 240;
    private static final int HEIGHT = 180;
    private static final int TREE_WIDTH = 100;
    private static final int TREE_HEIGHT = 200;
    private Paint mMountPaint = new Paint();
    private Paint mTrunkPaint = new Paint();
    private Paint mBranchPaint = new Paint();
    private Paint mBoarderPaint = new Paint();
    private Path mMount1 = new Path();
    private Path mMount2 = new Path();
    private Path mMount3 = new Path();
    private Path mTrunk = new Path();
    private Path mBranch = new Path();
    private float mScale = 5.0f;
    private float mMoveFactor = 0.0f;
    private float mBounceMax = 1.0f;
    private float mTreeBendFactor = Float.MAX_VALUE;
    private Matrix mTransMatrix = new Matrix();

    public MountainSceneDrawable() {
        this.mMountPaint.setAntiAlias(true);
        this.mMountPaint.setStyle(Paint.Style.FILL);
        this.mTrunkPaint.setAntiAlias(true);
        this.mBranchPaint.setAntiAlias(true);
        this.mBoarderPaint.setAntiAlias(true);
        this.mBoarderPaint.setStyle(Paint.Style.STROKE);
        this.mBoarderPaint.setStrokeWidth(2.0f);
        this.mBoarderPaint.setStrokeJoin(Paint.Join.ROUND);
        this.updateMountainPath(this.mMoveFactor);
        this.updateTreePath(0.0f);
    }

    private void updateMountainPath(float factor) {
        this.mTransMatrix.reset();
        this.mTransMatrix.setScale(this.mScale, this.mScale);
        int offset1 = (int)(10.0f * factor);
        this.mMount1.reset();
        this.mMount1.moveTo(0.0f, (float)(95 + offset1));
        this.mMount1.lineTo(55.0f, (float)(74 + offset1));
        this.mMount1.lineTo(146.0f, (float)(104 + offset1));
        this.mMount1.lineTo(227.0f, (float)(72 + offset1));
        this.mMount1.lineTo(240.0f, (float)(80 + offset1));
        this.mMount1.lineTo(240.0f, 180.0f);
        this.mMount1.lineTo(0.0f, 180.0f);
        this.mMount1.close();
        this.mMount1.transform(this.mTransMatrix);
        int offset2 = (int)(20.0f * factor);
        this.mMount2.reset();
        this.mMount2.moveTo(0.0f, (float)(103 + offset2));
        this.mMount2.lineTo(67.0f, (float)(90 + offset2));
        this.mMount2.lineTo(165.0f, (float)(115 + offset2));
        this.mMount2.lineTo(221.0f, (float)(87 + offset2));
        this.mMount2.lineTo(240.0f, (float)(100 + offset2));
        this.mMount2.lineTo(240.0f, 180.0f);
        this.mMount2.lineTo(0.0f, 180.0f);
        this.mMount2.close();
        this.mMount2.transform(this.mTransMatrix);
        int offset3 = (int)(30.0f * factor);
        this.mMount3.reset();
        this.mMount3.moveTo(0.0f, (float)(114 + offset3));
        this.mMount3.cubicTo(30.0f, (float)(106 + offset3), 196.0f, (float)(97 + offset3), 240.0f, (float)(104 + offset3));
        this.mMount3.lineTo(240.0f, 180.0f);
        this.mMount3.lineTo(0.0f, 180.0f);
        this.mMount3.close();
        this.mMount3.transform(this.mTransMatrix);
    }

    private void updateTreePath(float factor) {
        float f;
        int i;
        int i2;
        if (factor == this.mTreeBendFactor) {
            return;
        }
        Interpolator interpolator = PathInterpolatorCompat.create((float)0.8f, (float)(-0.5f * factor));
        float width = 100.0f;
        float height = 200.0f;
        float maxMove = 30.000002f * factor;
        float trunkSize = 5.0f;
        float branchSize = 20.0f;
        float x0 = 50.0f;
        float y0 = 200.0f;
        int N = 25;
        float dp = 0.04f;
        float dy = -8.0f;
        float y = 200.0f;
        float p = 0.0f;
        float[] xx = new float[26];
        float[] yy = new float[26];
        for (int i3 = 0; i3 <= 25; ++i3) {
            xx[i3] = interpolator.getInterpolation(p) * maxMove + 50.0f;
            yy[i3] = y;
            y += -8.0f;
            p += 0.04f;
        }
        this.mTrunk.reset();
        this.mTrunk.moveTo(45.0f, 200.0f);
        int max = 17;
        int max1 = (int)((float)max * 0.5f);
        float diff = max - max1;
        for (i2 = 0; i2 < max; ++i2) {
            if (i2 < max1) {
                this.mTrunk.lineTo(xx[i2] - 5.0f, yy[i2]);
                continue;
            }
            this.mTrunk.lineTo(xx[i2] - 5.0f * (float)(max - i2) / diff, yy[i2]);
        }
        for (i2 = max - 1; i2 >= 0; --i2) {
            if (i2 < max1) {
                this.mTrunk.lineTo(xx[i2] + 5.0f, yy[i2]);
                continue;
            }
            this.mTrunk.lineTo(xx[i2] + 5.0f * (float)(max - i2) / diff, yy[i2]);
        }
        this.mTrunk.close();
        this.mBranch.reset();
        int min = 10;
        diff = 25 - min;
        this.mBranch.moveTo(xx[min] - 20.0f, yy[min]);
        this.mBranch.addArc(new RectF(xx[min] - 20.0f, yy[min] - 20.0f, xx[min] + 20.0f, yy[min] + 20.0f), 0.0f, 180.0f);
        for (i = min; i <= 25; ++i) {
            f = (float)(i - min) / diff;
            this.mBranch.lineTo(xx[i] - 20.0f + f * f * 20.0f, yy[i]);
        }
        for (i = 25; i >= min; --i) {
            f = (float)(i - min) / diff;
            this.mBranch.lineTo(xx[i] + 20.0f - f * f * 20.0f, yy[i]);
        }
    }

    public void setMoveFactor(int state, float factor) {
        float bendFactor;
        if (state == 3) {
            if (factor < this.mBounceMax) {
                this.mBounceMax = factor;
            }
            bendFactor = factor;
        } else {
            this.mBounceMax = factor;
            bendFactor = Math.max(0.0f, factor);
        }
        this.mMoveFactor = Math.max(0.0f, this.mBounceMax);
        this.updateMountainPath(this.mMoveFactor);
        this.updateTreePath(bendFactor);
    }

    private void drawTree(Canvas canvas, float scale, float baseX, float baseY, int colorTrunk, int colorBranch) {
        canvas.save();
        float dx = baseX - 100.0f * scale / 2.0f;
        float dy = baseY - 200.0f * scale;
        canvas.translate(dx, dy);
        canvas.scale(scale, scale);
        this.mBranchPaint.setColor(colorBranch);
        canvas.drawPath(this.mBranch, this.mBranchPaint);
        this.mTrunkPaint.setColor(colorTrunk);
        canvas.drawPath(this.mTrunk, this.mTrunkPaint);
        this.mBoarderPaint.setColor(colorTrunk);
        canvas.drawPath(this.mBranch, this.mBoarderPaint);
        canvas.restore();
    }

    public void draw(Canvas canvas) {
        canvas.drawColor(COLOR_BACKGROUND);
        this.mMountPaint.setColor(COLOR_MOUNTAIN_1);
        canvas.drawPath(this.mMount1, this.mMountPaint);
        canvas.save();
        canvas.scale(-1.0f, 1.0f, (float)(this.getIntrinsicWidth() / 2), 0.0f);
        this.drawTree(canvas, 0.12f * this.mScale, 180.0f * this.mScale, (93.0f + 20.0f * this.mMoveFactor) * this.mScale, COLOR_TREE_3_BTRUNK, COLOR_TREE_3_BRANCH);
        this.drawTree(canvas, 0.1f * this.mScale, 200.0f * this.mScale, (96.0f + 20.0f * this.mMoveFactor) * this.mScale, COLOR_TREE_3_BTRUNK, COLOR_TREE_3_BRANCH);
        canvas.restore();
        this.mMountPaint.setColor(COLOR_MOUNTAIN_2);
        canvas.drawPath(this.mMount2, this.mMountPaint);
        this.drawTree(canvas, 0.2f * this.mScale, 160.0f * this.mScale, (105.0f + 30.0f * this.mMoveFactor) * this.mScale, COLOR_TREE_1_BTRUNK, COLOR_TREE_1_BRANCH);
        this.drawTree(canvas, 0.14f * this.mScale, 180.0f * this.mScale, (105.0f + 30.0f * this.mMoveFactor) * this.mScale, COLOR_TREE_2_BTRUNK, COLOR_TREE_2_BRANCH);
        this.drawTree(canvas, 0.16f * this.mScale, 140.0f * this.mScale, (105.0f + 30.0f * this.mMoveFactor) * this.mScale, COLOR_TREE_2_BTRUNK, COLOR_TREE_2_BRANCH);
        this.mMountPaint.setColor(COLOR_MOUNTAIN_3);
        canvas.drawPath(this.mMount3, this.mMountPaint);
    }

    public void setAlpha(int alpha) {
        this.mMountPaint.setAlpha(alpha);
        this.mTrunkPaint.setAlpha(alpha);
        this.mBranchPaint.setAlpha(alpha);
        this.mBoarderPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mMountPaint.setColorFilter(cf);
        this.mTrunkPaint.setColorFilter(cf);
        this.mBranchPaint.setColorFilter(cf);
        this.mBoarderPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -1;
    }

    public int getIntrinsicHeight() {
        return (int)(180.0f * this.mScale);
    }

    public int getIntrinsicWidth() {
        return (int)(240.0f * this.mScale);
    }
}

