/*
 * Decompiled with CFR 0.152.
 */
package com.race604.flyrefresh;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.support.annotation.Nullable;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ScrollerCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import com.race604.flyrefresh.HeaderController;
import com.race604.flyrefresh.IPullHeader;
import com.race604.flyrefresh.R;
import com.race604.flyrefresh.internal.ElasticOutInterpolator;
import com.race604.flyrefresh.internal.SimpleAnimatorListener;
import com.race604.utils.UIUtils;

public class PullHeaderLayout
extends ViewGroup
implements NestedScrollingParent,
NestedScrollingChild {
    private static final String TAG = PullHeaderLayout.class.getCanonicalName();
    private static final boolean D = true;
    public static final int STATE_IDLE = 0;
    public static final int STATE_DRAGE = 1;
    public static final int STATE_FLING = 2;
    public static final int STATE_BOUNCE = 3;
    static final int ACTION_BUTTON_CENTER = UIUtils.dpToPx(40);
    static final int ACTION_ICON_SIZE = UIUtils.dpToPx(32);
    private static final int DEFAULT_EXPAND = UIUtils.dpToPx(300);
    private static final int DEFAULT_HEIGHT = UIUtils.dpToPx(240);
    private static final int DEFAULT_SHRINK = UIUtils.dpToPx(48);
    private int mHeaderId = 0;
    private int mContentId = 0;
    private Drawable mActionDrawable;
    private FloatingActionButton mActionView;
    private ImageView mFlyView;
    private View mHeaderView;
    private IPullHeader mPullHeaderView;
    protected View mContent;
    protected HeaderController mHeaderController;
    private VelocityTracker mVelocityTracker;
    private ValueAnimator mBounceAnim;
    private int mPullState = 0;
    private static final int INVALID_POINTER = -1;
    private int mActivePointerId = -1;
    private boolean mIsBeingDragged = false;
    private int mLastMotionY = 0;
    private int mTouchSlop;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mNestedYOffset;
    private final int[] mScrollOffset = new int[2];
    private final int[] mScrollConsumed = new int[2];
    private final NestedScrollingParentHelper mParentHelper;
    private final NestedScrollingChildHelper mChildHelper;
    private ScrollerCompat mScroller;
    private OnPullListener mPullListener;

    public PullHeaderLayout(Context context) {
        this(context, null);
    }

    public PullHeaderLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PullHeaderLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        int headerHeight = DEFAULT_HEIGHT;
        int headerExpandHeight = DEFAULT_EXPAND;
        int headerShrinkHeight = DEFAULT_SHRINK;
        if (attrs != null) {
            TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.PullHeaderLayout);
            headerHeight = arr.getDimensionPixelOffset(R.styleable.PullHeaderLayout_phl_header_height, DEFAULT_HEIGHT);
            headerExpandHeight = arr.getDimensionPixelOffset(R.styleable.PullHeaderLayout_phl_header_expand_height, DEFAULT_EXPAND);
            headerShrinkHeight = arr.getDimensionPixelOffset(R.styleable.PullHeaderLayout_phl_header_shrink_height, DEFAULT_SHRINK);
            this.mHeaderId = arr.getResourceId(R.styleable.PullHeaderLayout_phl_header, this.mHeaderId);
            this.mContentId = arr.getResourceId(R.styleable.PullHeaderLayout_phl_content, this.mContentId);
            this.mActionDrawable = arr.getDrawable(R.styleable.PullHeaderLayout_phl_action);
            arr.recycle();
        }
        this.mHeaderController = new HeaderController(headerHeight, headerExpandHeight, headerShrinkHeight);
        ViewConfiguration conf = ViewConfiguration.get((Context)this.getContext());
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mChildHelper = new NestedScrollingChildHelper((View)this);
        this.setNestedScrollingEnabled(true);
        this.init();
    }

    private void init() {
        this.mScroller = ScrollerCompat.create((Context)this.getContext());
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.startNestedScroll(2);
    }

    public void onStopNestedScroll(View target) {
        this.stopNestedScroll();
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        int myConsumed = this.moveBy(dyUnconsumed);
        int myUnconsumed = dyUnconsumed - myConsumed;
        this.dispatchNestedScroll(0, myConsumed, 0, myUnconsumed, null);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        if (dy > 0 && this.mHeaderController.canScrollUp()) {
            int delta = this.moveBy(dy);
            consumed[0] = 0;
            consumed[1] = delta;
        }
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (!consumed) {
            this.flingWithNestedDispatch((int)velocityY);
            return true;
        }
        return false;
    }

    private boolean flingWithNestedDispatch(int velocityY) {
        boolean canFling;
        boolean bl = canFling = this.mHeaderController.canScrollUp() && velocityY > 0 || this.mHeaderController.canScrollDown() && velocityY < 0;
        if (!this.dispatchNestedPreFling(0.0f, velocityY)) {
            this.dispatchNestedFling(0.0f, velocityY, canFling);
            if (canFling) {
                this.fling(velocityY);
            }
        }
        return canFling;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.flingWithNestedDispatch((int)velocityY);
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    public void setHeaderSize(int height, int maxHeight, int minHeight) {
        this.mHeaderController.setSize(height, maxHeight, minHeight);
        if (this.isLayoutRequested()) {
            this.requestLayout();
        }
    }

    public void setOnPullListener(OnPullListener listener) {
        this.mPullListener = listener;
    }

    public void setActionDrawable(Drawable actionDrawable) {
        this.mActionDrawable = actionDrawable;
        if (this.mActionDrawable != null) {
            if (this.mActionView == null) {
                int bgColor = UIUtils.getThemeColorFromAttrOrRes(this.getContext(), R.attr.colorAccent, R.color.accent);
                int pressedColor = UIUtils.darkerColor(bgColor, 0.8f);
                ShapeDrawable bgDrawable = new ShapeDrawable((Shape)new OvalShape());
                bgDrawable.getPaint().setColor(bgColor);
                this.mActionView = new FloatingActionButton(this.getContext());
                this.mActionView.setRippleColor(pressedColor);
                this.mActionView.setBackgroundDrawable((Drawable)bgDrawable);
                this.addView((View)this.mActionView, (ViewGroup.LayoutParams)new LayoutParams(-2, -2));
            }
            if (this.mFlyView == null) {
                this.mFlyView = new ImageView(this.getContext());
                this.mFlyView.setScaleType(ImageView.ScaleType.FIT_XY);
                this.addView((View)this.mFlyView, (ViewGroup.LayoutParams)new LayoutParams(ACTION_ICON_SIZE, ACTION_ICON_SIZE));
                this.mFlyView.bringToFront();
                float elevation = ViewCompat.getElevation((View)this.mActionView);
                ViewCompat.setElevation((View)this.mFlyView, (float)(elevation + 1.0f));
            }
            this.mFlyView.setImageDrawable(this.mActionDrawable);
        } else if (this.mActionView != null) {
            this.removeView((View)this.mActionView);
            this.removeView((View)this.mFlyView);
            this.mActionView = null;
            this.mFlyView = null;
        }
    }

    @Nullable
    public View getIconView() {
        return this.mFlyView;
    }

    @Nullable
    public FloatingActionButton getHeaderActionButton() {
        return this.mActionView;
    }

    public void setHeaderView(View headerView, LayoutParams lp) {
        if (this.mHeaderView != null) {
            this.removeView(this.mHeaderView);
            this.mPullHeaderView = null;
        }
        this.addView(headerView, 0, (ViewGroup.LayoutParams)lp);
        this.mHeaderView = headerView;
        if (this.mHeaderView instanceof IPullHeader) {
            this.mPullHeaderView = (IPullHeader)this.mHeaderView;
        }
    }

    protected void onFinishInflate() {
        int childCount = this.getChildCount();
        if (childCount > 2) {
            throw new IllegalStateException("FlyRefreshLayout only can host 2 elements");
        }
        if (childCount == 2) {
            if (this.mHeaderId != 0 && this.mHeaderView == null) {
                this.mHeaderView = this.findViewById(this.mHeaderId);
            }
            if (this.mContentId != 0 && this.mContent == null) {
                this.mContent = this.findViewById(this.mContentId);
            }
            if (this.mContent == null || this.mHeaderView == null) {
                View child1 = this.getChildAt(0);
                View child2 = this.getChildAt(1);
                if (child1 instanceof IPullHeader) {
                    this.mHeaderView = child1;
                    this.mContent = child2;
                    this.mPullHeaderView = (IPullHeader)this.mHeaderView;
                } else if (child2 instanceof IPullHeader) {
                    this.mHeaderView = child2;
                    this.mContent = child1;
                    this.mPullHeaderView = (IPullHeader)this.mHeaderView;
                } else if (this.mContent == null && this.mHeaderView == null) {
                    this.mHeaderView = child1;
                    this.mContent = child2;
                } else if (this.mHeaderView == null) {
                    this.mHeaderView = this.mContent == child1 ? child2 : child1;
                } else {
                    this.mContent = this.mHeaderView == child1 ? child2 : child1;
                }
            }
        } else if (childCount == 1) {
            this.mContent = this.getChildAt(0);
        }
        this.setActionDrawable(this.mActionDrawable);
        super.onFinishInflate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mHeaderView != null) {
            this.measureChildWithMargins(this.mHeaderView, widthMeasureSpec, 0, heightMeasureSpec, 0);
        }
        if (this.mContent != null) {
            this.measureChildWithMargins(this.mContent, widthMeasureSpec, 0, heightMeasureSpec, this.mHeaderController.getMinHeight());
        }
        if (this.mActionView != null) {
            this.measureChild((View)this.mActionView, widthMeasureSpec, heightMeasureSpec);
            this.measureChild((View)this.mFlyView, widthMeasureSpec, heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutChildren();
    }

    private void layoutChildren() {
        int bottom;
        int right;
        int top;
        int left;
        ViewGroup.MarginLayoutParams lp;
        int offsetY = this.mHeaderController.getCurPosition();
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        if (this.mHeaderView != null) {
            lp = (ViewGroup.MarginLayoutParams)this.mHeaderView.getLayoutParams();
            left = paddingLeft + lp.leftMargin;
            top = paddingTop + lp.topMargin;
            right = left + this.mHeaderView.getMeasuredWidth();
            bottom = top + this.mHeaderView.getMeasuredHeight();
            this.mHeaderView.layout(left, top, right, bottom);
        }
        if (this.mContent != null) {
            lp = (ViewGroup.MarginLayoutParams)this.mContent.getLayoutParams();
            left = paddingLeft + lp.leftMargin;
            top = paddingTop + lp.topMargin + offsetY;
            right = left + this.mContent.getMeasuredWidth();
            bottom = top + this.mContent.getMeasuredHeight();
            this.mContent.layout(left, top, right, bottom);
        }
        if (this.mActionView != null) {
            int center = ACTION_BUTTON_CENTER;
            int halfWidth = (this.mActionView.getMeasuredWidth() + 1) / 2;
            int halfHeight = (this.mActionView.getMeasuredHeight() + 1) / 2;
            this.mActionView.layout(center - halfWidth, offsetY - halfHeight, center + halfWidth, offsetY + halfHeight);
            halfWidth = (this.mFlyView.getMeasuredWidth() + 1) / 2;
            halfHeight = (this.mFlyView.getMeasuredHeight() + 1) / 2;
            this.mFlyView.layout(center - halfWidth, offsetY - halfHeight, center + halfWidth, offsetY + halfHeight);
        }
    }

    private void obtainVelocityTracker(MotionEvent event) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void releaseVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionY = (int)MotionEventCompat.getY((MotionEvent)ev, (int)newPointerIndex);
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.releaseVelocityTracker();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 2 && this.mIsBeingDragged) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        switch (action & 0xFF) {
            case 2: {
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)activePointerId);
                if (pointerIndex == -1) {
                    Log.e((String)TAG, (String)("Invalid pointerId=" + activePointerId + " in onInterceptTouchEvent"));
                    break;
                }
                int y = (int)MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                int yDiff = Math.abs(y - this.mLastMotionY);
                if (yDiff <= this.mTouchSlop || (this.getNestedScrollAxes() & 2) != 0) break;
                this.mIsBeingDragged = true;
                this.mLastMotionY = y;
                this.obtainVelocityTracker(ev);
                this.mNestedYOffset = 0;
                ViewParent parent = this.getParent();
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 0: {
                int y;
                this.mLastMotionY = y = (int)ev.getY();
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                this.mIsBeingDragged = !this.mScroller.isFinished();
                this.startNestedScroll(2);
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                this.endDrag();
                this.stopNestedScroll();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return this.mIsBeingDragged;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int actionMasked = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (actionMasked == 1 || actionMasked == 3) {
            this.tryBounceBack();
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        MotionEvent vtev = MotionEvent.obtain((MotionEvent)ev);
        int actionMasked = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (actionMasked == 0) {
            this.mNestedYOffset = 0;
        }
        vtev.offsetLocation(0.0f, (float)this.mNestedYOffset);
        switch (actionMasked) {
            case 0: {
                ViewParent parent;
                this.mIsBeingDragged = !this.mScroller.isFinished();
                if (this.mIsBeingDragged && (parent = this.getParent()) != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mLastMotionY = (int)ev.getY();
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                this.startNestedScroll(2);
                break;
            }
            case 2: {
                int unconsumedY;
                int activePointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                if (activePointerIndex == -1) {
                    Log.e((String)TAG, (String)("Invalid pointerId=" + this.mActivePointerId + " in onTouchEvent"));
                    break;
                }
                int y = (int)MotionEventCompat.getY((MotionEvent)ev, (int)activePointerIndex);
                int deltaY = this.mLastMotionY - y;
                if (this.dispatchNestedPreScroll(0, deltaY, this.mScrollConsumed, this.mScrollOffset)) {
                    deltaY -= this.mScrollConsumed[1];
                    vtev.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                }
                if (!this.mIsBeingDragged && Math.abs(deltaY) > this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mIsBeingDragged = true;
                    deltaY = deltaY > 0 ? (deltaY -= this.mTouchSlop) : (deltaY += this.mTouchSlop);
                }
                if (!this.mIsBeingDragged) break;
                this.mLastMotionY = y - this.mScrollOffset[1];
                int scrolledDeltaY = this.moveBy(deltaY);
                if (!this.dispatchNestedScroll(0, scrolledDeltaY, 0, unconsumedY = deltaY - scrolledDeltaY, this.mScrollOffset)) break;
                this.mLastMotionY -= this.mScrollOffset[1];
                vtev.offsetLocation(0.0f, (float)this.mScrollOffset[1]);
                this.mNestedYOffset += this.mScrollOffset[1];
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int initialVelocity = (int)VelocityTrackerCompat.getYVelocity((VelocityTracker)velocityTracker, (int)this.mActivePointerId);
                if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                    this.flingWithNestedDispatch(-initialVelocity);
                }
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged || this.getChildCount() <= 0) break;
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 5: {
                int index = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mLastMotionY = (int)MotionEventCompat.getY((MotionEvent)ev, (int)index);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                this.mLastMotionY = (int)MotionEventCompat.getY((MotionEvent)ev, (int)MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId));
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    protected void onMoveHeader(int state, float progress) {
    }

    public void fling(int velocityY) {
        this.mPullState = 2;
        this.mScroller.abortAnimation();
        this.mScroller.fling(0, this.mHeaderController.getScroll(), 0, velocityY, 0, 0, this.mHeaderController.getMinScroll(), this.mHeaderController.getMaxScroll(), 0, 0);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    private int moveBy(float deltaY) {
        int oldScroll = this.mHeaderController.getScroll();
        int consumed = this.mHeaderController.move(deltaY);
        int delta = this.mHeaderController.getScroll() - oldScroll;
        if (delta == 0) {
            return 0;
        }
        if (this.mPullState != 1) {
            this.mPullState = 1;
        }
        if (this.mContent != null) {
            this.mContent.offsetTopAndBottom(-delta);
        }
        if (this.mActionView != null) {
            this.mActionView.offsetTopAndBottom(-delta);
            this.mFlyView.offsetTopAndBottom(-delta);
            float percentage = this.mHeaderController.getMovePercentage();
            this.onMoveHeader(this.mPullState, percentage);
            if (this.mPullHeaderView != null) {
                this.mPullHeaderView.onPullProgress(this, this.mPullState, percentage);
            }
            if (this.mPullListener != null) {
                this.mPullListener.onPullProgress(this, this.mPullState, percentage);
            }
        }
        return consumed;
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int y;
            int oldY = this.mHeaderController.getScroll();
            if (oldY != (y = this.mScroller.getCurrY())) {
                this.moveBy(y - oldY);
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else {
            this.tryBounceBack();
        }
    }

    private void tryBounceBack() {
        if (this.mHeaderController.isOverHeight()) {
            this.mBounceAnim = ObjectAnimator.ofFloat((float[])new float[]{this.mHeaderController.getScroll(), 0.0f});
            this.mBounceAnim.setInterpolator((TimeInterpolator)new ElasticOutInterpolator());
            this.mBounceAnim.setDuration(500L);
            this.mBounceAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float deltaY = ((Float)animation.getAnimatedValue()).floatValue() - (float)PullHeaderLayout.this.mHeaderController.getScroll();
                    PullHeaderLayout.this.moveBy(deltaY);
                }
            });
            this.mBounceAnim.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    PullHeaderLayout.this.mPullState = 0;
                }
            });
            this.mBounceAnim.start();
            this.mPullState = 3;
            if (this.mHeaderController.needSendRefresh()) {
                this.startRefresh();
            }
        } else {
            this.mPullState = 0;
        }
    }

    public void startRefresh() {
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public static interface OnPullListener {
        public void onPullProgress(PullHeaderLayout var1, int var2, float var3);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

