/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.rabbitmq.http.client.HttpLayer;
import com.rabbitmq.http.client.Utils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class ClientParameters {
    private URL url;
    private String username;
    private String password;
    private HttpLayer.HttpLayerFactory httpLayerFactory;

    public ClientParameters url(URL url) {
        this.url = url;
        return this;
    }

    public ClientParameters url(String url) throws MalformedURLException {
        try {
            this.url = new URI(url).toURL();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URL is malformed");
        }
        if (this.url.getUserInfo() != null) {
            try {
                this.url = new URI(Utils.urlWithoutCredentials(url)).toURL();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("URL is malformed");
            }
            String[] usernamePassword = Utils.extractUsernamePassword(url);
            this.username = usernamePassword[0];
            this.password = usernamePassword[1];
        }
        return this;
    }

    public ClientParameters username(String username) {
        this.username = username;
        return this;
    }

    public ClientParameters password(String password) {
        this.password = password;
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public HttpLayer.HttpLayerFactory getHttpLayerFactory() {
        return this.httpLayerFactory;
    }

    public ClientParameters httpLayerFactory(HttpLayer.HttpLayerFactory httpLayerFactory) {
        this.httpLayerFactory = httpLayerFactory;
        return this;
    }

    void validate() {
        Utils.notNull(this.url, "URL is required; it must not be null");
        Utils.notNull(this.username, "username is required; it must not be null");
        Utils.notNull(this.password, "password is required; it must not be null");
    }
}

