/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.rabbitmq.http.client.GetAckMode;
import com.rabbitmq.http.client.GetEncoding;
import com.rabbitmq.http.client.PercentEncoder;
import com.rabbitmq.http.client.domain.OutboundMessage;
import com.rabbitmq.http.client.domain.QueryParameters;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class Utils {
    private Utils() {
    }

    static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    static Map<String, Object> bodyForPublish(String routingKey, OutboundMessage outboundMessage) {
        if (routingKey == null) {
            throw new IllegalArgumentException("routing key cannot be null");
        }
        if (outboundMessage == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
        if (outboundMessage.getPayload() == null) {
            throw new IllegalArgumentException("message payload cannot be null");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("routing_key", routingKey);
        body.put("properties", outboundMessage.getProperties() == null ? Collections.EMPTY_MAP : outboundMessage.getProperties());
        body.put("payload", outboundMessage.getPayload());
        body.put("payload_encoding", outboundMessage.getPayloadEncoding());
        return body;
    }

    static Map<String, Object> bodyForGet(int count, GetAckMode ackMode, GetEncoding encoding, int truncate) {
        if (count <= 0) {
            throw new IllegalArgumentException("count must be greater than 0");
        }
        if (ackMode == null) {
            throw new IllegalArgumentException("acknowledgment mode cannot be null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding cannot be null");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("count", count);
        body.put("ackmode", ackMode.ackMode);
        body.put("encoding", encoding.encoding);
        if (truncate >= 0) {
            body.put("truncate", truncate);
        }
        return body;
    }

    static String[] extractUsernamePassword(String url) {
        String userInfo = null;
        try {
            userInfo = new URI(url).toURL().getUserInfo();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Malformed URL", e);
        }
        if (userInfo == null) {
            throw new IllegalArgumentException("Could not extract password from URL. URL should be like 'https://guest:guest@localhost:15672/api/'");
        }
        String[] usernamePassword = userInfo.split(":");
        if (usernamePassword.length != 2) {
            throw new IllegalArgumentException("Could not extract password from URL. URL should be like 'https://guest:guest@localhost:15672/api/'");
        }
        return new String[]{Utils.decode(usernamePassword[0]), Utils.decode(usernamePassword[1])};
    }

    static URI rootUri(URL url) throws URISyntaxException {
        if (url.toString().endsWith("/")) {
            return url.toURI();
        }
        return new URI(url + "/");
    }

    static String decode(String potentiallyEncodedString) {
        if (potentiallyEncodedString != null && !potentiallyEncodedString.isEmpty()) {
            return URLDecoder.decode(potentiallyEncodedString, StandardCharsets.UTF_8);
        }
        return potentiallyEncodedString;
    }

    static String urlWithoutCredentials(String url) {
        URL url1 = null;
        try {
            url1 = new URI(url).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("URL is malformed");
        }
        return url.replace(url1.getUserInfo() + "@", "");
    }

    static String base64(String in) {
        return Base64.getEncoder().encodeToString(in.getBytes(StandardCharsets.UTF_8));
    }

    static class URIBuilder {
        URI rootURI;
        StringBuilder sb = new StringBuilder();
        QueryParameters queryParameters;
        Map<String, String> mapOfParameters;

        public URIBuilder(URI rootURI) {
            this.rootURI = rootURI;
        }

        URIBuilder withEncodedPath(String path) {
            if (this.sb.length() > 0 && this.sb.charAt(this.sb.length() - 1) != '/') {
                this.sb.append("/");
            }
            this.sb.append(path);
            return this;
        }

        URIBuilder withPath(String path) {
            if (this.sb.length() > 0 && this.sb.charAt(this.sb.length() - 1) != '/') {
                this.sb.append("/");
            }
            this.sb.append(PercentEncoder.encodePathSegment(path));
            return this;
        }

        URIBuilder withQueryParameters(QueryParameters queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        URIBuilder withQueryParameters(Map<String, String> mapOfParameters) {
            this.mapOfParameters = mapOfParameters;
            return this;
        }

        URI get() {
            try {
                if (this.queryParameters != null && !this.queryParameters.isEmpty() || this.mapOfParameters != null && !this.mapOfParameters.isEmpty()) {
                    this.sb.append("?");
                }
                if (this.queryParameters != null && !this.queryParameters.isEmpty()) {
                    for (Map.Entry<String, String> param : this.queryParameters.parameters().entrySet()) {
                        this.sb.append(param.getKey()).append("=").append(PercentEncoder.encodeParameter(param.getValue())).append("&");
                    }
                    this.sb.deleteCharAt(this.sb.length() - 1);
                }
                if (this.mapOfParameters != null && !this.mapOfParameters.isEmpty()) {
                    for (Map.Entry<String, String> param : this.mapOfParameters.entrySet()) {
                        this.sb.append(param.getKey()).append("=").append(PercentEncoder.encodeParameter(param.getValue())).append("&");
                    }
                    this.sb.deleteCharAt(this.sb.length() - 1);
                }
                Iterator<Map.Entry<String, String>> iterator = this.rootURI.resolve(this.sb.toString());
                return iterator;
            }
            finally {
                this.sb.setLength(0);
            }
        }

        public URIBuilder withPathSeparator() {
            this.sb.append("/");
            return this;
        }
    }
}

