/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.rabbitmq.http.client.HttpLayer;
import com.rabbitmq.http.client.RestTemplateConfigurator;
import com.rabbitmq.http.client.Utils;
import java.net.MalformedURLException;
import java.net.URL;

public class ClientParameters {
    private URL url;
    private String username;
    private String password;
    private RestTemplateConfigurator restTemplateConfigurator;
    private HttpLayer.HttpLayerFactory httpLayerFactory;

    public ClientParameters url(URL url) {
        this.url = url;
        return this;
    }

    public ClientParameters url(String url) throws MalformedURLException {
        this.url = new URL(url);
        if (this.url.getUserInfo() != null) {
            this.url = new URL(Utils.urlWithoutCredentials(url));
            String[] usernamePassword = Utils.extractUsernamePassword(url);
            this.username = usernamePassword[0];
            this.password = usernamePassword[1];
        }
        return this;
    }

    public ClientParameters username(String username) {
        this.username = username;
        return this;
    }

    public ClientParameters password(String password) {
        this.password = password;
        return this;
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    public ClientParameters restTemplateConfigurator(RestTemplateConfigurator restTemplateConfigurator) {
        this.restTemplateConfigurator = restTemplateConfigurator;
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    public RestTemplateConfigurator getRestTemplateConfigurator() {
        return this.restTemplateConfigurator;
    }

    public HttpLayer.HttpLayerFactory getHttpLayerFactory() {
        return this.httpLayerFactory;
    }

    public ClientParameters httpLayerFactory(HttpLayer.HttpLayerFactory httpLayerFactory) {
        this.httpLayerFactory = httpLayerFactory;
        return this;
    }

    void validate() {
        Utils.notNull(this.url, "URL is required; it must not be null");
        Utils.notNull(this.username, "username is required; it must not be null");
        Utils.notNull(this.password, "password is required; it must not be null");
    }
}

