/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.rabbitmq.http.client.ClientCreationContext;
import com.rabbitmq.http.client.OkHttpClientBuilderConfigurator;
import com.rabbitmq.http.client.RestTemplateConfigurator;
import com.rabbitmq.http.client.Utils;
import java.net.URL;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class OkHttpRestTemplateConfigurator
implements RestTemplateConfigurator {
    private static final OkHttpClientBuilderConfigurator NO_OP_HTTP_CLIENT_BUILDER_CONFIGURATOR = builder -> builder;
    private final OkHttpClientBuilderConfigurator configurator;
    private final SSLSocketFactory sslSocketFactory;
    private final X509TrustManager trustManager;

    public OkHttpRestTemplateConfigurator() {
        this(NO_OP_HTTP_CLIENT_BUILDER_CONFIGURATOR);
    }

    public OkHttpRestTemplateConfigurator(OkHttpClientBuilderConfigurator configurator) {
        this(null, null, configurator);
    }

    public OkHttpRestTemplateConfigurator(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        this(sslSocketFactory, trustManager, NO_OP_HTTP_CLIENT_BUILDER_CONFIGURATOR);
    }

    public OkHttpRestTemplateConfigurator(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager, OkHttpClientBuilderConfigurator configurator) {
        Assert.notNull((Object)configurator, (String)"configurator is required; it must not be null");
        this.sslSocketFactory = sslSocketFactory;
        this.trustManager = trustManager;
        this.configurator = configurator;
    }

    @Override
    public RestTemplate configure(ClientCreationContext context) {
        RestTemplate restTemplate = context.getRestTemplate();
        ClientHttpRequestFactory requestFactory = this.getRequestFactory(context.getClientParameters().getUrl(), context.getClientParameters().getUsername(), context.getClientParameters().getPassword(), this.sslSocketFactory, this.trustManager, this.configurator);
        restTemplate.setRequestFactory(requestFactory);
        return restTemplate;
    }

    private ClientHttpRequestFactory getRequestFactory(URL url, String username, String password, SSLSocketFactory sslSocketFactory, X509TrustManager trustManager, OkHttpClientBuilderConfigurator configurator) {
        Assert.notNull((Object)configurator, (String)"configurator is required; it must not be null");
        String theUser = username;
        String thePassword = password;
        String userInfo = url.getUserInfo();
        if (userInfo != null && theUser == null) {
            String[] userParts = userInfo.split(":");
            if (userParts.length > 0) {
                theUser = Utils.decode(userParts[0]);
            }
            if (userParts.length > 1) {
                thePassword = Utils.decode(userParts[1]);
            }
        }
        String credentials = Credentials.basic((String)theUser, (String)thePassword);
        OkHttpClient.Builder bldr = new OkHttpClient.Builder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", credentials).build());
        if (sslSocketFactory != null && trustManager != null) {
            bldr.sslSocketFactory(sslSocketFactory, trustManager);
        }
        OkHttpClient.Builder b = configurator.configure(bldr);
        OkHttpClient httpClient = b.build();
        return new OkHttp3ClientHttpRequestFactory(httpClient);
    }
}

