/*
 * Decompiled with CFR 0.152.
 */
package com.r0adkll.slidr;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import com.r0adkll.slidr.ColorPanelSlideListener;
import com.r0adkll.slidr.ConfigPanelSlideListener;
import com.r0adkll.slidr.FragmentPanelSlideListener;
import com.r0adkll.slidr.R;
import com.r0adkll.slidr.model.SlidrConfig;
import com.r0adkll.slidr.model.SlidrInterface;
import com.r0adkll.slidr.widget.SliderPanel;

public final class Slidr {
    @NonNull
    public static SlidrInterface attach(@NonNull Activity activity) {
        return Slidr.attach(activity, -1, -1);
    }

    @NonNull
    public static SlidrInterface attach(@NonNull Activity activity, @ColorInt int statusBarColor1, @ColorInt int statusBarColor2) {
        SliderPanel panel = Slidr.attachSliderPanel(activity, null);
        panel.setOnPanelSlideListener(new ColorPanelSlideListener(activity, statusBarColor1, statusBarColor2));
        return panel.getDefaultInterface();
    }

    @NonNull
    public static SlidrInterface attach(@NonNull Activity activity, @NonNull SlidrConfig config) {
        SliderPanel panel = Slidr.attachSliderPanel(activity, config);
        panel.setOnPanelSlideListener(new ConfigPanelSlideListener(activity, config));
        return panel.getDefaultInterface();
    }

    @NonNull
    private static SliderPanel attachSliderPanel(@NonNull Activity activity, @NonNull SlidrConfig config) {
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View oldScreen = decorView.getChildAt(0);
        decorView.removeViewAt(0);
        SliderPanel panel = new SliderPanel((Context)activity, oldScreen, config);
        panel.setId(R.id.slidable_panel);
        oldScreen.setId(R.id.slidable_content);
        panel.addView(oldScreen);
        decorView.addView((View)panel, 0);
        return panel;
    }

    @NonNull
    public static SlidrInterface replace(@NonNull View oldScreen, @NonNull SlidrConfig config) {
        ViewGroup parent = (ViewGroup)oldScreen.getParent();
        ViewGroup.LayoutParams params = oldScreen.getLayoutParams();
        parent.removeView(oldScreen);
        SliderPanel panel = new SliderPanel(oldScreen.getContext(), oldScreen, config);
        panel.setId(R.id.slidable_panel);
        oldScreen.setId(R.id.slidable_content);
        panel.addView(oldScreen);
        parent.addView((View)panel, 0, params);
        panel.setOnPanelSlideListener(new FragmentPanelSlideListener(oldScreen, config));
        return panel.getDefaultInterface();
    }
}

