/*
 * Decompiled with CFR 0.152.
 */
package com.quicklib.android.core.view;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.quicklib.android.core.bo.CustomViewState;

public abstract class CustomRelativeLayout
extends RelativeLayout {
    @Nullable
    private Bundle arguments = new Bundle();

    public CustomRelativeLayout(Context context) {
        this(context, null, 0);
    }

    public CustomRelativeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CustomRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.onCreate(attrs, this.arguments);
        this.onCreateView(LayoutInflater.from((Context)context), (ViewGroup)this, true);
    }

    @Nullable
    public Bundle getArguments() {
        return this.arguments;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.onActivityCreated(null);
        this.onStart();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.onResume();
        } else {
            this.onPause();
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.onResume();
        } else {
            this.onPause();
        }
    }

    protected Parcelable onSaveInstanceState() {
        CustomViewState viewState = new CustomViewState(super.onSaveInstanceState());
        this.onSaveInstanceState(viewState.getInstanceState());
        return viewState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
        if (state instanceof CustomViewState) {
            CustomViewState viewState = (CustomViewState)state;
            super.onRestoreInstanceState(viewState.getSuperState());
            this.onActivityCreated(viewState.getInstanceState());
        } else {
            super.onRestoreInstanceState(state);
            this.onActivityCreated(new Bundle());
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onStop();
        this.onDestroy();
    }

    @Nullable
    public abstract void onCreate(@Nullable AttributeSet var1, Bundle var2);

    @NonNull
    public abstract View onCreateView(LayoutInflater var1, @Nullable ViewGroup var2, boolean var3);

    public abstract void onActivityCreated(@Nullable Bundle var1);

    public void onSaveInstanceState(Bundle outState) {
    }

    public void onStart() {
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onStop() {
    }

    public void onDestroy() {
    }
}

