/*
 * Decompiled with CFR 0.152.
 */
package com.quicklib.android.core.helper;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import java.io.IOException;
import java.io.InputStream;

public class DrawableHelper {
    public static Drawable getAssetImage(Context context, String imagePath) {
        return DrawableHelper.getAssetImage(context, imagePath, 0);
    }

    public static Drawable getAssetImage(Context context, String imagePath, @DrawableRes int fallbackDrawableId) {
        try {
            InputStream ims = context.getAssets().open(imagePath);
            return Drawable.createFromStream((InputStream)ims, null);
        }
        catch (IOException ex) {
            if (fallbackDrawableId != 0) {
                return ContextCompat.getDrawable((Context)context, (int)fallbackDrawableId);
            }
            return null;
        }
    }

    public static Drawable getTintedDrawable(Context context, @DrawableRes int drawableId, @ColorRes int colorId) {
        Drawable drawable = ContextCompat.getDrawable((Context)context, (int)drawableId);
        return DrawableHelper.getTintedDrawable(context, drawable, colorId);
    }

    public static Drawable getTintedDrawable(Context context, Drawable drawable, @ColorRes int colorId) {
        if (drawable != null) {
            drawable = DrawableCompat.wrap((Drawable)drawable);
            try {
                DrawableCompat.setTintList((Drawable)drawable.mutate(), (ColorStateList)ContextCompat.getColorStateList((Context)context, (int)colorId));
            }
            catch (Resources.NotFoundException e) {
                DrawableCompat.setTint((Drawable)drawable.mutate(), (int)ContextCompat.getColor((Context)context, (int)colorId));
            }
        }
        return drawable;
    }

    public static Drawable getTintedDrawable(Drawable drawable, @ColorInt int colorId) {
        if (drawable != null) {
            drawable = DrawableCompat.wrap((Drawable)drawable);
            DrawableCompat.setTint((Drawable)drawable.mutate(), (int)colorId);
        }
        return drawable;
    }

    public static Drawable getTintedDrawable(Drawable drawable, ColorStateList colorStateList) {
        if (drawable != null) {
            drawable = DrawableCompat.wrap((Drawable)drawable);
            DrawableCompat.setTintList((Drawable)drawable.mutate(), (ColorStateList)colorStateList);
        }
        return drawable;
    }
}

