/*
 * Decompiled with CFR 0.152.
 */
package com.quicklib.android.core.helper;

import android.content.Context;
import android.os.Handler;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.quicklib.android.core.R;

public class AnimationHelper {
    public static final long ANIMATION_DURATION = 500L;

    public static void fadeIn(View view) {
        AnimationHelper.fadeIn(view, 500L);
    }

    public static void fadeIn(View view, long duration) {
        AnimationHelper.fadeIn(view, duration, 0L);
    }

    public static void fadeIn(final View view, long duration, long delayed) {
        final Animation animation = AnimationUtils.loadAnimation((Context)view.getContext(), (int)R.anim.fadein);
        animation.setDuration(duration);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.setVisibility(0);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                view.startAnimation(animation);
            }
        }, delayed);
    }

    public static void fadeOut(View view) {
        AnimationHelper.fadeOut(view, 500L);
    }

    public static void fadeOut(View view, long duration) {
        AnimationHelper.fadeOut(view, duration, 0L);
    }

    public static void fadeOut(final View view, long duration, long delayed) {
        final Animation animation = AnimationUtils.loadAnimation((Context)view.getContext(), (int)R.anim.fadeout);
        animation.setDuration(duration);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.setVisibility(8);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                view.startAnimation(animation);
            }
        }, delayed);
    }
}

