/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.PathMetadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathInits
implements Serializable {
    private static final long serialVersionUID = -2173980858324141095L;
    public static final PathInits DEFAULT = new PathInits(new String[0]);
    public static final PathInits DIRECT = new PathInits("*");
    public static final PathInits DIRECT2 = new PathInits("*.*");
    private final boolean initAllProps;
    private final PathInits defaultValue;
    private final Map<String, PathInits> propertyToInits = new HashMap<String, PathInits>();

    public PathInits(String ... initStrs) {
        boolean initAllProps = false;
        PathInits defaultValue = DEFAULT;
        HashMap<String, Collection> properties = new HashMap<String, Collection>();
        for (String initStr : initStrs) {
            if (initStr.equals("*")) {
                initAllProps = true;
                continue;
            }
            if (initStr.startsWith("*.")) {
                initAllProps = true;
                defaultValue = new PathInits(initStr.substring(2));
                continue;
            }
            String key = initStr;
            List<Object> inits = Collections.emptyList();
            if (initStr.contains(".")) {
                key = initStr.substring(0, initStr.indexOf(46));
                inits = Collections.singletonList(initStr.substring(key.length() + 1));
            }
            Collection values = properties.computeIfAbsent(key, k -> new ArrayList());
            values.addAll(inits);
        }
        for (Map.Entry entry : properties.entrySet()) {
            PathInits inits = new PathInits(((Collection)entry.getValue()).toArray(new String[0]));
            this.propertyToInits.put((String)entry.getKey(), inits);
        }
        this.initAllProps = initAllProps;
        this.defaultValue = defaultValue;
    }

    public PathInits get(String property) {
        if (this.propertyToInits.containsKey(property)) {
            return this.propertyToInits.get(property);
        }
        if (this.initAllProps) {
            return this.defaultValue;
        }
        throw new IllegalArgumentException(property + " is not initialized");
    }

    public boolean isInitialized(String property) {
        return this.initAllProps || this.propertyToInits.containsKey(property);
    }

    public static PathInits getFor(PathMetadata metadata, PathInits root) {
        if (metadata.isRoot()) {
            return root;
        }
        if (metadata.getParent().getMetadata().isRoot()) {
            return DIRECT;
        }
        return DEFAULT;
    }
}

