/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;

class Retry {
    private Retry() {
    }

    static boolean shouldUploadAgain(Response response, QiniuException exception) {
        Response checkResponse = response;
        if (checkResponse == null && exception != null) {
            checkResponse = exception.response;
        }
        if (checkResponse != null) {
            int statusCode = checkResponse.statusCode;
            return statusCode > -2 && statusCode < 200 || statusCode > 299 && statusCode != 401 && statusCode != 413 && statusCode != 419 && statusCode != 608 && statusCode != 614 && statusCode != 630;
        }
        return exception == null || !exception.isUnrecoverable();
    }

    static Boolean requestShouldRetry(Response response, QiniuException exception) {
        if (response != null && response.needRetry()) {
            return true;
        }
        if (exception == null || exception.isUnrecoverable()) {
            return false;
        }
        if (exception.response != null && exception.response.needRetry()) {
            return true;
        }
        return false;
    }

    static Boolean requestShouldSwitchHost(Response response, QiniuException exception) {
        if (response != null && response.needSwitchServer()) {
            return true;
        }
        if (exception == null) {
            return true;
        }
        if (exception.isUnrecoverable()) {
            return false;
        }
        if (exception.response == null || exception.response.needSwitchServer()) {
            return true;
        }
        return false;
    }

    static Response retryRequestAction(RequestRetryConfig config, RequestRetryAction action) throws QiniuException {
        if (config == null) {
            throw QiniuException.unrecoverable("RequestRetryConfig can't empty");
        }
        if (action == null) {
            throw QiniuException.unrecoverable("RequestRetryAction can't empty");
        }
        Response response = null;
        QiniuException exception = null;
        int retryCount = 0;
        while (true) {
            boolean shouldSwitchHost = false;
            boolean shouldRetry = false;
            exception = null;
            String host = action.getRequestHost();
            try {
                response = action.doRequest(host);
                shouldRetry = Retry.requestShouldRetry(response, null);
                shouldSwitchHost = Retry.requestShouldSwitchHost(response, null);
            }
            catch (QiniuException e) {
                exception = e;
                shouldRetry = Retry.requestShouldRetry(null, e);
                shouldSwitchHost = Retry.requestShouldSwitchHost(null, e);
            }
            if (!shouldRetry) break;
            if (++retryCount >= config.retryMax) {
                QiniuException innerException = null;
                innerException = response != null ? new QiniuException(response) : new QiniuException(exception);
                throw new QiniuException(innerException, "failed after retry times");
            }
            if (!shouldSwitchHost) continue;
            action.tryChangeRequestHost(host);
        }
        if (exception != null) {
            throw exception;
        }
        return response;
    }

    static interface RequestRetryAction {
        public String getRequestHost() throws QiniuException;

        public void tryChangeRequestHost(String var1) throws QiniuException;

        public Response doRequest(String var1) throws QiniuException;
    }

    static class RequestRetryConfig {
        final int retryMax;

        RequestRetryConfig(int retryMax) {
            this.retryMax = retryMax;
        }

        static class Builder {
            private int retryMax = 3;

            Builder() {
            }

            public Builder setRetryMax(int retryMax) {
                this.retryMax = retryMax;
                return this;
            }

            RequestRetryConfig build() {
                return new RequestRetryConfig(this.retryMax);
            }
        }
    }
}

