/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.http.okhttp.callback;

import android.text.TextUtils;
import com.zhy.http.okhttp.OkHttpUtils;
import com.zhy.http.okhttp.callback.Callback;
import com.zhy.http.okhttp.utils.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileCallBack
extends Callback<File> {
    private static String APK_CONTENTTYPE = "application/vnd.android.package-archive";
    private static String PNG_CONTENTTYPE = "image/png";
    private static String JPG_CONTENTTYPE = "image/jpg";
    private String destFileDir;
    private String destFileName;

    public FileCallBack(String destFileDir, @Nullable String destFileName) {
        this.destFileDir = destFileDir;
        this.destFileName = destFileName;
    }

    @Override
    public File parseNetworkResponse(Response response, int id) throws Exception {
        return this.saveFile(response, id);
    }

    public File saveFile(Response response, final int id) throws IOException {
        boolean mkdirs;
        this.destFileName = this.verifyFileName(this.destFileDir, this.destFileName, response);
        File dir = new File(this.destFileDir);
        if (dir.exists() || !(mkdirs = dir.mkdirs())) {
            // empty if block
        }
        File file = new File(dir, this.destFileName);
        Sink sink = Okio.sink((File)file);
        Source source = Okio.source((InputStream)response.body().byteStream());
        final long totalSize = response.body().contentLength();
        BufferedSink bufferedSink = Okio.buffer((Sink)sink);
        bufferedSink.writeAll((Source)new ForwardingSource(source){
            long sum;
            int oldRate;
            {
                super(x0);
                this.sum = 0L;
                this.oldRate = 0;
            }

            public long read(Buffer sink, long byteCount) throws IOException {
                long readSize = super.read(sink, byteCount);
                if (readSize != -1L) {
                    this.sum += readSize;
                    final int rate = Math.round((float)this.sum * 1.0f / (float)totalSize * 100.0f);
                    if (this.oldRate != rate) {
                        OkHttpUtils.getInstance().getDelivery().execute(new Runnable(){

                            @Override
                            public void run() {
                                FileCallBack.this.inProgress((float)rate * 1.0f / 100.0f, totalSize, id);
                            }
                        });
                        this.oldRate = rate;
                    }
                }
                return readSize;
            }
        });
        bufferedSink.flush();
        Util.closeQuietly((Closeable)sink);
        Util.closeQuietly((Closeable)source);
        return file;
    }

    private String verifyFileName(String destFileDir, @Nullable String name, @NotNull Response response) {
        ResponseBody body = response.body();
        name = !TextUtils.isEmpty((CharSequence)name) ? this.getRealFileName(name, body) : this.createFileName(response);
        name = this.verifyFileNameTooLong(destFileDir, name, response);
        return name;
    }

    private String verifyFileNameTooLong(String destFileDir, @Nullable String name, Response response) {
        File file = new File(destFileDir.concat(File.separator).concat(name));
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            name = this.createFileName(response);
            File file1 = new File(destFileDir.concat(File.separator).concat(name));
            try {
                file1.createNewFile();
            }
            catch (IOException ee) {
                ee.printStackTrace();
                name = this.getRandomFileName(response.body());
            }
        }
        return name;
    }

    private String getRealFileName(@NotNull String name, @NotNull ResponseBody body) {
        if (!name.contains(".")) {
            name = name + this.getFileRealSuffix(body);
        }
        return name;
    }

    private String getFileRealSuffix(@NotNull ResponseBody body) {
        String fileSuffix = "";
        if (body.contentType() != null) {
            String type = body.contentType().toString();
            fileSuffix = type.equals(APK_CONTENTTYPE) ? ".apk" : (type.equals(PNG_CONTENTTYPE) ? ".png" : (type.equals(JPG_CONTENTTYPE) ? ".jpg" : "." + body.contentType().subtype()));
        }
        return fileSuffix;
    }

    private String createFileName(@NotNull Response response) {
        String name;
        ResponseBody body = response.body();
        try {
            String url = response.newBuilder().build().request().url().toString();
            name = Utils.getFileName(url);
            name = !TextUtils.isEmpty((CharSequence)name) ? this.getRealFileName(name, body) : this.getRandomFileName(body);
        }
        catch (Exception e) {
            e.printStackTrace();
            name = this.getRandomFileName(body);
        }
        return name;
    }

    private String getRandomFileName(@NotNull ResponseBody responseBody) {
        return System.currentTimeMillis() + this.getFileRealSuffix(responseBody);
    }
}

