/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.http.okhttp.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;
import com.zhy.http.okhttp.OkHttpUtils;
import java.io.File;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.RequestBody;

public class Utils {
    public static Context getContext() {
        return OkHttpUtils.getInstance().getContext();
    }

    public static String getFileName(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return filePath;
        }
        int filePosi = filePath.lastIndexOf(File.separator);
        return filePosi == -1 ? filePath : filePath.substring(filePosi + 1);
    }

    public static boolean isConnected() {
        NetworkInfo info;
        ConnectivityManager connectivity = (ConnectivityManager)Utils.getContext().getSystemService("connectivity");
        return null != connectivity && null != (info = connectivity.getActiveNetworkInfo()) && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED;
    }

    public static <R> Type findNeedType(Class<R> cls) {
        List<Type> typeList = Utils.getMethodTypes(cls);
        if (typeList == null || typeList.isEmpty()) {
            return RequestBody.class;
        }
        return typeList.get(0);
    }

    public static <T> List<Type> getMethodTypes(Class<T> cls) {
        Type typeOri = cls.getGenericSuperclass();
        ArrayList<Type> needtypes = null;
        if (typeOri instanceof ParameterizedType) {
            Type[] parentypes;
            needtypes = new ArrayList<Type>();
            for (Type childtype : parentypes = ((ParameterizedType)typeOri).getActualTypeArguments()) {
                needtypes.add(childtype);
                if (!(childtype instanceof ParameterizedType)) continue;
                Type[] childtypes = ((ParameterizedType)childtype).getActualTypeArguments();
                Collections.addAll(needtypes, childtypes);
            }
        }
        return needtypes;
    }

    public static Class getClass(Type type, int i) {
        if (type instanceof ParameterizedType) {
            return Utils.getGenericClass((ParameterizedType)type, i);
        }
        if (type instanceof TypeVariable) {
            return Utils.getClass(((TypeVariable)type).getBounds()[0], 0);
        }
        return (Class)type;
    }

    public static Type getType(Type type, int i) {
        if (type instanceof ParameterizedType) {
            return Utils.getGenericType((ParameterizedType)type, i);
        }
        if (type instanceof TypeVariable) {
            return Utils.getType(((TypeVariable)type).getBounds()[0], 0);
        }
        return type;
    }

    public static Type getParameterizedType(Type type, int i) {
        if (type instanceof ParameterizedType) {
            Type genericType = ((ParameterizedType)type).getActualTypeArguments()[i];
            return genericType;
        }
        if (type instanceof TypeVariable) {
            return Utils.getType(((TypeVariable)type).getBounds()[0], 0);
        }
        return type;
    }

    public static Class getGenericClass(ParameterizedType parameterizedType, int i) {
        Type genericClass = parameterizedType.getActualTypeArguments()[i];
        if (genericClass instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericClass).getRawType();
        }
        if (genericClass instanceof GenericArrayType) {
            return (Class)((GenericArrayType)genericClass).getGenericComponentType();
        }
        if (genericClass instanceof TypeVariable) {
            return Utils.getClass(((TypeVariable)genericClass).getBounds()[0], 0);
        }
        return (Class)genericClass;
    }

    public static Type getGenericType(ParameterizedType parameterizedType, int i) {
        Type genericType = parameterizedType.getActualTypeArguments()[i];
        if (genericType instanceof ParameterizedType) {
            return ((ParameterizedType)genericType).getRawType();
        }
        if (genericType instanceof GenericArrayType) {
            return ((GenericArrayType)genericType).getGenericComponentType();
        }
        if (genericType instanceof TypeVariable) {
            return Utils.getClass(((TypeVariable)genericType).getBounds()[0], 0);
        }
        return genericType;
    }

    public static <T> Type findNeedClass(Class<T> cls) {
        Type finalNeedType;
        Type genType = cls.getGenericSuperclass();
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        Type type = params[0];
        if (params.length > 1) {
            if (!(type instanceof ParameterizedType)) {
                throw new IllegalStateException("\u6ca1\u6709\u586b\u5199\u6cdb\u578b\u53c2\u6570");
            }
            finalNeedType = ((ParameterizedType)type).getActualTypeArguments()[0];
        } else {
            finalNeedType = type;
        }
        return finalNeedType;
    }

    public static <T> Type findRawType(Class<T> cls) {
        Type genType = cls.getGenericSuperclass();
        return Utils.getGenericType((ParameterizedType)genType, 0);
    }
}

