/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.http.okhttp.request;

import com.zhy.http.okhttp.OkHttpUtils;
import com.zhy.http.okhttp.builder.PostFormBuilder;
import com.zhy.http.okhttp.callback.Callback;
import com.zhy.http.okhttp.request.CountingRequestBody;
import com.zhy.http.okhttp.request.OkHttpRequest;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public class PostFormRequest
extends OkHttpRequest {
    private List<PostFormBuilder.FileInput> files;

    public PostFormRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, List<PostFormBuilder.FileInput> files, int id) {
        super(url, tag, params, headers, id);
        this.files = files;
    }

    @Override
    protected RequestBody buildRequestBody() {
        if (this.files == null || this.files.isEmpty()) {
            FormBody.Builder builder = new FormBody.Builder();
            this.addParams(builder);
            FormBody formBody = builder.build();
            return formBody;
        }
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        this.addParams(builder);
        for (int i = 0; i < this.files.size(); ++i) {
            PostFormBuilder.FileInput fileInput = this.files.get(i);
            RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)this.guessMimeType(fileInput.filename)), (File)fileInput.file);
            builder.addFormDataPart(fileInput.key, fileInput.filename, fileBody);
        }
        return builder.build();
    }

    @Override
    protected RequestBody wrapRequestBody(RequestBody requestBody, final Callback callback) {
        if (callback == null) {
            return requestBody;
        }
        CountingRequestBody countingRequestBody = new CountingRequestBody(requestBody, new CountingRequestBody.Listener(){

            @Override
            public void onRequestProgress(final long bytesWritten, final long contentLength) {
                OkHttpUtils.getInstance().getDelivery().execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.inProgress((float)bytesWritten * 1.0f / (float)contentLength, contentLength, PostFormRequest.this.id);
                    }
                });
            }
        });
        return countingRequestBody;
    }

    @Override
    protected Request buildRequest(RequestBody requestBody) {
        return this.builder.post(requestBody).build();
    }

    private String guessMimeType(String path) {
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentTypeFor = null;
        try {
            contentTypeFor = fileNameMap.getContentTypeFor(URLEncoder.encode(path, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (contentTypeFor == null) {
            contentTypeFor = "application/octet-stream";
        }
        return contentTypeFor;
    }

    private void addParams(MultipartBody.Builder builder) {
        if (this.params != null && !this.params.isEmpty()) {
            for (String key : this.params.keySet()) {
                builder.addPart(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + key + "\""}), RequestBody.create(null, (String)((String)this.params.get(key))));
            }
        }
    }

    private void addParams(FormBody.Builder builder) {
        if (this.params != null) {
            for (String key : this.params.keySet()) {
                builder.add(key, (String)this.params.get(key));
            }
        }
    }
}

