/*
 * Decompiled with CFR 0.152.
 */
package com.zhy.http.okhttp.callback;

import java.net.SocketTimeoutException;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;

public abstract class Callback<T> {
    public static Callback CALLBACK_DEFAULT = new Callback(){

        public Object parseNetworkResponse(Response response, int id) throws Exception {
            return null;
        }

        @Override
        public void onError(Call call, Response response, Exception e, int id) {
        }

        public void onResponse(Object response, int id) {
        }
    };

    public void onBefore(Request request, int id) {
    }

    public void onAfter(int id) {
    }

    public void inProgress(float progress, long total, int id) {
    }

    protected String validateError(Exception error, Response response) {
        if (error != null && error instanceof SocketTimeoutException) {
            return "\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5";
        }
        if (response != null) {
            int code = response.code();
            if (code >= 500) {
                return "\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5";
            }
            if (code < 500 && code >= 400) {
                return "\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5";
            }
            return String.format("\u672a\u77e5\u5f02\u5e38%d\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5", code);
        }
        return "\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u7a0d\u5019\u91cd\u8bd5";
    }

    public boolean validateResponse(Response response, int id) {
        return response.isSuccessful();
    }

    public abstract T parseNetworkResponse(Response var1, int var2) throws Exception;

    public abstract void onError(Call var1, Response var2, Exception var3, int var4);

    public abstract void onResponse(T var1, int var2);
}

