/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.internal.COSDirect;
import com.qcloud.cos.internal.crypto.COSCryptoModule;
import com.qcloud.cos.internal.crypto.COSCryptoModuleAE;
import com.qcloud.cos.internal.crypto.COSCryptoModuleAEStrict;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoMode;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsProvider;
import com.qcloud.cos.internal.crypto.QCLOUDKMS;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyPartResult;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutInstructionFileRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import java.io.File;

public class CryptoModuleDispatcher
extends COSCryptoModule {
    private final CryptoMode defaultCryptoMode;
    private final COSCryptoModuleAE ae;

    public CryptoModuleDispatcher(QCLOUDKMS kms, COSDirect cos, COSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider encryptionMaterialsProvider, CryptoConfiguration cryptoConfig) {
        cryptoConfig = cryptoConfig.clone();
        CryptoMode cryptoMode = cryptoConfig.getCryptoMode();
        if (cryptoMode == null) {
            cryptoMode = CryptoMode.AuthenticatedEncryption;
            cryptoConfig.setCryptoMode(cryptoMode);
        }
        cryptoConfig = cryptoConfig.readOnly();
        this.defaultCryptoMode = cryptoConfig.getCryptoMode();
        switch (this.defaultCryptoMode) {
            case StrictAuthenticatedEncryption: {
                this.ae = new COSCryptoModuleAEStrict(kms, cos, credentialsProvider, encryptionMaterialsProvider, cryptoConfig);
                break;
            }
            case AuthenticatedEncryption: {
                this.ae = new COSCryptoModuleAE(kms, cos, credentialsProvider, encryptionMaterialsProvider, cryptoConfig);
                break;
            }
            case AesCtrEncryption: {
                this.ae = new COSCryptoModuleAE(kms, cos, credentialsProvider, encryptionMaterialsProvider, cryptoConfig);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public PutObjectResult putObjectSecurely(PutObjectRequest putObjectRequest) {
        return this.ae.putObjectSecurely(putObjectRequest);
    }

    @Override
    public COSObject getObjectSecurely(GetObjectRequest req) {
        return this.ae.getObjectSecurely(req);
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest req, File destinationFile) {
        return this.ae.getObjectSecurely(req, destinationFile);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUploadSecurely(CompleteMultipartUploadRequest req) throws CosClientException, CosServiceException {
        return this.ae.completeMultipartUploadSecurely(req);
    }

    @Override
    public void abortMultipartUploadSecurely(AbortMultipartUploadRequest req) {
        this.ae.abortMultipartUploadSecurely(req);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUploadSecurely(InitiateMultipartUploadRequest req) throws CosClientException, CosServiceException {
        return this.ae.initiateMultipartUploadSecurely(req);
    }

    @Override
    public UploadPartResult uploadPartSecurely(UploadPartRequest req) throws CosClientException, CosServiceException {
        return this.ae.uploadPartSecurely(req);
    }

    @Override
    public CopyPartResult copyPartSecurely(CopyPartRequest req) {
        return this.ae.copyPartSecurely(req);
    }

    @Override
    public PutObjectResult putInstructionFileSecurely(PutInstructionFileRequest req) {
        return this.ae.putInstructionFileSecurely(req);
    }
}

