/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransferProgress {
    private static final Logger log = LoggerFactory.getLogger(TransferProgress.class);
    private volatile long bytesTransferred = 0L;
    private volatile long totalBytesToTransfer = -1L;

    public long getBytesTransfered() {
        return this.getBytesTransferred();
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public long getTotalBytesToTransfer() {
        return this.totalBytesToTransfer;
    }

    @Deprecated
    public synchronized double getPercentTransfered() {
        return this.getPercentTransferred();
    }

    public synchronized double getPercentTransferred() {
        if (this.getBytesTransferred() < 0L) {
            return 0.0;
        }
        return this.totalBytesToTransfer < 0L ? -1.0 : (double)this.bytesTransferred / (double)this.totalBytesToTransfer * 100.0;
    }

    public synchronized void updateProgress(long bytes) {
        this.bytesTransferred += bytes;
        if (this.totalBytesToTransfer > -1L && this.bytesTransferred > this.totalBytesToTransfer) {
            this.bytesTransferred = this.totalBytesToTransfer;
            if (log.isDebugEnabled()) {
                log.debug("Number of bytes transfered is more than the actual total bytes to transfer. Total number of bytes to Transfer : " + this.totalBytesToTransfer + ". Bytes Transferred : " + (this.bytesTransferred + bytes));
            }
        }
    }

    public void setTotalBytesToTransfer(long totalBytesToTransfer) {
        this.totalBytesToTransfer = totalBytesToTransfer;
    }
}

