/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.meta;

import com.qcloud.cos.common_utils.CommonFileUtils;
import com.qcloud.cos.exception.AbstractCosException;
import com.qcloud.cos.exception.UnknownException;
import com.qcloud.cos.meta.InsertOnly;
import com.qcloud.cos.meta.SlicePart;
import com.qcloud.cos.request.UploadSliceFileRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class UploadSliceFileContext {
    private String bucketName = "";
    private String cosPath = "";
    private String localPath = "";
    private String bizAttr = "";
    private InsertOnly insertOnly = InsertOnly.NO_OVER_WRITE;
    private int sliceSize;
    private long fileSize = 0L;
    private String url = "";
    private boolean enableShaDigest = true;
    private int taskNum = 1;
    private String sessionId = "";
    private String entireFileSha = "";
    private boolean serialUpload = true;
    private boolean uploadFromBuffer = false;
    private byte[] contentBuffer = null;
    public ArrayList<SlicePart> sliceParts;
    private Set<Long> uploadCompletePartsSet;

    public UploadSliceFileContext(UploadSliceFileRequest request) throws AbstractCosException {
        this.bucketName = request.getBucketName();
        this.cosPath = request.getCosPath();
        this.uploadFromBuffer = request.isUploadFromBuffer();
        if (request.isUploadFromBuffer()) {
            this.contentBuffer = request.getContentBufer();
        }
        this.localPath = request.getLocalPath();
        this.bizAttr = request.getBizAttr();
        this.insertOnly = request.getInsertOnly();
        this.sliceSize = request.getSliceSize();
        this.taskNum = request.getTaskNum();
        this.enableShaDigest = request.isEnableShaDigest();
        this.sliceParts = new ArrayList();
        this.uploadCompletePartsSet = new HashSet<Long>();
        this.caculateFileSize();
    }

    private void caculateFileSize() throws UnknownException {
        try {
            this.fileSize = this.uploadFromBuffer ? (long)this.contentBuffer.length : CommonFileUtils.getFileLength(this.localPath);
        }
        catch (Exception e) {
            throw new UnknownException("caculateFileSize error. " + e.toString());
        }
    }

    public ArrayList<SlicePart> prepareUploadPartsInfo() {
        int sliceCount = new Long((this.fileSize + (long)(this.sliceSize - 1)) / (long)this.sliceSize).intValue();
        for (int sliceIndex = 0; sliceIndex < sliceCount; ++sliceIndex) {
            SlicePart part = new SlicePart();
            long offset = Long.valueOf(sliceIndex) * (long)this.sliceSize;
            part.setOffset(offset);
            if (sliceIndex != sliceCount - 1) {
                part.setSliceSize(this.sliceSize);
            } else {
                part.setSliceSize(new Long(this.fileSize - offset).intValue());
            }
            part.setUploadCompleted(this.uploadCompletePartsSet.contains(offset));
            this.sliceParts.add(part);
        }
        return this.sliceParts;
    }

    public void setUploadCompleteParts(JSONArray listPartsArry) {
        int listPartsLen = listPartsArry.length();
        for (int listPartsIndex = 0; listPartsIndex < listPartsLen; ++listPartsIndex) {
            JSONObject listPartMember = listPartsArry.getJSONObject(listPartsIndex);
            long partOffset = listPartMember.getLong("offset");
            this.uploadCompletePartsSet.add(partOffset);
        }
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getCosPath() {
        return this.cosPath;
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getBizAttr() {
        return this.bizAttr;
    }

    public void setBizAttr(String bizAttr) {
        this.bizAttr = bizAttr;
    }

    public InsertOnly getInsertOnly() {
        return this.insertOnly;
    }

    public void setInsertOnly(InsertOnly insertOnly) {
        this.insertOnly = insertOnly;
    }

    public int getSliceSize() {
        return this.sliceSize;
    }

    public void setSliceSize(int sliceSize) {
        this.sliceSize = sliceSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isEnableShaDigest() {
        return this.enableShaDigest;
    }

    public void setEnableShaDigest(boolean enableShaDigest) {
        this.enableShaDigest = enableShaDigest;
    }

    public int getTaskNum() {
        return this.taskNum;
    }

    public void setTaskNum(int taskNum) {
        this.taskNum = taskNum;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getEntireFileSha() {
        return this.entireFileSha;
    }

    public void setEntireFileSha(String entireFileSha) {
        this.entireFileSha = entireFileSha;
    }

    public boolean isSerialUpload() {
        return this.serialUpload;
    }

    public void setSerialUpload(boolean serialUpload) {
        this.serialUpload = serialUpload;
    }

    public boolean isUploadFromBuffer() {
        return this.uploadFromBuffer;
    }

    public void setUploadFromBuffer(boolean uploadFromBuffer) {
        this.uploadFromBuffer = uploadFromBuffer;
    }

    public byte[] getContentBuffer() {
        return this.contentBuffer;
    }

    public void setContentBuffer(byte[] contentBuffer) {
        this.contentBuffer = contentBuffer;
    }
}

