/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.utils;

import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.Nullable;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.utils.CRC64;
import com.tencent.cos.xml.utils.CloseUtil;
import com.tencent.cos.xml.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DigestUtils {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMD5(String filePath) throws CosXmlClientException {
        String md5;
        if (filePath == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "file Path is null");
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "file Path is not exist");
        }
        FileInputStream fileInputStream = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            fileInputStream = new FileInputStream(file);
            byte[] buffer = new byte[32768];
            int len = -1;
            while ((len = fileInputStream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, len);
            }
            md5 = StringUtils.toHexString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            try {
                throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
                catch (FileNotFoundException e2) {
                    throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), e2);
                }
                catch (IOException e3) {
                    throw new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), e3);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        CloseUtil.closeQuietly(fileInputStream);
        return md5;
    }

    public static long getBigIntFromString(String value) {
        return new BigInteger(value).longValue();
    }

    public static String getBigIntToString(long l) {
        BigInteger b0 = BigInteger.valueOf(l >> 1 & 0x4000000000000000L);
        BigInteger b1 = BigInteger.valueOf(l & Long.MAX_VALUE);
        return b0.add(b0).add(b1).toString();
    }

    public static String getCRC64String(InputStream inputStream) {
        return DigestUtils.getBigIntToString(DigestUtils.getCRC64(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCRC64String(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            String string = DigestUtils.getCRC64String(fileInputStream);
            return string;
        }
        catch (Exception exception) {
            String string = "";
            return string;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
    }

    public static long getCRC64(InputStream inputStream) {
        try {
            int readLen;
            CRC64 crc64 = new CRC64();
            byte[] buff = new byte[8192];
            while ((readLen = inputStream.read(buff)) != -1) {
                crc64.update(buff, readLen);
            }
            return crc64.getValue();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static long getCRC64(InputStream inputStream, long skip, long size) {
        try {
            int readLen;
            long remainLength;
            long skipNumber = inputStream.skip(skip);
            if (skipNumber != skip) {
                return -1L;
            }
            CRC64 crc64 = new CRC64();
            byte[] buff = new byte[8192];
            int needSize = (int)Math.min(remainLength, (long)buff.length);
            for (remainLength = size >= 0L ? size : Long.MAX_VALUE; remainLength > 0L && (readLen = inputStream.read(buff, 0, needSize)) != -1; remainLength -= (long)readLen) {
                crc64.update(buff, readLen);
            }
            return crc64.getValue();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    @Nullable
    public static String getCOSMd5(InputStream inputStream, long skip, long size) throws IOException {
        try {
            long remainLength;
            long result;
            for (long skipped = 0L; skipped < skip; skipped += result) {
                result = inputStream.skip(skip - skipped);
                if (result != 0L) continue;
                throw new IOException("Failed to skip requested bytes");
            }
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buff = new byte[8192];
            long l = remainLength = size >= 0L ? size : Long.MAX_VALUE;
            while (remainLength > 0L) {
                int readLen;
                int result2;
                int needSize = (int)Math.min(remainLength, (long)buff.length);
                for (readLen = 0; readLen < needSize; readLen += result2) {
                    result2 = inputStream.read(buff, readLen, needSize - readLen);
                    if (result2 != -1) continue;
                    throw new IOException("Unexpected end of stream");
                }
                messageDigest.update(buff, 0, readLen);
                remainLength -= (long)readLen;
            }
            return "\"" + StringUtils.toHexString(messageDigest.digest()) + "\"";
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Unsupported MD5 algorithm", e);
        }
    }

    public static COSMd5AndReadData getCOSMd5AndReadData(InputStream inputStream, int size) throws IOException {
        try {
            byte[] readData = new byte[size];
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            int readLen = inputStream.read(readData, 0, size);
            if (readLen != -1) {
                if (readLen < size) {
                    return new COSMd5AndReadData("", DigestUtils.subByte(readData, 0, readLen));
                }
                messageDigest.update(readData, 0, readLen);
            }
            return new COSMd5AndReadData("\"" + StringUtils.toHexString(messageDigest.digest()) + "\"", DigestUtils.subByte(readData, 0, readLen));
        }
        catch (IOException e) {
            throw e;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("unSupport Md5 algorithm", e);
        }
    }

    private static byte[] subByte(byte[] b, int off, int length) {
        byte[] b1 = new byte[length];
        System.arraycopy(b, off, b1, 0, length);
        return b1;
    }

    public static String getSha1(String content) throws CosXmlClientException {
        String sha1;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            sha1 = StringUtils.toHexString(messageDigest.digest(content.getBytes(Charset.forName("UTF-8"))));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
        }
        return sha1;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSHA1FromPath(String filePath) throws CosXmlClientException {
        String sha1;
        FileInputStream fileInputStream = null;
        try {
            int len;
            fileInputStream = new FileInputStream(filePath);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[65536];
            while ((len = fileInputStream.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, len);
            }
            sha1 = StringUtils.toHexString(messageDigest.digest());
        }
        catch (FileNotFoundException e) {
            try {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), e);
                catch (IOException e2) {
                    throw new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), e2);
                }
                catch (NoSuchAlgorithmException e3) {
                    throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e3);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        CloseUtil.closeQuietly(fileInputStream);
        return sha1;
    }

    public static String getSHA1FromBytes(byte[] data, int offset, int len) throws CosXmlClientException {
        String sha1;
        if (data == null || len <= 0 || offset < 0) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "data == null | len <= 0 |offset < 0 |offset >= len");
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(data, offset, len);
            sha1 = StringUtils.toHexString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
        }
        catch (OutOfMemoryError e) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
        }
        return sha1;
    }

    public static String getHmacSha1(String content, String key) throws CosXmlClientException {
        String hmacSha1;
        try {
            byte[] byteKey = key.getBytes(Charset.forName("UTF-8"));
            SecretKeySpec hmacKey = new SecretKeySpec(byteKey, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(hmacKey);
            hmacSha1 = StringUtils.toHexString(mac.doFinal(content.getBytes(Charset.forName("UTF-8"))));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
        }
        catch (InvalidKeyException e) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
        }
        return hmacSha1;
    }

    public static String decodeBase64(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return content;
        }
        try {
            return new String(Base64.decode((String)content, (int)0), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return content;
        }
    }

    public static String getBase64(String content) throws CosXmlClientException {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return content;
        }
        try {
            return Base64.encodeToString((byte[])content.getBytes("utf-8"), (int)2);
        }
        catch (UnsupportedEncodingException e) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
        }
    }

    public static String getSecurityBase64(String content) throws CosXmlClientException {
        String base64 = DigestUtils.getBase64(content);
        if (TextUtils.isEmpty((CharSequence)base64)) {
            return base64;
        }
        base64 = base64.replace("+", "-");
        base64 = base64.replace("/", "_");
        return base64;
    }

    public static class COSMd5AndReadData {
        public String md5;
        public byte[] readData;

        public COSMd5AndReadData(String md5, byte[] readData) {
            this.md5 = md5;
            this.readData = readData;
        }
    }
}

