/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.cos.xml.BaseCosXml;
import com.tencent.cos.xml.CosTrackService;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.common.VersionInfo;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.BasePutObjectRequest;
import com.tencent.cos.xml.model.object.BasePutObjectResult;
import com.tencent.cos.xml.model.object.GetObjectBytesRequest;
import com.tencent.cos.xml.model.object.GetObjectBytesResult;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectResult;
import com.tencent.cos.xml.model.object.SaveLocalRequest;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.model.object.UploadRequest;
import com.tencent.cos.xml.transfer.ResponseBytesConverter;
import com.tencent.cos.xml.transfer.ResponseFileBodySerializer;
import com.tencent.cos.xml.transfer.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.utils.StringUtils;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudSelfSigner;
import com.tencent.qcloud.core.auth.QCloudSigner;
import com.tencent.qcloud.core.auth.ScopeLimitCredentialProvider;
import com.tencent.qcloud.core.auth.SignerFactory;
import com.tencent.qcloud.core.auth.StaticCredentialProvider;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudResultListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.http.NetworkClient;
import com.tencent.qcloud.core.http.OkHttpClientImpl;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.qcloud.core.http.QCloudHttpRetryHandler;
import com.tencent.qcloud.core.logger.COSLogger;
import com.tencent.qcloud.core.task.QCloudTask;
import com.tencent.qcloud.core.task.RetryStrategy;
import com.tencent.qcloud.core.task.TaskExecutors;
import com.tencent.qcloud.core.util.ContextHolder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import okhttp3.HttpUrl;

public class CosXmlBaseService
implements BaseCosXml {
    private static final String TAG = "CosXmlBaseService";
    public static boolean IS_CLOSE_REPORT;
    public static String BRIDGE;
    protected volatile QCloudHttpClient client;
    protected QCloudCredentialProvider credentialProvider;
    protected String tag = "CosXml";
    protected String signerType = "CosXmlSigner";
    protected CosXmlServiceConfig config;
    public static String appCachePath;
    protected String requestDomain;
    protected QCloudSelfSigner selfSigner;

    public CosXmlBaseService(Context context, CosXmlServiceConfig configuration, QCloudCredentialProvider qCloudCredentialProvider) {
        this(context, configuration);
        this.credentialProvider = qCloudCredentialProvider;
    }

    public CosXmlBaseService(Context context, CosXmlServiceConfig configuration) {
        ContextHolder.setContext((Context)context);
        COSLogger.enableLogcat((boolean)configuration.isDebuggable());
        COSLogger.enableLogFile((boolean)configuration.isDebuggable());
        CosTrackService.init(context.getApplicationContext(), IS_CLOSE_REPORT, BRIDGE);
        appCachePath = context.getApplicationContext().getFilesDir().getPath();
        TaskExecutors.initExecutor((int)configuration.getUploadMaxThreadCount(), (int)configuration.getDownloadMaxThreadCount());
        this.setNetworkClient(configuration);
    }

    public QCloudCredentialProvider getCredentialProvider() {
        return this.credentialProvider;
    }

    public CosXmlBaseService(Context context, CosXmlServiceConfig configuration, QCloudSigner qCloudSigner) {
        this(context, configuration);
        this.credentialProvider = new StaticCredentialProvider(null);
        this.signerType = "UserCosXmlSigner";
        SignerFactory.registerSigner((String)this.signerType, (QCloudSigner)qCloudSigner);
    }

    public CosXmlBaseService(Context context, CosXmlServiceConfig configuration, QCloudSelfSigner selfSigner) {
        this(context, configuration);
        this.selfSigner = selfSigner;
    }

    protected String signerTypeCompat(String signerType, CosXmlRequest cosXmlRequest) {
        return signerType;
    }

    private void init(QCloudHttpClient.Builder builder, CosXmlServiceConfig configuration) {
        QCloudHttpRetryHandler qCloudHttpRetryHandler;
        builder.setConnectionTimeout(configuration.getConnectionTimeout()).setSocketTimeout(configuration.getSocketTimeout());
        RetryStrategy retryStrategy = configuration.getRetryStrategy();
        if (retryStrategy != null) {
            builder.setRetryStrategy(retryStrategy);
        }
        if ((qCloudHttpRetryHandler = configuration.getQCloudHttpRetryHandler()) != null) {
            builder.setQCloudHttpRetryHandler(qCloudHttpRetryHandler);
        }
        if (configuration.getCustomizeNetworkClient() != null) {
            builder.setNetworkClient(configuration.getCustomizeNetworkClient());
        } else if (configuration.isEnableQuic()) {
            try {
                Class<?> clazz = Class.forName("com.tencent.qcloud.quic.QuicClientImpl");
                builder.setNetworkClient((NetworkClient)clazz.newInstance());
            }
            catch (Exception e) {
                IllegalStateException illegalStateException = new IllegalStateException(e.getMessage(), e);
                CosTrackService.getInstance().reportError(TAG, illegalStateException);
                throw illegalStateException;
            }
        } else {
            builder.setNetworkClient((NetworkClient)new OkHttpClientImpl());
        }
        builder.dnsCache(configuration.isDnsCache());
        builder.addPrefetchHost(configuration.getEndpointSuffix());
        builder.setVerifySSLEnable(configuration.isVerifySSLEnable());
        builder.setClientCertificate(configuration.getClientCertificateBytes(), configuration.getClientCertificatePassword());
        builder.setRedirectEnable(configuration.isRedirectEnable());
    }

    public void setNetworkClient(CosXmlServiceConfig configuration) {
        QCloudHttpClient.Builder builder = new QCloudHttpClient.Builder();
        this.init(builder, configuration);
        this.client = builder.build();
        this.client.setNetworkClientType(builder);
        this.config = configuration;
        this.client.addVerifiedHost("*." + configuration.getEndpointSuffix());
        this.client.addVerifiedHost("*." + configuration.getEndpointSuffix(configuration.getRegion(), true));
    }

    public void addCustomerDNS(String domainName, String[] ipList) throws CosXmlClientException {
        try {
            this.client.addDnsRecord(domainName, ipList);
        }
        catch (UnknownHostException e) {
            throw new CosXmlClientException(ClientErrorCode.POOR_NETWORK.getCode(), e);
        }
    }

    public void addCustomerDNSFetch(@NonNull QCloudHttpClient.QCloudDnsFetch dnsFetch) {
        this.client.addDnsFetch(dnsFetch);
    }

    @Deprecated
    public void addVerifiedHost(String hostName) {
        this.client.addVerifiedHost(hostName);
    }

    public void setDomain(String domain) {
        this.requestDomain = domain;
    }

    protected String getRequestHost(CosXmlRequest request) throws CosXmlClientException {
        if (!TextUtils.isEmpty((CharSequence)request.getHost())) {
            return request.getHost();
        }
        if (!TextUtils.isEmpty((CharSequence)this.requestDomain)) {
            return this.requestDomain;
        }
        return request.getRequestHost(this.config);
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> QCloudHttpRequest buildHttpRequest(T1 cosXmlRequest, T2 cosXmlResult, boolean isNetworkSwitch, String networkClientType) throws CosXmlClientException {
        QCloudHttpRequest.Builder httpRequestBuilder = new QCloudHttpRequest.Builder().method(cosXmlRequest.getMethod()).userAgent(this.getUserAgent(networkClientType)).tag((Object)this.tag);
        httpRequestBuilder.addNoSignHeaderKeys(this.config.getNoSignHeaders());
        httpRequestBuilder.addNoSignHeaderKeys(cosXmlRequest.getNoSignHeaders());
        httpRequestBuilder.addNoSignParamKeys(cosXmlRequest.getNoSignParams());
        String requestURL = cosXmlRequest.getRequestURL();
        String host = this.getRequestHost(cosXmlRequest);
        if (TextUtils.isEmpty((CharSequence)cosXmlRequest.getHost())) {
            if (this.config.networkSwitchStrategy() == CosXmlServiceConfig.RequestNetworkStrategy.Aggressive) {
                if (isNetworkSwitch) {
                    host = this.config.getDefaultRequestHost(cosXmlRequest.getRegion(), cosXmlRequest.getBucket());
                }
            } else if (this.config.networkSwitchStrategy() == CosXmlServiceConfig.RequestNetworkStrategy.Conservative && !isNetworkSwitch) {
                host = this.config.getDefaultRequestHost(cosXmlRequest.getRegion(), cosXmlRequest.getBucket());
            }
        }
        if (requestURL != null) {
            try {
                httpRequestBuilder.url(new URL(requestURL));
            }
            catch (MalformedURLException e) {
                throw new CosXmlClientException(ClientErrorCode.BAD_REQUEST.getCode(), e);
            }
        } else {
            cosXmlRequest.checkParameters();
            httpRequestBuilder.scheme(this.config.getProtocol()).host(host).path(cosXmlRequest.getPath(this.config));
            if (this.config.getPort() != -1) {
                httpRequestBuilder.port(this.config.getPort());
            }
            httpRequestBuilder.query(cosXmlRequest.getQueryString());
            if (cosXmlRequest.getQueryEncodedString() != null) {
                httpRequestBuilder.encodedQuery(cosXmlRequest.getQueryEncodedString());
            }
        }
        this.setCopySource(cosXmlRequest);
        HashSet<String> headerKeys = new HashSet<String>();
        headerKeys.addAll(this.config.getCommonHeaders().keySet());
        headerKeys.addAll(cosXmlRequest.getRequestHeaders().keySet());
        HashMap<String, List<String>> extraHeaders = new HashMap<String, List<String>>();
        for (String headerKey : headerKeys) {
            List<String> headerValue = cosXmlRequest.getRequestHeaders().get(headerKey);
            if (headerValue == null) {
                headerValue = this.config.getCommonHeaders().get(headerKey);
            }
            if (headerValue == null) continue;
            extraHeaders.put(headerKey, headerValue);
        }
        if (!extraHeaders.containsKey("Host")) {
            LinkedList<String> hostHeaderValue = new LinkedList<String>();
            hostHeaderValue.add(host);
            extraHeaders.put("Host", hostHeaderValue);
        }
        if (cosXmlRequest.headersHasUnsafeNonAscii()) {
            httpRequestBuilder.addHeadersUnsafeNonAscii(extraHeaders);
        } else {
            httpRequestBuilder.addHeaders(extraHeaders);
        }
        if (cosXmlRequest.isNeedMD5()) {
            httpRequestBuilder.contentMD5();
        }
        httpRequestBuilder.setKeyTime(cosXmlRequest.getKeyTime());
        if (this.credentialProvider == null) {
            if (cosXmlRequest.getCredentialProvider() != null) {
                httpRequestBuilder.signer(this.signerTypeCompat(this.signerType, cosXmlRequest), cosXmlRequest.getSignSourceProvider());
            } else {
                httpRequestBuilder.signer(null, null);
            }
        } else {
            httpRequestBuilder.signer(this.signerTypeCompat(this.signerType, cosXmlRequest), cosXmlRequest.getSignSourceProvider());
        }
        if (this.selfSigner != null) {
            httpRequestBuilder.selfSigner(this.selfSigner);
        }
        httpRequestBuilder.credentialScope(cosXmlRequest.getSTSCredentialScope(this.config));
        if (cosXmlRequest.getRequestBody() != null) {
            httpRequestBuilder.body(cosXmlRequest.getRequestBody());
        }
        if (cosXmlRequest instanceof SaveLocalRequest) {
            SaveLocalRequest saveLocalRequest = (SaveLocalRequest)((Object)cosXmlRequest);
            if (!TextUtils.isEmpty((CharSequence)saveLocalRequest.getSaveLocalPath())) {
                httpRequestBuilder.converter(new ResponseFileBodySerializer((GetObjectResult)cosXmlResult, saveLocalRequest.getSaveLocalPath(), saveLocalRequest.getSaveLocalOffset()));
            } else if (saveLocalRequest.getSaveLocalUri() != null) {
                httpRequestBuilder.converter(new ResponseFileBodySerializer((GetObjectResult)cosXmlResult, saveLocalRequest.getSaveLocalUri(), ContextHolder.getAppContext().getContentResolver(), saveLocalRequest.getSaveLocalOffset()));
            }
        } else if (cosXmlRequest instanceof GetObjectBytesRequest) {
            httpRequestBuilder.converter(new ResponseBytesConverter((GetObjectBytesResult)cosXmlResult));
        } else if (!this.buildHttpRequestBodyConverter(cosXmlRequest, cosXmlResult, httpRequestBuilder)) {
            httpRequestBuilder.converter(new ResponseXmlS3BodySerializer(cosXmlResult));
        }
        httpRequestBuilder.signInUrl(cosXmlRequest.isSignInUrl() || this.config.isSignInUrl());
        QCloudHttpRequest httpRequest = httpRequestBuilder.build();
        return httpRequest;
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> boolean buildHttpRequestBodyConverter(T1 cosXmlRequest, T2 cosXmlResult, QCloudHttpRequest.Builder<T2> httpRequestBuilder) {
        return false;
    }

    private <T1 extends CosXmlRequest, T2 extends CosXmlResult> HttpTask buildHttpTask(T1 cosXmlRequest, T2 cosXmlResult, boolean isNetworkSwitch) throws CosXmlClientException {
        if (TextUtils.isEmpty((CharSequence)cosXmlRequest.getClientTraceId())) {
            cosXmlRequest.setClientTraceId(UUID.randomUUID().toString());
        }
        if (TextUtils.isEmpty((CharSequence)cosXmlRequest.getRegion()) && this.config != null) {
            cosXmlRequest.setRegion(this.config.getRegion());
        }
        if (cosXmlRequest.getMetrics() == null) {
            cosXmlRequest.attachMetrics(new HttpTaskMetrics());
        }
        String networkClientType = null;
        if (this.config.getCustomizeNetworkClient() != null) {
            networkClientType = this.config.getCustomizeNetworkClient().getClass().getName();
        } else if (this.config.isEnableQuic()) {
            if (cosXmlRequest.getNetworkType() == null) {
                if (this.config.networkSwitchStrategy() == CosXmlServiceConfig.RequestNetworkStrategy.Aggressive) {
                    networkClientType = isNetworkSwitch ? OkHttpClientImpl.class.getName() : "com.tencent.qcloud.quic.QuicClientImpl";
                } else if (this.config.networkSwitchStrategy() == CosXmlServiceConfig.RequestNetworkStrategy.Conservative) {
                    networkClientType = isNetworkSwitch ? "com.tencent.qcloud.quic.QuicClientImpl" : OkHttpClientImpl.class.getName();
                }
            } else if (cosXmlRequest.getNetworkType() == CosXmlRequest.RequestNetworkType.OKHTTP) {
                networkClientType = OkHttpClientImpl.class.getName();
            } else if (cosXmlRequest.getNetworkType() == CosXmlRequest.RequestNetworkType.QUIC) {
                networkClientType = "com.tencent.qcloud.quic.QuicClientImpl";
            }
        } else {
            networkClientType = OkHttpClientImpl.class.getName();
        }
        QCloudHttpRequest httpRequest = this.buildHttpRequest(cosXmlRequest, cosXmlResult, isNetworkSwitch, networkClientType);
        HttpTask httpTask = cosXmlRequest.getCredentialProvider() != null ? this.client.resolveRequest(httpRequest, cosXmlRequest.getCredentialProvider(), networkClientType) : this.client.resolveRequest(httpRequest, this.credentialProvider, networkClientType);
        httpTask.setTransferThreadControl(this.config.isTransferThreadControl());
        httpTask.setUploadMaxThreadCount(this.config.getUploadMaxThreadCount());
        httpTask.setDownloadMaxThreadCount(this.config.getDownloadMaxThreadCount());
        httpTask.setDomainSwitch(this.config.isDomainSwitch());
        cosXmlRequest.setTask(httpTask);
        return httpTask;
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> T2 execute(T1 cosXmlRequest, T2 cosXmlResult) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(cosXmlRequest, cosXmlResult, false);
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> T2 execute(T1 cosXmlRequest, T2 cosXmlResult, boolean internal) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(cosXmlRequest, cosXmlResult, internal, false);
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> T2 execute(T1 cosXmlRequest, T2 cosXmlResult, boolean internal, boolean isNetworkSwitch) throws CosXmlClientException, CosXmlServiceException {
        try {
            HttpTask httpTask = this.buildHttpTask(cosXmlRequest, cosXmlResult, isNetworkSwitch);
            this.setProgressListener(cosXmlRequest, httpTask, false);
            HttpResult httpResult = (HttpResult)httpTask.executeNow();
            CosTrackService.getInstance().reportRequestSuccess(cosXmlRequest, internal, this.config.getTrackParams());
            CosTrackService.getInstance().reportHttpMetrics(cosXmlRequest);
            this.logRequestMetrics(cosXmlRequest);
            return (T2)(httpResult != null ? (CosXmlResult)httpResult.content() : null);
        }
        catch (QCloudServiceException e) {
            CosTrackService.getInstance().reportHttpMetrics(cosXmlRequest);
            CosXmlServiceException cosXmlServiceException = CosTrackService.getInstance().convertServerException(e);
            if (this.config.networkSwitchStrategy() != null && !isNetworkSwitch && ("RequestTimeout".equals(cosXmlServiceException.getErrorCode()) || "UserNetworkTooSlow".equals(cosXmlServiceException.getErrorCode()))) {
                return this.execute(cosXmlRequest, cosXmlResult, internal, true);
            }
            throw CosTrackService.getInstance().reportRequestServiceException(cosXmlRequest, e, internal, this.config.getTrackParams());
        }
        catch (QCloudClientException e) {
            CosTrackService.getInstance().reportHttpMetrics(cosXmlRequest);
            CosXmlClientException cosXmlClientException = CosTrackService.getInstance().convertClientException(e);
            if (!(this.config.networkSwitchStrategy() == null || isNetworkSwitch || cosXmlClientException.errorCode != ClientErrorCode.POOR_NETWORK.getCode() && cosXmlClientException.errorCode != ClientErrorCode.IO_ERROR.getCode())) {
                return this.execute(cosXmlRequest, cosXmlResult, internal, true);
            }
            throw CosTrackService.getInstance().reportRequestClientException(cosXmlRequest, e, internal, this.config.getTrackParams());
        }
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> void schedule(T1 cosXmlRequest, T2 cosXmlResult, CosXmlResultListener cosXmlResultListener) {
        this.schedule(cosXmlRequest, cosXmlResult, cosXmlResultListener, false);
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> void schedule(T1 cosXmlRequest, T2 cosXmlResult, CosXmlResultListener cosXmlResultListener, boolean internal) {
        this.schedule(cosXmlRequest, cosXmlResult, cosXmlResultListener, internal, false);
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> void schedule(final T1 cosXmlRequest, final T2 cosXmlResult, final CosXmlResultListener cosXmlResultListener, final boolean internal, final boolean isNetworkSwitch) {
        QCloudResultListener qCloudResultListener = new QCloudResultListener<HttpResult<T2>>(){

            public void onSuccess(HttpResult<T2> result) {
                CosTrackService.getInstance().reportRequestSuccess(cosXmlRequest, internal, CosXmlBaseService.this.config.getTrackParams());
                CosTrackService.getInstance().reportHttpMetrics(cosXmlRequest);
                CosXmlBaseService.this.logRequestMetrics(cosXmlRequest);
                cosXmlResultListener.onSuccess(cosXmlRequest, (CosXmlResult)result.content());
            }

            public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
                CosTrackService.getInstance().reportHttpMetrics(cosXmlRequest);
                CosXmlBaseService.this.logRequestMetrics(cosXmlRequest);
                if (clientException != null) {
                    CosXmlClientException xmlClientException = CosTrackService.getInstance().convertClientException(clientException);
                    if (!(CosXmlBaseService.this.config.networkSwitchStrategy() == null || isNetworkSwitch || xmlClientException.errorCode != ClientErrorCode.POOR_NETWORK.getCode() && xmlClientException.errorCode != ClientErrorCode.IO_ERROR.getCode())) {
                        CosXmlBaseService.this.schedule(cosXmlRequest, cosXmlResult, cosXmlResultListener, internal, true);
                    }
                    cosXmlResultListener.onFail(cosXmlRequest, CosTrackService.getInstance().reportRequestClientException(cosXmlRequest, clientException, internal, CosXmlBaseService.this.config.getTrackParams()), null);
                } else if (serviceException != null) {
                    CosXmlServiceException xmlServiceException = CosTrackService.getInstance().convertServerException(serviceException);
                    if (CosXmlBaseService.this.config.networkSwitchStrategy() != null && !isNetworkSwitch && ("RequestTimeout".equals(xmlServiceException.getErrorCode()) || "UserNetworkTooSlow".equals(xmlServiceException.getErrorCode()))) {
                        CosXmlBaseService.this.schedule(cosXmlRequest, cosXmlResult, cosXmlResultListener, internal, true);
                    }
                    cosXmlResultListener.onFail(cosXmlRequest, null, CosTrackService.getInstance().reportRequestServiceException(cosXmlRequest, serviceException, internal, CosXmlBaseService.this.config.getTrackParams()));
                }
            }
        };
        try {
            HttpTask httpTask = this.buildHttpTask(cosXmlRequest, cosXmlResult, isNetworkSwitch);
            this.setProgressListener(cosXmlRequest, httpTask, true);
            Executor executor = this.config.getExecutor();
            Executor observeExecutor = this.config.getObserveExecutor();
            if (observeExecutor != null) {
                httpTask.observeOn(observeExecutor);
            }
            httpTask.addResultListener(qCloudResultListener);
            if (executor != null) {
                httpTask.scheduleOn(executor);
            } else if (cosXmlRequest instanceof UploadRequest) {
                httpTask.scheduleOn((Executor)TaskExecutors.UPLOAD_EXECUTOR, cosXmlRequest.getPriority());
            } else {
                httpTask.schedule();
            }
        }
        catch (QCloudClientException e) {
            CosXmlClientException clientException = CosTrackService.getInstance().convertClientException(e);
            if (!(this.config.networkSwitchStrategy() == null || isNetworkSwitch || clientException.errorCode != ClientErrorCode.POOR_NETWORK.getCode() && clientException.errorCode != ClientErrorCode.IO_ERROR.getCode())) {
                this.schedule(cosXmlRequest, cosXmlResult, cosXmlResultListener, internal, true);
            }
            cosXmlResultListener.onFail(cosXmlRequest, CosTrackService.getInstance().reportRequestClientException(cosXmlRequest, e, internal, this.config.getTrackParams()), null);
        }
    }

    protected <T1 extends CosXmlRequest> void setCopySource(T1 cosXmlRequest) throws CosXmlClientException {
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> void setProgressListener(final T1 cosXmlRequest, HttpTask<T2> httpTask, boolean isSchedule) {
        if (cosXmlRequest instanceof BasePutObjectRequest) {
            httpTask.addProgressListener((QCloudProgressListener)((BasePutObjectRequest)cosXmlRequest).getProgressListener());
        } else if (cosXmlRequest instanceof UploadPartRequest) {
            httpTask.addProgressListener((QCloudProgressListener)((UploadPartRequest)cosXmlRequest).getProgressListener());
            if (isSchedule) {
                httpTask.setOnRequestWeightListener(new QCloudTask.OnRequestWeightListener(){

                    public int onWeight() {
                        return cosXmlRequest.getWeight();
                    }
                });
            }
        } else if (cosXmlRequest instanceof GetObjectRequest) {
            httpTask.addProgressListener((QCloudProgressListener)((GetObjectRequest)cosXmlRequest).getProgressListener());
        }
    }

    public String getAccessUrl(CosXmlRequest cosXmlRequest) {
        String requestURL = cosXmlRequest.getRequestURL();
        if (requestURL != null) {
            int index = requestURL.indexOf("?");
            return index > 0 ? requestURL.substring(0, index) : requestURL;
        }
        HttpUrl.Builder httpUrlBuilder = new HttpUrl.Builder();
        httpUrlBuilder.scheme(this.config.getProtocol());
        String host = null;
        try {
            host = this.getRequestHost(cosXmlRequest);
        }
        catch (CosXmlClientException e) {
            CosTrackService.getInstance().reportError(TAG, (Exception)((Object)e));
            e.printStackTrace();
        }
        httpUrlBuilder.host(host);
        String path = cosXmlRequest.getPath(this.config);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.length() > 0) {
            httpUrlBuilder.addPathSegments(path);
        }
        return httpUrlBuilder.build().toString();
    }

    public String getPresignedURL(CosXmlRequest cosXmlRequest) throws CosXmlClientException {
        try {
            Object credentials = cosXmlRequest.getCredentialProvider() != null ? cosXmlRequest.getCredentialProvider().getCredentials() : (this.credentialProvider instanceof ScopeLimitCredentialProvider ? ((ScopeLimitCredentialProvider)this.credentialProvider).getCredentials(cosXmlRequest.getSTSCredentialScope(this.config)) : this.credentialProvider.getCredentials());
            QCloudSigner signer = SignerFactory.getSigner((String)this.signerTypeCompat(this.signerType, cosXmlRequest));
            QCloudHttpRequest request = this.buildHttpRequest(cosXmlRequest, null, false, null);
            signer.sign(request, credentials);
            String sign = request.header("Authorization");
            String token = request.header("x-cos-security-token");
            if (!TextUtils.isEmpty((CharSequence)token)) {
                sign = sign + "&x-cos-security-token=" + token;
            }
            String url = this.getAccessUrl(cosXmlRequest);
            String query = StringUtils.flat(cosXmlRequest.getQueryString());
            return TextUtils.isEmpty((CharSequence)query) ? url + "?" + sign : url + "?" + query + "&" + sign;
        }
        catch (QCloudClientException e) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_CREDENTIALS.getCode(), e);
        }
    }

    @Override
    public GetObjectResult getObject(GetObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new GetObjectResult());
    }

    @Override
    public void getObjectAsync(GetObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetObjectResult(), cosXmlResultListener);
    }

    public void internalGetObjectAsync(GetObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetObjectResult(), cosXmlResultListener, true);
    }

    @Override
    public byte[] getObject(String bucketName, String objectName) throws CosXmlClientException, CosXmlServiceException {
        GetObjectBytesRequest getObjectBytesRequest = new GetObjectBytesRequest(bucketName, objectName);
        GetObjectBytesResult getObjectBytesResult = this.execute(getObjectBytesRequest, new GetObjectBytesResult());
        return getObjectBytesResult != null ? getObjectBytesResult.data : new byte[]{};
    }

    @Override
    public byte[] getObject(GetObjectBytesRequest request) throws CosXmlClientException, CosXmlServiceException {
        GetObjectBytesResult getObjectBytesResult = this.execute(request, new GetObjectBytesResult());
        return getObjectBytesResult != null ? getObjectBytesResult.data : new byte[]{};
    }

    @Override
    public BasePutObjectResult basePutObject(BasePutObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        BasePutObjectResult basePutObjectResult = new BasePutObjectResult();
        basePutObjectResult.accessUrl = this.getAccessUrl(request);
        return this.execute(request, basePutObjectResult);
    }

    @Override
    public void basePutObjectAsync(BasePutObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        BasePutObjectResult basePutObjectResult = new BasePutObjectResult();
        basePutObjectResult.accessUrl = this.getAccessUrl(request);
        this.schedule(request, basePutObjectResult, cosXmlResultListener);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new UploadPartResult());
    }

    @Override
    public void uploadPartAsync(UploadPartRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new UploadPartResult(), cosXmlResultListener);
    }

    @Override
    public String getObjectUrl(String bucket, String region, String key) {
        BasePutObjectRequest putObjectRequest = new BasePutObjectRequest(bucket, key, "");
        putObjectRequest.setRegion(region);
        return this.getAccessUrl(putObjectRequest);
    }

    @Override
    public <T1 extends CosXmlRequest, T2 extends CosXmlResult> T2 commonInterface(T1 request, Class<T2> resultClass) throws CosXmlClientException, CosXmlServiceException {
        try {
            return (T2)this.execute(request, (CosXmlResult)resultClass.newInstance());
        }
        catch (IllegalAccessException e) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "Failed to create result instance", e);
        }
        catch (InstantiationException e) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "Failed to create result instance", e);
        }
    }

    @Override
    public <T1 extends CosXmlRequest, T2 extends CosXmlResult> void commonInterfaceAsync(T1 request, Class<T2> resultClass, CosXmlResultListener cosXmlResultListener) {
        try {
            this.schedule(request, (CosXmlResult)resultClass.newInstance(), cosXmlResultListener);
        }
        catch (IllegalAccessException e) {
            cosXmlResultListener.onFail(request, new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "Failed to create result instance", e), null);
        }
        catch (InstantiationException e) {
            cosXmlResultListener.onFail(request, new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "Failed to create result instance", e), null);
        }
    }

    @Override
    public void cancel(CosXmlRequest cosXmlRequest) {
        if (cosXmlRequest != null && cosXmlRequest.getHttpTask() != null) {
            cosXmlRequest.getHttpTask().cancel();
        }
    }

    @Override
    public void cancel(CosXmlRequest cosXmlRequest, boolean now) {
        if (cosXmlRequest != null && cosXmlRequest.getHttpTask() != null) {
            cosXmlRequest.getHttpTask().cancel(now);
        }
    }

    @Override
    public void cancelAll() {
        List tasks = this.client.getTasksByTag(this.tag);
        for (HttpTask task : tasks) {
            task.cancel();
        }
    }

    @Override
    public void release() {
        this.cancelAll();
    }

    @Deprecated
    public String getAppid() {
        return this.config.getAppid();
    }

    @Deprecated
    public String getRegion() {
        return this.config.getRegion();
    }

    @Deprecated
    public String getRegion(CosXmlRequest cosXmlRequest) {
        return cosXmlRequest.getRegion() == null ? this.config.getRegion() : cosXmlRequest.getRegion();
    }

    public CosXmlServiceConfig getConfig() {
        return this.config;
    }

    public String getUserAgent(@Nullable String networkClientType) {
        if (this.config == null) {
            return VersionInfo.getUserAgent();
        }
        String userAgent = this.config.isEnableQuic() ? (OkHttpClientImpl.class.getName().equals(networkClientType) ? VersionInfo.getUserAgent() : ("com.tencent.qcloud.quic.QuicClientImpl".equals(networkClientType) ? VersionInfo.getQuicUserAgent() : VersionInfo.getQuicUserAgent())) : VersionInfo.getUserAgent();
        if (TextUtils.isEmpty((CharSequence)this.config.getUserAgentExtended())) {
            return userAgent;
        }
        return userAgent + "-" + this.config.getUserAgentExtended();
    }

    public File[] getLogFiles(int limit) {
        return COSLogger.getLogFiles((int)limit);
    }

    private void logRequestMetrics(CosXmlRequest cosXmlRequest) {
        if (cosXmlRequest.getMetrics() != null) {
            COSLogger.iNetwork((String)"QCloudHttp", (String)cosXmlRequest.getMetrics().toString());
        }
    }
}

