/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import com.tencent.cos.xml.CosTrackService;
import com.tencent.qcloud.core.logger.COSLogger;
import com.tencent.qcloud.network.sonar.NetworkSonar;
import com.tencent.qcloud.network.sonar.NetworkSonarCallback;
import com.tencent.qcloud.network.sonar.SonarRequest;
import com.tencent.qcloud.network.sonar.SonarResult;
import com.tencent.qcloud.network.sonar.SonarType;
import com.tencent.qcloud.network.sonar.dns.DnsResult;
import com.tencent.qcloud.network.sonar.ping.PingResult;
import com.tencent.qcloud.network.sonar.traceroute.TracerouteResult;
import com.tencent.qcloud.track.QCloudTrackService;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CosTrackSonarService {
    private static final String TAG = "CosTrackSonarService";
    private Context applicationContext;
    private final ScheduledExecutorService sonarScheduler = Executors.newScheduledThreadPool(1);

    public void setContext(Context context) {
        this.applicationContext = context;
    }

    public static boolean isIncludeSonar() {
        try {
            Class.forName("com.tencent.qcloud.network.sonar.NetworkSonar");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void periodicSonar() {
        Runnable sonar = () -> {
            CosTrackService.SonarHost sonarHost = CosTrackService.getInstance().getSonarHosts().get();
            if (sonarHost == null || sonarHost.getHost() == null) {
                return;
            }
            long diffInMinutes = (System.currentTimeMillis() - CosTrackService.getInstance().getSonarHosts().getSonarHostsAddTimestamp()) / 60000L;
            if (diffInMinutes > 15L) {
                return;
            }
            HashMap<String, String> extra = new HashMap<String, String>();
            extra.put("region", sonarHost.getRegion());
            extra.put("bucket", sonarHost.getBucket());
            this.sonar("qcloud_track_cos_sdk_sonar", sonarHost.getHost(), extra, true);
        };
        this.sonarScheduler.scheduleWithFixedDelay(sonar, 3L, 10L, TimeUnit.MINUTES);
    }

    public void failSonar(String host, String region, String bucket, String clientTraceId) {
        if (host == null) {
            return;
        }
        HashMap<String, String> extra = new HashMap<String, String>();
        extra.put("region", region);
        extra.put("bucket", bucket);
        extra.put("client_trace_id", clientTraceId);
        this.sonar("qcloud_track_cos_sdk_sonar_failure", host, extra, false);
    }

    private void sonar(final String eventCode, String host, Map<String, String> extra, final boolean periodic) {
        if (CosTrackService.getInstance().isCloseReport() || !CosTrackSonarService.isIncludeSonar()) {
            return;
        }
        try {
            SonarRequest sonarRequest;
            final HashMap<String, String> params = new HashMap<String, String>(extra);
            params.put("host", host);
            ArrayList<SonarType> types = new ArrayList<SonarType>();
            if (periodic) {
                types.add(SonarType.PING);
                long startTime = System.currentTimeMillis();
                InetAddress address = InetAddress.getByName(host);
                String dnsIp = address.getHostAddress();
                params.put("dns_ip", dnsIp);
                params.put("dns_lookupTime", String.valueOf(System.currentTimeMillis() - startTime));
                sonarRequest = new SonarRequest(host, dnsIp);
            } else {
                types.add(SonarType.DNS);
                types.add(SonarType.PING);
                types.add(SonarType.TRACEROUTE);
                sonarRequest = new SonarRequest(host);
            }
            NetworkSonar.sonar((Context)this.applicationContext, (SonarRequest)sonarRequest, types, (NetworkSonarCallback)new NetworkSonarCallback(){

                public void onStart(SonarType type) {
                }

                public void onSuccess(SonarResult result) {
                }

                public void onFail(SonarResult result) {
                }

                public void onFinish(List<SonarResult> results) {
                    if (results != null && !results.isEmpty()) {
                        for (SonarResult sonarResult : results) {
                            if (sonarResult == null || !sonarResult.isSuccess() || sonarResult.getResult() == null) continue;
                            switch (sonarResult.getType()) {
                                case DNS: {
                                    DnsResult dnsResult = (DnsResult)sonarResult.getResult();
                                    params.put("dns_ip", dnsResult.ip);
                                    params.put("dns_lookupTime", String.valueOf(dnsResult.lookupTime));
                                    params.put("dns_a", dnsResult.a);
                                    params.put("dns_cname", dnsResult.cname);
                                    params.put("dns_result", dnsResult.response);
                                    break;
                                }
                                case PING: {
                                    PingResult pingResult = (PingResult)sonarResult.getResult();
                                    params.put("ping_ip", pingResult.ip);
                                    params.put("ping_size", String.valueOf(pingResult.size));
                                    params.put("ping_interval", String.valueOf(pingResult.interval));
                                    params.put("ping_count", String.valueOf(pingResult.count));
                                    params.put("ping_loss", String.valueOf(pingResult.getLoss()));
                                    params.put("ping_response_num", String.valueOf(pingResult.getResponseNum()));
                                    params.put("ping_avg", String.valueOf(pingResult.avg));
                                    params.put("ping_max", String.valueOf(pingResult.max));
                                    params.put("ping_min", String.valueOf(pingResult.min));
                                    params.put("ping_stddev", String.valueOf(pingResult.stddev));
                                    break;
                                }
                                case TRACEROUTE: {
                                    TracerouteResult tracerouteResult = (TracerouteResult)sonarResult.getResult();
                                    params.put("traceroute_ip", tracerouteResult.getTargetIp());
                                    params.put("traceroute_status", tracerouteResult.getCommandStatus().getName());
                                    params.put("traceroute_hop_count", String.valueOf(tracerouteResult.getHopCount()));
                                    params.put("traceroute_total_delay", String.valueOf(tracerouteResult.getTotalDelay()));
                                    params.put("traceroute_avg_loss_rate", String.valueOf(tracerouteResult.getLossRate()));
                                    params.put("traceroute_nodes", tracerouteResult.getNodeResultsString());
                                }
                            }
                        }
                        if (params.containsKey("dns_ip") || params.containsKey("ping_ip") || params.containsKey("traceroute_ip")) {
                            QCloudTrackService.getInstance().report(eventCode, params);
                            if (!periodic) {
                                COSLogger.iProbe((String)"FailSonar", (String)params.toString());
                            }
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

