/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class CloudControl {
    private static final String TAG = "CloudControl";
    public final ThreadPoolExecutor CLOUD_CONTROL_EXECUTOR = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE));
    private final Handler handler;
    private static volatile CloudControl instance;
    private final String BEACON_CLOUD_URL = "https://cos-android-sdk-doc-1253960454.cos.ap-shanghai.myqcloud.com/beacon_cc/android/";
    private final String BEACON_CLOUD_APPKEY = "appKey";

    private CloudControl() {
        this.CLOUD_CONTROL_EXECUTOR.allowCoreThreadTimeOut(true);
        this.handler = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CloudControl getInstance() {
        if (instance != null) return instance;
        Class<CloudControl> clazz = CloudControl.class;
        synchronized (CloudControl.class) {
            if (instance != null) return instance;
            instance = new CloudControl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void getBeaconAppKey(String packageName, BeaconCloudCallback callback) {
        this.CLOUD_CONTROL_EXECUTOR.execute(() -> {
            String beaconKey;
            try {
                StringBuilder sb;
                URL url = new URL("https://cos-android-sdk-doc-1253960454.cos.ap-shanghai.myqcloud.com/beacon_cc/android/" + packageName);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.connect();
                int responseCode = conn.getResponseCode();
                if (responseCode >= 200 && responseCode < 300) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                } else {
                    this.handler.post(() -> callback.onError(new IllegalStateException("getBeaconAppKey failure:" + responseCode)));
                    return;
                }
                beaconKey = new JSONObject(sb.toString()).getString("appKey");
            }
            catch (Exception e) {
                this.handler.post(() -> callback.onError(e));
                return;
            }
            String finalBeaconKey = beaconKey;
            Log.d((String)TAG, (String)("getBeaconAppKey onSuccess:" + beaconKey));
            this.handler.post(() -> callback.onSuccess(finalBeaconKey));
        });
    }

    static interface BeaconCloudCallback {
        public void onSuccess(String var1);

        public void onError(Exception var1);
    }
}

