/*
 * Decompiled with CFR 0.152.
 */
package com.example.networklibrary.views;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.design.R;
import android.support.design.widget.Snackbar;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

public class CustomSnackbar {
    private static final String TAG = CustomSnackbar.class.getSimpleName();
    private Context context;
    private Snackbar snackbar;
    private TextView messageView;

    public CustomSnackbar(Context context, View rootView) {
        this.context = context.getApplicationContext();
        this.snackbar = Snackbar.make((View)rootView, (CharSequence)"", (int)0);
        View snackbarView = this.snackbar.getView();
        this.messageView = (TextView)snackbarView.findViewById(R.id.snackbar_text);
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.messageView.getLayoutParams();
        params.height = -2;
        this.messageView.setMaxLines(999);
    }

    public void setDuration(int duration) {
        this.snackbar.setDuration(duration);
    }

    public void setMessage(String message) {
        this.messageView.setText((CharSequence)message);
    }

    public void setMessage(int messageResId) {
        this.messageView.setText(messageResId);
    }

    public void setMessageColor(int colorResId) {
        this.messageView.setTextColor(ContextCompat.getColor((Context)this.context, (int)colorResId));
    }

    public void setActionColor(int colorResId) {
        this.snackbar.setActionTextColor(ContextCompat.getColor((Context)this.context, (int)colorResId));
    }

    public void setAction(int actionMessageResId, @Nullable View.OnClickListener listener) {
        this.snackbar.setAction(actionMessageResId, listener);
    }

    public void show() {
        this.snackbar.show();
    }

    public void dismiss() {
        this.snackbar.dismiss();
    }

    public boolean isShown() {
        return this.snackbar.isShown();
    }
}

