/*
 * Decompiled with CFR 0.152.
 */
package com.example.networklibrary.network.parsing;

import android.support.annotation.Nullable;
import android.util.Log;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.example.networklibrary.network.parsing.AnnotatedDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.Charset;
import java.util.Map;

public class GsonRequest<T, S>
extends Request<T> {
    private static final String TAG = GsonRequest.class.getSimpleName();
    private final Class<T> clazz;
    private final Map<String, String> headers;
    private final S bodyParams;
    private final Response.Listener<T> listener;

    public GsonRequest(int methodType, String url, S bodyParams, Class<T> clazz, Map<String, String> headers, Response.Listener<T> listener, Response.ErrorListener errorListener) {
        super(methodType, url, errorListener);
        this.clazz = clazz;
        this.bodyParams = bodyParams;
        this.headers = headers;
        this.listener = listener;
        this.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(15000, 0, 1.0f));
    }

    public Map<String, String> getHeaders() throws AuthFailureError {
        return this.headers != null ? this.headers : super.getHeaders();
    }

    public byte[] getBody() throws AuthFailureError {
        String params = null;
        if (this.bodyParams != null) {
            params = new Gson().toJson(this.bodyParams);
        }
        return params != null ? params.getBytes(Charset.forName("UTF-8")) : super.getBody();
    }

    public String getBodyContentType() {
        return "application/json";
    }

    protected void deliverResponse(T response) {
        this.listener.onResponse(response);
    }

    protected Response<T> parseNetworkResponse(NetworkResponse response) {
        try {
            String json = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers)).trim();
            this.logResponse(response.statusCode, json);
            Gson gson = new GsonBuilder().registerTypeAdapter(this.clazz, (Object)new AnnotatedDeserializer<T>(){}).create();
            return Response.success((Object)gson.fromJson(json, this.clazz), (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)response));
        }
        catch (Throwable e) {
            return Response.error((VolleyError)new ParseError(e));
        }
    }

    protected VolleyError parseNetworkError(VolleyError volleyError) {
        String response = null;
        int statusCode = 0;
        try {
            statusCode = volleyError.networkResponse.statusCode;
        }
        catch (Throwable e) {
            statusCode = 0;
        }
        try {
            response = new String(volleyError.networkResponse.data, HttpHeaderParser.parseCharset((Map)volleyError.networkResponse.headers));
        }
        catch (Throwable e) {
            response = null;
        }
        this.logResponse(statusCode, response);
        return super.parseNetworkError(volleyError);
    }

    private void logResponse(@Nullable int statusCode, @Nullable String response) {
        Log.d((String)TAG, (String)("Url: " + this.getUrl()));
        Log.d((String)TAG, (String)("Status code: " + statusCode));
        Log.d((String)TAG, (String)("Response: " + response));
    }
}

