/*
 * Decompiled with CFR 0.152.
 */
package com.example.networklibrary.network.parsing;

import com.example.networklibrary.network.parsing.Optional;
import com.example.networklibrary.network.parsing.ReflectionUtil;
import com.example.networklibrary.network.parsing.Required;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnnotatedDeserializer<T>
implements JsonDeserializer<T> {
    public T deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
        Object target = new Gson().fromJson(je, type);
        this.checkRequired(target);
        return (T)target;
    }

    private void checkRequired(Object target) {
        ArrayList<Field> invalidFields = new ArrayList<Field>();
        this.findMissingFields(target, invalidFields);
        if (!invalidFields.isEmpty()) {
            String message = new String("Missing fields: {");
            for (Field f : invalidFields) {
                message = message.concat(f.getDeclaringClass().getSimpleName() + "/" + f.getName() + ", ");
            }
            message = message.substring(0, message.length() - 2);
            message = message.concat("}");
            throw new JsonParseException(message);
        }
    }

    private List<Field> findMissingFields(Object target, List<Field> invalidFields) {
        for (Field field : target.getClass().getDeclaredFields()) {
            boolean optional;
            boolean required = field.getAnnotation(Required.class) != null;
            boolean bl = optional = field.getAnnotation(Optional.class) != null;
            if (!required && !optional) continue;
            Object fieldValue = ReflectionUtil.getFieldValue(target, field);
            if (required && (fieldValue == null || String.class.equals(field.getClass()) && ((String)fieldValue).isEmpty())) {
                invalidFields.add(field);
            }
            if (fieldValue != null && fieldValue instanceof Collection) {
                for (Object item : (Collection)fieldValue) {
                    this.findMissingFields(item, invalidFields);
                }
                continue;
            }
            if (fieldValue == null || fieldValue.getClass().isPrimitive()) continue;
            this.findMissingFields(fieldValue, invalidFields);
        }
        return invalidFields;
    }
}

