/*
 * Decompiled with CFR 0.152.
 */
package com.example.networklibrary;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.support.v7.preference.PreferenceManager;

public class NetworkBaseUrl {
    private static NetworkBaseUrl instance;
    private Context context;
    private PreferenceManager privateManager;

    public static void init(Context context) {
        if (instance == null) {
            instance = new NetworkBaseUrl(context);
        }
    }

    public static void clearData() {
        if (instance != null) {
            SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)NetworkBaseUrl.instance.context).edit();
            editor.clear();
            editor.apply();
        }
    }

    private NetworkBaseUrl(Context context) {
        this.context = context.getApplicationContext();
        this.privateManager = new PreferenceManager(context);
        this.privateManager.setSharedPreferencesName("com.xtempo.q2t.permanent_preferences");
        this.privateManager.setSharedPreferencesMode(0);
        this.privateManager.setStorageDeviceProtected();
    }

    public static void restartApp() {
        if (instance != null) {
            Intent intent = NetworkBaseUrl.instance.context.getPackageManager().getLaunchIntentForPackage(NetworkBaseUrl.instance.context.getPackageName());
            intent.addFlags(0x10008000);
            NetworkBaseUrl.instance.context.startActivity(intent);
        }
    }

    public static void setBaseUrl(String baseUrl) {
        NetworkBaseUrl.instance.privateManager.getSharedPreferences().edit().putString("base_url", baseUrl).apply();
    }

    public static String getBaseUrl() {
        return NetworkBaseUrl.instance.privateManager.getSharedPreferences().getString("base_url", "");
    }
}

