/*
 * Decompiled with CFR 0.152.
 */
package com.pyamsoft.pydroid.loader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import com.pyamsoft.pydroid.loader.GlideBitmapLoader;
import com.pyamsoft.pydroid.loader.GlideByteArrayLoader;
import com.pyamsoft.pydroid.loader.GlideResourceLoader;
import com.pyamsoft.pydroid.loader.ImageLoader;
import com.pyamsoft.pydroid.loader.Loader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\b\b\u0001\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/pyamsoft/pydroid/loader/ImageLoaderImpl;", "Lcom/pyamsoft/pydroid/loader/ImageLoader;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "load", "Lcom/pyamsoft/pydroid/loader/Loader;", "Landroid/graphics/Bitmap;", "bitmap", "data", "", "Landroid/graphics/drawable/Drawable;", "resource", "", "loader_release"})
public final class ImageLoaderImpl
implements ImageLoader {
    private final Context context;

    @Override
    @NotNull
    public Loader<Drawable> load(@DrawableRes int resource) {
        Context context = this.context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context.applicationContext");
        return new GlideResourceLoader(context, resource);
    }

    @Override
    @NotNull
    public Loader<Bitmap> load(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return new GlideByteArrayLoader(data);
    }

    @Override
    @NotNull
    public Loader<Bitmap> load(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        return new GlideBitmapLoader(bitmap);
    }

    public ImageLoaderImpl(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

