package com.pushpole.sdk.task.tasks;

import android.content.Context;
import android.content.Intent;

import com.pushpole.sdk.Constants;
import com.pushpole.sdk.internal.db.KeyStore;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.task.PushPoleTask;
import com.pushpole.sdk.task.Result;
import com.pushpole.sdk.task.options.DefaultOptions;
import com.pushpole.sdk.task.options.SingletonTask;
import com.pushpole.sdk.util.Pack;

/**
 * Created on 16-08-22, 3:51 PM.
 * @author Akram Shokri
 *
 * Broadcast task which will send a broadcast to other pushpole-container-apps, if this app is responsible
 * for sending common device data to server.
 * The last pushpole-container-app which is instaled will become the in-charge app. If no broadcast is
 * received within 24 hours, the first pushpole-container-app who's BroadcastTask runs, will become the
 * in-charge app.
 */



@SingletonTask
@DefaultOptions(period = 6 * 3600 * 1000, persisted = true) //runs every 6 hours
public class BroadcastTask implements PushPoleTask {
    @Override
    public Result runTask(Context context, Pack taskPack) {
        long sendDataTimestamp = KeyStore.getInstance(context).getLong(Constants.getVal(Constants.LAST_SEND_UPSTREAM_TIME), 0);

        long now = System.currentTimeMillis();
        //sendDataTimestamp=0 means  no notify pushpole apps is received before, this app should send device data
        if (sendDataTimestamp == 0 || (now - sendDataTimestamp) > 24 * 3600000) { //if last received broadcast was at least 24 hours ago
            //Send broadcast message to notify other pushpole apps that this app will send device data
            Intent intent = new Intent(Constants.getVal(Constants.NOTIFY_OTHER_PUSHPOLE_APP_INTENT_ACTION));
            intent.putExtra(Constants.getVal(Constants.NOTIFY_OTHER_APP_CALLER_PACKAGE), context.getPackageName());
            Logger.debug("Sending Notify-PushPole-App broadcast");
            context.sendBroadcast(intent);
        }
        return Result.SUCCESS;
    }
}
