package com.pushpole.sdk.task.scheduler.evernote;


import androidx.annotation.NonNull;

import com.evernote.android.job.Job;

import com.pushpole.sdk.internal.log.ExceptionCatcher;
import com.pushpole.sdk.internal.log.Logger;
import com.pushpole.sdk.task.TaskManager;

/**
 * Created by hadi on 7/20/16.
 */
class EvernoteJobAdapter extends Job {
    private String mTag;

    public EvernoteJobAdapter(String tag) {
        mTag = tag;
    }

    @NonNull
    @Override
    protected Result onRunJob(Params params) {
        Logger.initialize(getContext());
        ExceptionCatcher.makePushPoleDefaultExceptionCatcher(getContext());

        com.pushpole.sdk.task.Result result = TaskManager.getInstance(getContext()).handleScheduledTask(mTag);
        switch (result) {
            case SUCCESS:
                return Result.SUCCESS;
            case FAIL:
                return Result.FAILURE;
            case RESCHEDULE:
                return Result.RESCHEDULE;
        }
        return Result.FAILURE;
    }
}
